/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.adventure.farming.config.stages.spread;

import com.hypixel.hytale.builtin.adventure.farming.config.stages.spread.SpreadGrowthBehaviour;
import com.hypixel.hytale.builtin.adventure.farming.states.FarmingBlock;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.codecs.array.ArrayCodec;
import com.hypixel.hytale.codec.validation.Validators;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.math.range.IntRange;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.math.util.HashUtil;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.farming.FarmingStageData;
import com.hypixel.hytale.server.core.universe.world.chunk.section.ChunkSection;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpreadFarmingStageData
extends FarmingStageData {
    @Nonnull
    public static BuilderCodec<SpreadFarmingStageData> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SpreadFarmingStageData.class, SpreadFarmingStageData::new, FarmingStageData.BASE_CODEC).append(new KeyedCodec<IntRange>("Executions", IntRange.CODEC), (spreadFarmingStageData, intRange) -> {
        spreadFarmingStageData.executions = intRange;
    }, spreadFarmingStageData -> spreadFarmingStageData.executions).documentation("Defines the number of times the stage will be repeated. Range must be positive, min value must be >= 1.").addValidator(Validators.nonNull()).add()).append(new KeyedCodec<IntRange>("SpreadDecayPercent", IntRange.CODEC), (spreadFarmingStageData, intRange) -> {
        spreadFarmingStageData.spreadDecayPercent = intRange;
    }, spreadFarmingStageData -> spreadFarmingStageData.spreadDecayPercent).documentation("The amount to reduce (linear decay) the spread rate (chance to spread) for any spawned blocks that also have a spread stage. Range must be positive.").addValidator(Validators.nonNull()).add()).append(new KeyedCodec<T[]>("GrowthBehaviours", new ArrayCodec<SpreadGrowthBehaviour>(SpreadGrowthBehaviour.CODEC, SpreadGrowthBehaviour[]::new)), (spreadFarmingStageData, spreadGrowthBehaviour) -> {
        spreadFarmingStageData.spreadGrowthBehaviours = spreadGrowthBehaviour;
    }, spreadFarmingStageData -> spreadFarmingStageData.spreadGrowthBehaviours).documentation("Defines an array of the different growth behaviours that'll be run for each execution.").addValidator(Validators.nonEmptyArray()).add()).afterDecode(stageData -> {
        if (stageData.executions != null && stageData.executions.getInclusiveMin() < 1) {
            throw new IllegalArgumentException("The min value for Executions range must be >= 1! Current min value is: " + stageData.executions.getInclusiveMin());
        }
        if (stageData.spreadDecayPercent != null && stageData.spreadDecayPercent.getInclusiveMin() < 0) {
            throw new IllegalArgumentException("The min value for SpreadDecayPercent range must be >= 0! Current min value is: " + stageData.spreadDecayPercent.getInclusiveMin());
        }
    })).build();
    protected IntRange executions;
    protected IntRange spreadDecayPercent;
    protected SpreadGrowthBehaviour[] spreadGrowthBehaviours;

    public IntRange getExecutions() {
        return this.executions;
    }

    public IntRange getSpreadDecayPercent() {
        return this.spreadDecayPercent;
    }

    public SpreadGrowthBehaviour[] getSpreadGrowthBehaviours() {
        return this.spreadGrowthBehaviours;
    }

    @Override
    public boolean implementsShouldStop() {
        return true;
    }

    @Override
    public boolean shouldStop(ComponentAccessor<ChunkStore> commandBuffer, Ref<ChunkStore> sectionRef, Ref<ChunkStore> blockRef, int x, int y, int z) {
        FarmingBlock farming = commandBuffer.getComponent(blockRef, FarmingBlock.getComponentType());
        float spreadRate = farming.getSpreadRate();
        ChunkSection section = commandBuffer.getComponent(sectionRef, ChunkSection.getComponentType());
        int worldX = ChunkUtil.worldCoordFromLocalCoord(section.getX(), x);
        int worldY = ChunkUtil.worldCoordFromLocalCoord(section.getY(), y);
        int worldZ = ChunkUtil.worldCoordFromLocalCoord(section.getZ(), z);
        float executions = (float)this.executions.getInt(HashUtil.random(worldX, worldY, worldZ, farming.getGeneration())) * spreadRate;
        int executed = farming.getExecutions();
        return spreadRate <= 0.0f || (float)executed >= executions;
    }

    @Override
    public void apply(ComponentAccessor<ChunkStore> commandBuffer, Ref<ChunkStore> sectionRef, Ref<ChunkStore> blockRef, int x, int y, int z, @Nullable FarmingStageData previousStage) {
        super.apply(commandBuffer, sectionRef, blockRef, x, y, z, previousStage);
        FarmingBlock farming = commandBuffer.getComponent(blockRef, FarmingBlock.getComponentType());
        ChunkSection section = commandBuffer.getComponent(sectionRef, ChunkSection.getComponentType());
        int worldX = ChunkUtil.worldCoordFromLocalCoord(section.getX(), x);
        int worldY = ChunkUtil.worldCoordFromLocalCoord(section.getY(), y);
        int worldZ = ChunkUtil.worldCoordFromLocalCoord(section.getZ(), z);
        float spreadRate = farming.getSpreadRate();
        double executions = Math.floor((float)this.executions.getInt(HashUtil.random(worldX, worldY, worldZ, farming.getGeneration())) * spreadRate);
        int executed = farming.getExecutions();
        if (spreadRate <= 0.0f || (double)executed >= executions) {
            return;
        }
        for (int i = 0; i < this.spreadGrowthBehaviours.length; ++i) {
            SpreadGrowthBehaviour spreadGrowthBehaviour = this.spreadGrowthBehaviours[i];
            float decayRate = (float)this.spreadDecayPercent.getInt(HashUtil.random((long)i | (long)farming.getGeneration() << 32, worldX, worldY, worldZ)) / 100.0f;
            spreadGrowthBehaviour.execute(commandBuffer, sectionRef, blockRef, worldX, worldY, worldZ, spreadRate - decayRate);
        }
        farming.setExecutions(++executed);
    }

    @Override
    public void remove(ComponentAccessor<ChunkStore> commandBuffer, Ref<ChunkStore> sectionRef, Ref<ChunkStore> blockRef, int x, int y, int z) {
        super.remove(commandBuffer, sectionRef, blockRef, x, y, z);
    }

    @Override
    @Nonnull
    public String toString() {
        return "SpreadFarmingStageData{executions=" + String.valueOf(this.executions) + ", spreadDecayPercent=" + String.valueOf(this.spreadDecayPercent) + ", spreadGrowthBehaviours=" + Arrays.toString(this.spreadGrowthBehaviours) + "} " + super.toString();
    }
}

