/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.adventure.farming.config.stages.spread;

import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.codecs.array.ArrayCodec;
import com.hypixel.hytale.codec.lookup.CodecMapCodec;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import com.hypixel.hytale.server.core.universe.world.worldlocationcondition.WorldLocationCondition;

public abstract class SpreadGrowthBehaviour {
    public static final CodecMapCodec<SpreadGrowthBehaviour> CODEC = new CodecMapCodec("Type");
    public static final BuilderCodec<SpreadGrowthBehaviour> BASE_CODEC = ((BuilderCodec.Builder)BuilderCodec.abstractBuilder(SpreadGrowthBehaviour.class).append(new KeyedCodec<T[]>("LocationConditions", new ArrayCodec<WorldLocationCondition>(WorldLocationCondition.CODEC, WorldLocationCondition[]::new)), (spreadGrowthBehaviour, worldLocationConditions) -> {
        spreadGrowthBehaviour.worldLocationConditions = worldLocationConditions;
    }, spreadGrowthBehaviour -> spreadGrowthBehaviour.worldLocationConditions).documentation("Defines the possible location conditions a position has to fulfill to be considered as valid.").add()).build();
    protected WorldLocationCondition[] worldLocationConditions;

    public abstract void execute(ComponentAccessor<ChunkStore> var1, Ref<ChunkStore> var2, Ref<ChunkStore> var3, int var4, int var5, int var6, float var7);

    protected boolean validatePosition(World world, int worldX, int worldY, int worldZ) {
        if (this.worldLocationConditions == null) {
            return true;
        }
        for (int i = 0; i < this.worldLocationConditions.length; ++i) {
            if (this.worldLocationConditions[i].test(world, worldX, worldY, worldZ)) continue;
            return false;
        }
        return true;
    }
}

