/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.adventure.memories.interactions;

import com.hypixel.hytale.builtin.adventure.memories.component.PlayerMemories;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.protocol.InteractionState;
import com.hypixel.hytale.protocol.InteractionType;
import com.hypixel.hytale.protocol.WaitForDataFrom;
import com.hypixel.hytale.protocol.packets.player.UpdateMemoriesFeatureStatus;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.InteractionContext;
import com.hypixel.hytale.server.core.io.PacketHandler;
import com.hypixel.hytale.server.core.modules.interaction.interaction.CooldownHandler;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.SimpleInstantInteraction;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.NotificationUtil;
import javax.annotation.Nonnull;

public class SetMemoriesCapacityInteraction
extends SimpleInstantInteraction {
    public static final BuilderCodec<SetMemoriesCapacityInteraction> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(SetMemoriesCapacityInteraction.class, SetMemoriesCapacityInteraction::new, SimpleInstantInteraction.CODEC).documentation("Sets how many memories a player can store.")).appendInherited(new KeyedCodec<Integer>("Capacity", Codec.INTEGER), (i, s) -> {
        i.capacity = s;
    }, i -> i.capacity, (i, parent) -> {
        i.capacity = parent.capacity;
    }).documentation("Defines the amount of memories that a player can store.").add()).build();
    private int capacity;

    @Override
    protected void firstRun(@Nonnull InteractionType type, @Nonnull InteractionContext context, @Nonnull CooldownHandler cooldownHandler) {
        Ref<EntityStore> ref = context.getEntity();
        CommandBuffer<EntityStore> commandBuffer = context.getCommandBuffer();
        assert (commandBuffer != null);
        PlayerMemories memoriesComponent = commandBuffer.ensureAndGetComponent(ref, PlayerMemories.getComponentType());
        if (this.capacity <= memoriesComponent.getMemoriesCapacity()) {
            context.getState().state = InteractionState.Failed;
            return;
        }
        int previousCapacity = memoriesComponent.getMemoriesCapacity();
        memoriesComponent.setMemoriesCapacity(this.capacity);
        if (previousCapacity <= 0) {
            PlayerRef playerRefComponent = commandBuffer.getComponent(ref, PlayerRef.getComponentType());
            assert (playerRefComponent != null);
            PacketHandler playerConnection = playerRefComponent.getPacketHandler();
            playerConnection.writeNoCache(new UpdateMemoriesFeatureStatus(true));
            NotificationUtil.sendNotification(playerConnection, Message.translation("server.memories.general.featureUnlockedNotification"), null, "NotificationIcons/MemoriesIcon.png");
            playerRefComponent.sendMessage(Message.translation("server.memories.general.featureUnlockedMessage"));
        }
        context.getState().state = InteractionState.Finished;
    }

    @Override
    @Nonnull
    public WaitForDataFrom getWaitForDataFrom() {
        return WaitForDataFrom.Server;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

