/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.adventure.memories.window;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.hypixel.hytale.builtin.adventure.memories.MemoriesPlugin;
import com.hypixel.hytale.builtin.adventure.memories.component.PlayerMemories;
import com.hypixel.hytale.builtin.adventure.memories.memories.Memory;
import com.hypixel.hytale.codec.EmptyExtraInfo;
import com.hypixel.hytale.codec.ExtraInfo;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.protocol.packets.window.WindowType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.player.windows.Window;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.BsonUtil;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MemoriesWindow
extends Window {
    private final JsonObject windowData = new JsonObject();

    public MemoriesWindow() {
        super(WindowType.Memories);
    }

    @Override
    @Nonnull
    public JsonObject getData() {
        return this.windowData;
    }

    @Override
    public boolean onOpen0() {
        JsonArray array = new JsonArray();
        Ref<EntityStore> ref = this.getPlayerRef().getReference();
        PlayerMemories playerMemories = ref.getStore().getComponent(ref, PlayerMemories.getComponentType());
        if (playerMemories != null) {
            this.windowData.addProperty("capacity", playerMemories.getMemoriesCapacity());
            for (Memory memory : playerMemories.getRecordedMemories()) {
                String category;
                JsonObject obj = new JsonObject();
                obj.addProperty("title", memory.getTitle());
                obj.add("tooltipText", BsonUtil.translateBsonToJson(Message.CODEC.encode(memory.getTooltipText(), (ExtraInfo)EmptyExtraInfo.EMPTY).asDocument()));
                String iconPath = memory.getIconPath();
                if (iconPath != null && !iconPath.isEmpty()) {
                    obj.addProperty("icon", iconPath);
                }
                if ((category = MemoriesWindow.GetCategoryIconPathForMemory(memory)) != null) {
                    obj.addProperty("categoryIcon", category);
                }
                array.add(obj);
            }
        } else {
            this.windowData.addProperty("capacity", 0);
        }
        this.windowData.add("memories", array);
        this.invalidate();
        return true;
    }

    @Nullable
    private static String GetCategoryIconPathForMemory(@Nonnull Memory memory) {
        Map<String, Set<Memory>> allMemories = MemoriesPlugin.get().getAllMemories();
        for (Map.Entry<String, Set<Memory>> entry : allMemories.entrySet()) {
            if (!entry.getValue().contains(memory)) continue;
            String memoryCategoryIconBasePath = "UI/Custom/Pages/Memories/categories/%s.png";
            return String.format("UI/Custom/Pages/Memories/categories/%s.png", entry.getKey());
        }
        return null;
    }

    @Override
    public void onClose0() {
    }
}

