/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.buildertools.scriptedbrushes.commands;

import com.hypixel.hytale.builtin.buildertools.scriptedbrushes.BrushConfigCommandExecutor;
import com.hypixel.hytale.builtin.buildertools.scriptedbrushes.operations.system.BrushOperationSetting;
import com.hypixel.hytale.builtin.buildertools.scriptedbrushes.operations.system.GlobalBrushOperation;
import com.hypixel.hytale.builtin.buildertools.scriptedbrushes.operations.system.SequenceBrushOperation;
import com.hypixel.hytale.builtin.buildertools.tooloperations.ToolOperation;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.core.util.message.MessageFormat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import javax.annotation.Nonnull;

public class BrushConfigListCommand
extends AbstractPlayerCommand {
    public BrushConfigListCommand() {
        super("list", "List the brush config operations that are currently set");
    }

    @Override
    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        UUIDComponent uuidComponent = store.getComponent(ref, UUIDComponent.getComponentType());
        assert (uuidComponent != null);
        BrushConfigCommandExecutor brushConfigCommandExecutor = ToolOperation.getOrCreatePrototypeSettings(uuidComponent.getUuid()).getBrushConfigCommandExecutor();
        Message header = Message.translation("server.commands.brushConfig.list.globalOperation.header");
        ObjectArrayList<Message> values = new ObjectArrayList<Message>();
        for (GlobalBrushOperation globalBrushOperation : brushConfigCommandExecutor.getGlobalOperations().values()) {
            values.add(Message.translation("server.commands.brushConfig.list.globalOperation").param("name", globalBrushOperation.getName()));
            for (Map.Entry<String, BrushOperationSetting<?>> entry : globalBrushOperation.getRegisteredOperationSettings().entrySet()) {
                values.add(Message.translation("server.commands.brushConfig.list.setting").param("name", entry.getKey()).param("value", entry.getValue().getValueString()));
            }
        }
        playerRef.sendMessage(MessageFormat.list(header, values));
        header = Message.translation("server.commands.brushConfig.list.sequentialOperation.header");
        values = new ObjectArrayList();
        for (int i = 0; i < brushConfigCommandExecutor.getSequentialOperations().size(); ++i) {
            SequenceBrushOperation sequenceBrushOperation = brushConfigCommandExecutor.getSequentialOperations().get(i);
            values.add(Message.translation("server.commands.brushConfig.list.sequentialOperation").param("index", i).param("name", sequenceBrushOperation.getName()));
            for (Map.Entry<String, BrushOperationSetting<?>> entry : sequenceBrushOperation.getRegisteredOperationSettings().entrySet()) {
                values.add(Message.translation("server.commands.brushConfig.list.setting").param("name", entry.getKey()).param("value", entry.getValue().getValueString()));
            }
        }
        playerRef.sendMessage(MessageFormat.list(header, values));
    }
}

