/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.crafting.window;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.hypixel.hytale.builtin.adventure.memories.MemoriesGameplayConfig;
import com.hypixel.hytale.builtin.crafting.CraftingPlugin;
import com.hypixel.hytale.builtin.crafting.component.CraftingManager;
import com.hypixel.hytale.builtin.crafting.state.BenchState;
import com.hypixel.hytale.builtin.crafting.window.BenchWindow;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.protocol.SoundCategory;
import com.hypixel.hytale.protocol.packets.window.CraftRecipeAction;
import com.hypixel.hytale.protocol.packets.window.WindowType;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.bench.CraftingBench;
import com.hypixel.hytale.server.core.asset.type.gameplay.GameplayConfig;
import com.hypixel.hytale.server.core.asset.type.item.config.CraftingRecipe;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.SoundUtil;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class CraftingWindow
extends BenchWindow {
    public static final int SET_BLOCK_SETTINGS = 6;
    protected static final String CRAFT_COMPLETED = "CraftCompleted";
    protected static final String CRAFT_COMPLETED_INSTANT = "CraftCompletedInstant";

    public CraftingWindow(@Nonnull WindowType windowType, BenchState benchState) {
        super(windowType, benchState);
        JsonArray categories = new JsonArray();
        CraftingBench.BenchCategory[] benchCategoryArray = this.bench;
        if (benchCategoryArray instanceof CraftingBench) {
            CraftingBench craftingBench = (CraftingBench)benchCategoryArray;
            for (CraftingBench.BenchCategory benchCategory : craftingBench.getCategories()) {
                JsonObject category = new JsonObject();
                categories.add(category);
                category.addProperty("id", benchCategory.getId());
                category.addProperty("name", benchCategory.getName());
                category.addProperty("icon", benchCategory.getIcon());
                Set<String> recipes = CraftingPlugin.getAvailableRecipesForCategory(this.bench.getId(), benchCategory.getId());
                if (recipes != null) {
                    JsonArray recipesArray = new JsonArray();
                    for (String recipeId : recipes) {
                        recipesArray.add(recipeId);
                    }
                    category.add("craftableRecipes", recipesArray);
                }
                if (benchCategory.getItemCategories() == null) continue;
                JsonArray itemCategories = new JsonArray();
                for (CraftingBench.BenchItemCategory benchItemCategory : benchCategory.getItemCategories()) {
                    JsonObject itemCategory = new JsonObject();
                    itemCategory.addProperty("id", benchItemCategory.getId());
                    itemCategory.addProperty("icon", benchItemCategory.getIcon());
                    itemCategory.addProperty("diagram", benchItemCategory.getDiagram());
                    itemCategory.addProperty("slots", benchItemCategory.getSlots());
                    itemCategory.addProperty("specialSlot", benchItemCategory.isSpecialSlot());
                    itemCategories.add(itemCategory);
                }
                category.add("itemCategories", itemCategories);
            }
            this.windowData.add("categories", categories);
        }
    }

    @Override
    protected boolean onOpen0() {
        int[] memoriesAmountPerLevel;
        super.onOpen0();
        PlayerRef playerRef = this.getPlayerRef();
        Ref<EntityStore> ref = playerRef.getReference();
        Store<EntityStore> store = ref.getStore();
        GameplayConfig gameplayConfig = store.getExternalData().getWorld().getGameplayConfig();
        MemoriesGameplayConfig memoriesConfig = MemoriesGameplayConfig.get(gameplayConfig);
        if (memoriesConfig != null && (memoriesAmountPerLevel = memoriesConfig.getMemoriesAmountPerLevel()) != null && memoriesAmountPerLevel.length > 1) {
            JsonArray memoriesPerLevel = new JsonArray();
            for (int i = 0; i < memoriesAmountPerLevel.length; ++i) {
                memoriesPerLevel.add(memoriesAmountPerLevel[i]);
            }
            this.windowData.add("memoriesPerLevel", memoriesPerLevel);
        }
        if (this.bench.getLocalOpenSoundEventIndex() != 0) {
            SoundUtil.playSoundEvent2d(ref, this.bench.getLocalOpenSoundEventIndex(), SoundCategory.UI, store);
        }
        return true;
    }

    @Override
    public void onClose0() {
        super.onClose0();
        PlayerRef playerRef = this.getPlayerRef();
        Ref<EntityStore> ref = playerRef.getReference();
        Store<EntityStore> store = ref.getStore();
        World world = store.getExternalData().getWorld();
        this.setBlockInteractionState(this.benchState.getTierStateName(), world, 6);
        if (this.bench.getLocalCloseSoundEventIndex() != 0) {
            SoundUtil.playSoundEvent2d(ref, this.bench.getLocalCloseSoundEventIndex(), SoundCategory.UI, store);
        }
    }

    public void setBlockInteractionState(@Nonnull String state, @Nonnull World world, int setBlockSettings) {
        Object worldChunk = world.getChunk(ChunkUtil.indexChunkFromBlock(this.x, this.z));
        BlockType blockType = worldChunk.getBlockType(this.x, this.y, this.z);
        worldChunk.setBlockInteractionState(this.x, this.y, this.z, blockType, state, true);
    }

    public static boolean craftSimpleItem(@Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull CraftingManager craftingManager, @Nonnull CraftRecipeAction action) {
        String recipeId = action.recipeId;
        int quantity = action.quantity;
        if (recipeId == null) {
            return false;
        }
        CraftingRecipe recipe = CraftingRecipe.getAssetMap().getAsset(recipeId);
        if (recipe == null) {
            PlayerRef playerRef = store.getComponent(ref, PlayerRef.getComponentType());
            playerRef.getPacketHandler().disconnect("Attempted to craft unknown recipe!");
            return false;
        }
        Player player = store.getComponent(ref, Player.getComponentType());
        craftingManager.craftItem(ref, store, recipe, quantity, player.getInventory().getCombinedBackpackStorageHotbar());
        return true;
    }
}

