/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.hytalegenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public class ArrayUtil {
    @Nonnull
    public static <T> T[] brokenCopyOf(@Nonnull T[] a) {
        Object[] copy = new Object[a.length];
        System.arraycopy(a, 0, copy, 0, a.length);
        return copy;
    }

    public static <T> void copy(@Nonnull T[] source, @Nonnull T[] destination) {
        if (source.length != destination.length) {
            throw new IllegalArgumentException("arrays must have the same size");
        }
        System.arraycopy(source, 0, destination, 0, source.length);
    }

    @Nonnull
    public static <T> T[] append(@Nonnull T[] a, T e) {
        Object[] expanded = new Object[a.length + 1];
        System.arraycopy(a, 0, expanded, 0, a.length);
        expanded[a.length] = e;
        return expanded;
    }

    @Nonnull
    public static <T> List<List<T>> split(@Nonnull List<T> list, int partCount) {
        if (partCount < 1) {
            throw new IllegalArgumentException("parts must be greater than 0");
        }
        if (partCount == 1) {
            return Collections.singletonList(list);
        }
        ArrayList<List<T>> out = new ArrayList<List<T>>(partCount);
        int listSize = list.size();
        if (listSize <= partCount) {
            int i;
            for (i = 0; i < listSize; ++i) {
                out.add(List.of(list.get(i)));
            }
            for (i = listSize; i < partCount; ++i) {
                out.add(List.of());
            }
            return out;
        }
        int[] partSizes = ArrayUtil.getPartSizes(listSize, partCount);
        int elementIndex = 0;
        for (int partIndex = 0; partIndex < partCount; ++partIndex) {
            int partSize = partSizes[partIndex];
            ArrayList<T> partList = new ArrayList<T>(partSize);
            for (int i = 0; i < partSize; ++i) {
                partList.add(list.get(elementIndex++));
            }
            out.add(partList);
        }
        return out;
    }

    public static int[] getPartSizes(int total, int partCount) {
        if (total < 0 || partCount < 1) {
            throw new IllegalArgumentException("total and/or parts must be greater than 0");
        }
        if (total == 0) {
            return new int[]{total};
        }
        int[] sizes = new int[partCount];
        int baseSize = total / partCount;
        int remainder = total % partCount;
        for (int i = 0; i < partCount; ++i) {
            sizes[i] = i < remainder ? baseSize + 1 : baseSize;
        }
        return sizes;
    }

    public static <T, G> int sortedSearch(@Nonnull List<T> sortedList, @Nonnull G gauge, @Nonnull BiFunction<G, T, Integer> comparator) {
        int BINARY_SIZE_THRESHOLD = 250;
        if (sortedList.isEmpty()) {
            return -1;
        }
        if (sortedList.size() == 1) {
            if (comparator.apply(gauge, sortedList.getFirst()) == 0) {
                return 0;
            }
            return -1;
        }
        if (sortedList.size() <= 250) {
            for (int i = 0; i < sortedList.size(); ++i) {
                if (comparator.apply(gauge, sortedList.get(i)) != 0) continue;
                return i;
            }
            return -1;
        }
        return ArrayUtil.binarySearch(sortedList, gauge, comparator);
    }

    public static <T, G> int binarySearch(@Nonnull List<T> sortedList, @Nonnull G gauge, @Nonnull BiFunction<G, T, Integer> comparator) {
        if (sortedList.isEmpty()) {
            return -1;
        }
        int min = 0;
        int max = sortedList.size();
        int index;
        T item;
        int comparison;
        while ((comparison = comparator.apply(gauge, item = sortedList.get(index = (max + min) / 2)).intValue()) != 0) {
            if (min == max - 1) {
                return -1;
            }
            if (comparison == -1) {
                max = index;
            }
            if (comparison != 1) continue;
            min = index;
        }
        return index;
    }
}

