/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.hytalegenerator.assets.curves;

import com.hypixel.hytale.builtin.hytalegenerator.assets.curves.ConstantCurveAsset;
import com.hypixel.hytale.builtin.hytalegenerator.assets.curves.CurveAsset;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import javax.annotation.Nonnull;

public class FloorCurveAsset
extends CurveAsset {
    public static final BuilderCodec<FloorCurveAsset> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(FloorCurveAsset.class, FloorCurveAsset::new, CurveAsset.ABSTRACT_CODEC).append(new KeyedCodec("Curve", CurveAsset.CODEC, true), (t, k) -> {
        t.curveAsset = k;
    }, k -> k.curveAsset).add()).append(new KeyedCodec<Double>("Floor", Codec.DOUBLE, true), (t, k) -> {
        t.limit = k;
    }, k -> k.limit).add()).build();
    private CurveAsset curveAsset = new ConstantCurveAsset();
    private double limit = 0.0;

    @Override
    @Nonnull
    public Double2DoubleFunction build() {
        if (this.curveAsset == null) {
            return in -> 0.0;
        }
        Double2DoubleFunction curve = this.curveAsset.build();
        return in -> Math.max(this.limit, curve.applyAsDouble(in));
    }

    @Override
    public void cleanUp() {
        this.curveAsset.cleanUp();
    }
}

