/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.hytalegenerator.assets.density;

import com.hypixel.hytale.builtin.hytalegenerator.assets.density.DensityAsset;
import com.hypixel.hytale.builtin.hytalegenerator.density.Density;
import com.hypixel.hytale.builtin.hytalegenerator.density.nodes.ConstantValueDensity;
import com.hypixel.hytale.builtin.hytalegenerator.density.nodes.Noise3dDensity;
import com.hypixel.hytale.builtin.hytalegenerator.fields.FastNoiseLite;
import com.hypixel.hytale.builtin.hytalegenerator.fields.noise.CellNoiseField;
import com.hypixel.hytale.builtin.hytalegenerator.seed.SeedBox;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.validation.Validators;
import javax.annotation.Nonnull;

public class CellNoise3DDensityAsset
extends DensityAsset {
    public static final BuilderCodec<CellNoise3DDensityAsset> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(CellNoise3DDensityAsset.class, CellNoise3DDensityAsset::new, DensityAsset.ABSTRACT_CODEC).append(new KeyedCodec<Double>("ScaleX", Codec.DOUBLE, true), (asset, scale) -> {
        asset.scaleX = scale;
    }, asset -> asset.scaleX).addValidator(Validators.greaterThan(0.0)).add()).append(new KeyedCodec<Double>("ScaleY", Codec.DOUBLE, true), (asset, scale) -> {
        asset.scaleY = scale;
    }, asset -> asset.scaleY).addValidator(Validators.greaterThan(0.0)).add()).append(new KeyedCodec<Double>("ScaleZ", Codec.DOUBLE, true), (asset, scale) -> {
        asset.scaleZ = scale;
    }, asset -> asset.scaleZ).addValidator(Validators.greaterThan(0.0)).add()).append(new KeyedCodec<Double>("Jitter", Codec.DOUBLE, true), (asset, v) -> {
        asset.jitter = v;
    }, asset -> asset.scaleZ).add()).append(new KeyedCodec<Integer>("Octaves", Codec.INTEGER, true), (asset, octaves) -> {
        asset.octaves = octaves;
    }, asset -> asset.octaves).addValidator(Validators.greaterThan(0)).add()).append(new KeyedCodec<String>("Seed", Codec.STRING, true), (asset, seed) -> {
        asset.seedKey = seed;
    }, asset -> asset.seedKey).add()).append(new KeyedCodec<FastNoiseLite.CellularReturnType>("CellType", FastNoiseLite.CellularReturnType.CODEC, true), (asset, cellType) -> {
        asset.cellType = cellType;
    }, asset -> asset.cellType).add()).build();
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double scaleZ = 1.0;
    private double jitter = 0.5;
    private int octaves = 1;
    private String seedKey = "A";
    private FastNoiseLite.CellularReturnType cellType = FastNoiseLite.CellularReturnType.CellValue;

    @Override
    @Nonnull
    public Density build(@Nonnull DensityAsset.Argument argument) {
        if (this.isSkipped()) {
            return new ConstantValueDensity(0.0);
        }
        SeedBox childSeed = argument.parentSeed.child(this.seedKey);
        CellNoiseField noise = new CellNoiseField(childSeed.createSupplier().get(), this.scaleX, this.scaleY, this.scaleZ, this.jitter, this.octaves, this.cellType);
        return new Noise3dDensity(noise);
    }

    @Override
    public void cleanUp() {
        this.cleanUpInputs();
    }
}

