/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.hytalegenerator.biome;

import com.hypixel.hytale.builtin.hytalegenerator.PropField;
import com.hypixel.hytale.builtin.hytalegenerator.biome.BiomeType;
import com.hypixel.hytale.builtin.hytalegenerator.density.Density;
import com.hypixel.hytale.builtin.hytalegenerator.environmentproviders.EnvironmentProvider;
import com.hypixel.hytale.builtin.hytalegenerator.material.Material;
import com.hypixel.hytale.builtin.hytalegenerator.materialproviders.MaterialProvider;
import com.hypixel.hytale.builtin.hytalegenerator.propdistributions.Assignments;
import com.hypixel.hytale.builtin.hytalegenerator.tintproviders.TintProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class SimpleBiomeType
implements BiomeType {
    private final Density terrainDensity;
    private final MaterialProvider<Material> materialProvider;
    private final List<PropField> propFields;
    private final EnvironmentProvider environmentProvider;
    private final TintProvider tintProvider;
    private final String biomeName;

    public SimpleBiomeType(@Nonnull String biomeName, @Nonnull Density terrainDensity, @Nonnull MaterialProvider<Material> materialProvider, @Nonnull EnvironmentProvider environmentProvider, @Nonnull TintProvider tintProvider) {
        this.terrainDensity = terrainDensity;
        this.materialProvider = materialProvider;
        this.biomeName = biomeName;
        this.propFields = new ArrayList<PropField>();
        this.environmentProvider = environmentProvider;
        this.tintProvider = tintProvider;
    }

    public void addPropFieldTo(@Nonnull PropField propField) {
        this.propFields.add(propField);
    }

    @Override
    public MaterialProvider<Material> getMaterialProvider() {
        return this.materialProvider;
    }

    @Override
    @Nonnull
    public Density getTerrainDensity() {
        return this.terrainDensity;
    }

    @Override
    public String getBiomeName() {
        return this.biomeName;
    }

    @Override
    public List<PropField> getPropFields() {
        return this.propFields;
    }

    @Override
    public EnvironmentProvider getEnvironmentProvider() {
        return this.environmentProvider;
    }

    @Override
    public TintProvider getTintProvider() {
        return this.tintProvider;
    }

    @Override
    public List<Assignments> getAllPropDistributions() {
        ArrayList<Assignments> list = new ArrayList<Assignments>();
        for (PropField f : this.propFields) {
            list.add(f.getPropDistribution());
        }
        return list;
    }
}

