/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.hytalegenerator.density.nodes;

import com.hypixel.hytale.builtin.hytalegenerator.density.Density;
import com.hypixel.hytale.builtin.hytalegenerator.fields.FastNoiseLite;
import com.hypixel.hytale.math.vector.Vector3d;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FastGradientWarpDensity
extends Density {
    private static final double HALF_PI = 1.5707963267948966;
    @Nullable
    private Density input;
    private final double warpScale;
    @Nonnull
    private final FastNoiseLite warper;

    public FastGradientWarpDensity(@Nonnull Density input, float warpLacunarity, float warpPersistence, int warpOctaves, float warpScale, float warpFactor, int seed) {
        if ((double)warpOctaves < 0.0) {
            throw new IllegalArgumentException();
        }
        this.warpScale = warpScale;
        this.input = input;
        this.warper = new FastNoiseLite();
        this.warper.setSeed(seed);
        this.warper.SetFractalGain(warpPersistence);
        this.warper.SetFractalLacunarity(warpLacunarity);
        this.warper.setDomainWarpType(FastNoiseLite.DomainWarpType.OpenSimplex2);
        this.warper.setFractalOctaves(warpOctaves);
        this.warper.setDomainWarpAmp(warpFactor);
        this.warper.setDomainWarpFreq(warpScale);
    }

    @Override
    public double process(@Nonnull Density.Context context) {
        if (this.input == null) {
            return 0.0;
        }
        FastNoiseLite.Vector3 warpedPosition = new FastNoiseLite.Vector3(context.position.x, context.position.y, context.position.z);
        this.warper.DomainWarpFractalProgressive(warpedPosition);
        Density.Context childContext = new Density.Context(context);
        childContext.position = new Vector3d(warpedPosition.x, warpedPosition.y, warpedPosition.z);
        return this.input.process(childContext);
    }

    @Override
    public void setInputs(@Nonnull Density[] inputs) {
        this.input = inputs.length == 1 ? inputs[0] : null;
    }
}

