/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.hytalegenerator.density.nodes;

import com.hypixel.hytale.builtin.hytalegenerator.VectorUtil;
import com.hypixel.hytale.builtin.hytalegenerator.density.Density;
import com.hypixel.hytale.math.vector.Vector3d;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GradientDensity
extends Density {
    private static final double HALF_PI = 1.5707963267948966;
    @Nullable
    private Density input;
    private final double slopeRange;
    @Nonnull
    private final Vector3d axis;

    public GradientDensity(@Nonnull Density input, double slopeRange, @Nonnull Vector3d axis) {
        if (slopeRange <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.axis = axis.clone();
        this.slopeRange = slopeRange;
        this.input = input;
    }

    @Override
    public double process(@Nonnull Density.Context context) {
        if (this.input == null) {
            return 0.0;
        }
        double valueAtOrigin = this.input.process(context);
        double maxX = context.position.x + this.slopeRange;
        double maxY = context.position.y + this.slopeRange;
        double maxZ = context.position.z + this.slopeRange;
        Density.Context childContext = new Density.Context(context);
        childContext.position = new Vector3d(maxX, context.position.y, context.position.z);
        double deltaX = Math.abs(this.input.process(childContext) - valueAtOrigin);
        childContext.position = new Vector3d(context.position.x, maxY, context.position.z);
        double deltaY = Math.abs(this.input.process(childContext) - valueAtOrigin);
        childContext.position = new Vector3d(context.position.x, context.position.y, maxZ);
        double deltaZ = Math.abs(this.input.process(childContext) - valueAtOrigin);
        Vector3d slopeDirection = new Vector3d(deltaX, deltaY, deltaZ);
        double slopeAngle = VectorUtil.angle(this.axis, slopeDirection);
        if (slopeAngle > 1.5707963267948966) {
            slopeAngle = Math.PI - slopeAngle;
        }
        slopeAngle /= 1.5707963267948966;
        return slopeAngle *= 90.0;
    }

    @Override
    public void setInputs(@Nonnull Density[] inputs) {
        if (inputs.length == 0) {
            this.input = null;
        }
        this.input = inputs[0];
    }
}

