/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.portals.systems.voidevent;

import com.hypixel.hytale.builtin.portals.components.voidevent.VoidEvent;
import com.hypixel.hytale.builtin.portals.components.voidevent.config.VoidEventConfig;
import com.hypixel.hytale.builtin.portals.components.voidevent.config.VoidEventStage;
import com.hypixel.hytale.builtin.portals.resources.PortalWorld;
import com.hypixel.hytale.builtin.weather.resources.WeatherResource;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.tick.DelayedEntitySystem;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VoidEventStagesSystem
extends DelayedEntitySystem<EntityStore> {
    public VoidEventStagesSystem() {
        super(1.5f);
    }

    @Override
    public void tick(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        VoidEventStage desiredStage;
        VoidEvent voidEvent;
        PortalWorld portalWorld = store.getResource(PortalWorld.getResourceType());
        if (!portalWorld.exists()) {
            return;
        }
        Ref<EntityStore> eventRef = portalWorld.getVoidEventRef();
        VoidEvent voidEvent2 = voidEvent = eventRef == null ? null : commandBuffer.getComponent(eventRef, VoidEvent.getComponentType());
        if (voidEvent == null) {
            return;
        }
        World world = store.getExternalData().getWorld();
        VoidEventConfig voidEventConfig = portalWorld.getVoidEventConfig();
        double elapsedSecondsInPortal = portalWorld.getElapsedSeconds(world);
        int timeLimitSeconds = portalWorld.getTimeLimitSeconds();
        int shouldStartAfter = voidEventConfig.getShouldStartAfterSeconds(timeLimitSeconds);
        int elapsedSecondsInEvent = (int)Math.max(0.0, elapsedSecondsInPortal - (double)shouldStartAfter);
        VoidEventStage currentStage = voidEvent.getActiveStage();
        if (currentStage == (desiredStage = this.computeAppropriateStage(voidEventConfig, elapsedSecondsInEvent))) {
            return;
        }
        if (currentStage != null) {
            VoidEventStagesSystem.stopStage(currentStage, world, store, commandBuffer);
        }
        if (desiredStage != null) {
            VoidEventStagesSystem.startStage(desiredStage, world, store, commandBuffer);
        }
        voidEvent.setActiveStage(desiredStage);
    }

    @Nullable
    private VoidEventStage computeAppropriateStage(VoidEventConfig config, int elapsedSeconds) {
        List<VoidEventStage> stages = config.getStagesSortedByStartTime();
        for (int i = stages.size() - 1; i >= 0; --i) {
            VoidEventStage stage = stages.get(i);
            if (elapsedSeconds <= stage.getSecondsInto()) continue;
            return stage;
        }
        return null;
    }

    public static void startStage(VoidEventStage stage, World world, Store<EntityStore> store, CommandBuffer<EntityStore> commandBuffer) {
        HytaleLogger.getLogger().at(Level.INFO).log("Starting stage SecondsInto=" + stage.getSecondsInto() + " in portal void event");
        String forcedWeatherId = stage.getForcedWeatherId();
        if (forcedWeatherId != null) {
            WeatherResource weatherResource = store.getResource(WeatherResource.getResourceType());
            weatherResource.setForcedWeather(forcedWeatherId);
        }
    }

    public static void stopStage(VoidEventStage stage, World world, Store<EntityStore> store, CommandBuffer<EntityStore> commandBuffer) {
        HytaleLogger.getLogger().at(Level.INFO).log("Stopping stage SecondsInto=" + stage.getSecondsInto() + " in portal void event");
        String forcedWeatherId = stage.getForcedWeatherId();
        if (forcedWeatherId != null) {
            WeatherResource weatherResource = store.getResource(WeatherResource.getResourceType());
            weatherResource.setForcedWeather(null);
        }
    }

    @Override
    @Nullable
    public Query<EntityStore> getQuery() {
        return VoidEvent.getComponentType();
    }
}

