/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.builtin.weather.commands;

import com.hypixel.hytale.builtin.weather.resources.WeatherResource;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.type.weather.config.Weather;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractWorldCommand;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;

public class WeatherGetCommand
extends AbstractWorldCommand {
    @Nonnull
    private static final Message MESSAGE_COMMANDS_WEATHER_GET_FORCED_WEATHER = Message.translation("server.commands.weather.get.getForcedWeather");

    public WeatherGetCommand() {
        super("get", "server.commands.weather.get.desc");
    }

    @Override
    protected void execute(@Nonnull CommandContext context, @Nonnull World world, @Nonnull Store<EntityStore> store) {
        String weatherId;
        WeatherResource weatherResource = store.getResource(WeatherResource.getResourceType());
        int forcedWeatherIndex = weatherResource.getForcedWeatherIndex();
        if (forcedWeatherIndex != 0) {
            Weather weatherAsset = Weather.getAssetMap().getAsset(forcedWeatherIndex);
            weatherId = weatherAsset.getId();
        } else {
            weatherId = "not locked";
        }
        context.sendMessage(MESSAGE_COMMANDS_WEATHER_GET_FORCED_WEATHER.param("worldName", world.getName()).param("weather", weatherId));
    }
}

