/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol;

import com.hypixel.hytale.protocol.BenchType;
import com.hypixel.hytale.protocol.io.PacketIO;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BenchRequirement {
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 6;
    public static final int VARIABLE_FIELD_COUNT = 2;
    public static final int VARIABLE_BLOCK_START = 14;
    public static final int MAX_SIZE = 0x64000000;
    @Nonnull
    public BenchType type = BenchType.Crafting;
    @Nullable
    public String id;
    @Nullable
    public String[] categories;
    public int requiredTierLevel;

    public BenchRequirement() {
    }

    public BenchRequirement(@Nonnull BenchType type, @Nullable String id, @Nullable String[] categories, int requiredTierLevel) {
        this.type = type;
        this.id = id;
        this.categories = categories;
        this.requiredTierLevel = requiredTierLevel;
    }

    public BenchRequirement(@Nonnull BenchRequirement other) {
        this.type = other.type;
        this.id = other.id;
        this.categories = other.categories;
        this.requiredTierLevel = other.requiredTierLevel;
    }

    @Nonnull
    public static BenchRequirement deserialize(@Nonnull ByteBuf buf, int offset) {
        BenchRequirement obj = new BenchRequirement();
        byte nullBits = buf.getByte(offset);
        obj.type = BenchType.fromValue(buf.getByte(offset + 1));
        obj.requiredTierLevel = buf.getIntLE(offset + 2);
        if ((nullBits & 1) != 0) {
            int varPos0 = offset + 14 + buf.getIntLE(offset + 6);
            int idLen = VarInt.peek(buf, varPos0);
            if (idLen < 0) {
                throw ProtocolException.negativeLength("Id", idLen);
            }
            if (idLen > 4096000) {
                throw ProtocolException.stringTooLong("Id", idLen, 4096000);
            }
            obj.id = PacketIO.readVarString(buf, varPos0, PacketIO.UTF8);
        }
        if ((nullBits & 2) != 0) {
            int varPos1 = offset + 14 + buf.getIntLE(offset + 10);
            int categoriesCount = VarInt.peek(buf, varPos1);
            if (categoriesCount < 0) {
                throw ProtocolException.negativeLength("Categories", categoriesCount);
            }
            if (categoriesCount > 4096000) {
                throw ProtocolException.arrayTooLong("Categories", categoriesCount, 4096000);
            }
            int varIntLen = VarInt.length(buf, varPos1);
            if ((long)(varPos1 + varIntLen) + (long)categoriesCount * 1L > (long)buf.readableBytes()) {
                throw ProtocolException.bufferTooSmall("Categories", varPos1 + varIntLen + categoriesCount * 1, buf.readableBytes());
            }
            obj.categories = new String[categoriesCount];
            int elemPos = varPos1 + varIntLen;
            for (int i = 0; i < categoriesCount; ++i) {
                int strLen = VarInt.peek(buf, elemPos);
                if (strLen < 0) {
                    throw ProtocolException.negativeLength("categories[" + i + "]", strLen);
                }
                if (strLen > 4096000) {
                    throw ProtocolException.stringTooLong("categories[" + i + "]", strLen, 4096000);
                }
                int strVarLen = VarInt.length(buf, elemPos);
                obj.categories[i] = PacketIO.readVarString(buf, elemPos);
                elemPos += strVarLen + strLen;
            }
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int maxEnd = 14;
        if ((nullBits & 1) != 0) {
            int fieldOffset0 = buf.getIntLE(offset + 6);
            int pos0 = offset + 14 + fieldOffset0;
            int sl = VarInt.peek(buf, pos0);
            if ((pos0 += VarInt.length(buf, pos0) + sl) - offset > maxEnd) {
                maxEnd = pos0 - offset;
            }
        }
        if ((nullBits & 2) != 0) {
            int fieldOffset1 = buf.getIntLE(offset + 10);
            int pos1 = offset + 14 + fieldOffset1;
            int arrLen = VarInt.peek(buf, pos1);
            pos1 += VarInt.length(buf, pos1);
            for (int i = 0; i < arrLen; ++i) {
                int sl = VarInt.peek(buf, pos1);
                pos1 += VarInt.length(buf, pos1) + sl;
            }
            if (pos1 - offset > maxEnd) {
                maxEnd = pos1 - offset;
            }
        }
        return maxEnd;
    }

    public void serialize(@Nonnull ByteBuf buf) {
        int startPos = buf.writerIndex();
        byte nullBits = 0;
        if (this.id != null) {
            nullBits = (byte)(nullBits | 1);
        }
        if (this.categories != null) {
            nullBits = (byte)(nullBits | 2);
        }
        buf.writeByte(nullBits);
        buf.writeByte(this.type.getValue());
        buf.writeIntLE(this.requiredTierLevel);
        int idOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int categoriesOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int varBlockStart = buf.writerIndex();
        if (this.id != null) {
            buf.setIntLE(idOffsetSlot, buf.writerIndex() - varBlockStart);
            PacketIO.writeVarString(buf, this.id, 4096000);
        } else {
            buf.setIntLE(idOffsetSlot, -1);
        }
        if (this.categories != null) {
            buf.setIntLE(categoriesOffsetSlot, buf.writerIndex() - varBlockStart);
            if (this.categories.length > 4096000) {
                throw ProtocolException.arrayTooLong("Categories", this.categories.length, 4096000);
            }
            VarInt.write(buf, this.categories.length);
            for (String item : this.categories) {
                PacketIO.writeVarString(buf, item, 4096000);
            }
        } else {
            buf.setIntLE(categoriesOffsetSlot, -1);
        }
    }

    public int computeSize() {
        int size = 14;
        if (this.id != null) {
            size += PacketIO.stringSize(this.id);
        }
        if (this.categories != null) {
            int categoriesSize = 0;
            for (String elem : this.categories) {
                categoriesSize += PacketIO.stringSize(elem);
            }
            size += VarInt.size(this.categories.length) + categoriesSize;
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        int pos;
        if (buffer.readableBytes() - offset < 14) {
            return ValidationResult.error("Buffer too small: expected at least 14 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        if ((nullBits & 1) != 0) {
            int idOffset = buffer.getIntLE(offset + 6);
            if (idOffset < 0) {
                return ValidationResult.error("Invalid offset for Id");
            }
            pos = offset + 14 + idOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Id");
            }
            int idLen = VarInt.peek(buffer, pos);
            if (idLen < 0) {
                return ValidationResult.error("Invalid string length for Id");
            }
            if (idLen > 4096000) {
                return ValidationResult.error("Id exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += idLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Id");
            }
        }
        if ((nullBits & 2) != 0) {
            int categoriesOffset = buffer.getIntLE(offset + 10);
            if (categoriesOffset < 0) {
                return ValidationResult.error("Invalid offset for Categories");
            }
            pos = offset + 14 + categoriesOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Categories");
            }
            int categoriesCount = VarInt.peek(buffer, pos);
            if (categoriesCount < 0) {
                return ValidationResult.error("Invalid array count for Categories");
            }
            if (categoriesCount > 4096000) {
                return ValidationResult.error("Categories exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            for (int i = 0; i < categoriesCount; ++i) {
                int strLen = VarInt.peek(buffer, pos);
                if (strLen < 0) {
                    return ValidationResult.error("Invalid string length in Categories");
                }
                pos += VarInt.length(buffer, pos);
                if ((pos += strLen) <= buffer.writerIndex()) continue;
                return ValidationResult.error("Buffer overflow reading string in Categories");
            }
        }
        return ValidationResult.OK;
    }

    public BenchRequirement clone() {
        BenchRequirement copy = new BenchRequirement();
        copy.type = this.type;
        copy.id = this.id;
        copy.categories = this.categories != null ? Arrays.copyOf(this.categories, this.categories.length) : null;
        copy.requiredTierLevel = this.requiredTierLevel;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BenchRequirement)) {
            return false;
        }
        BenchRequirement other = (BenchRequirement)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.id, other.id) && Arrays.equals(this.categories, other.categories) && this.requiredTierLevel == other.requiredTierLevel;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode((Object)this.type);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Arrays.hashCode(this.categories);
        result = 31 * result + Integer.hashCode(this.requiredTierLevel);
        return result;
    }
}

