/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol;

import com.hypixel.hytale.protocol.BlockPlacementRotationMode;
import com.hypixel.hytale.protocol.BlockPreviewVisibility;
import com.hypixel.hytale.protocol.io.ValidationResult;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BlockPlacementSettings {
    public static final int NULLABLE_BIT_FIELD_SIZE = 0;
    public static final int FIXED_BLOCK_SIZE = 16;
    public static final int VARIABLE_FIELD_COUNT = 0;
    public static final int VARIABLE_BLOCK_START = 16;
    public static final int MAX_SIZE = 16;
    public boolean allowRotationKey;
    public boolean placeInEmptyBlocks;
    @Nonnull
    public BlockPreviewVisibility previewVisibility = BlockPreviewVisibility.AlwaysVisible;
    @Nonnull
    public BlockPlacementRotationMode rotationMode = BlockPlacementRotationMode.FacingPlayer;
    public int wallPlacementOverrideBlockId;
    public int floorPlacementOverrideBlockId;
    public int ceilingPlacementOverrideBlockId;

    public BlockPlacementSettings() {
    }

    public BlockPlacementSettings(boolean allowRotationKey, boolean placeInEmptyBlocks, @Nonnull BlockPreviewVisibility previewVisibility, @Nonnull BlockPlacementRotationMode rotationMode, int wallPlacementOverrideBlockId, int floorPlacementOverrideBlockId, int ceilingPlacementOverrideBlockId) {
        this.allowRotationKey = allowRotationKey;
        this.placeInEmptyBlocks = placeInEmptyBlocks;
        this.previewVisibility = previewVisibility;
        this.rotationMode = rotationMode;
        this.wallPlacementOverrideBlockId = wallPlacementOverrideBlockId;
        this.floorPlacementOverrideBlockId = floorPlacementOverrideBlockId;
        this.ceilingPlacementOverrideBlockId = ceilingPlacementOverrideBlockId;
    }

    public BlockPlacementSettings(@Nonnull BlockPlacementSettings other) {
        this.allowRotationKey = other.allowRotationKey;
        this.placeInEmptyBlocks = other.placeInEmptyBlocks;
        this.previewVisibility = other.previewVisibility;
        this.rotationMode = other.rotationMode;
        this.wallPlacementOverrideBlockId = other.wallPlacementOverrideBlockId;
        this.floorPlacementOverrideBlockId = other.floorPlacementOverrideBlockId;
        this.ceilingPlacementOverrideBlockId = other.ceilingPlacementOverrideBlockId;
    }

    @Nonnull
    public static BlockPlacementSettings deserialize(@Nonnull ByteBuf buf, int offset) {
        BlockPlacementSettings obj = new BlockPlacementSettings();
        obj.allowRotationKey = buf.getByte(offset + 0) != 0;
        obj.placeInEmptyBlocks = buf.getByte(offset + 1) != 0;
        obj.previewVisibility = BlockPreviewVisibility.fromValue(buf.getByte(offset + 2));
        obj.rotationMode = BlockPlacementRotationMode.fromValue(buf.getByte(offset + 3));
        obj.wallPlacementOverrideBlockId = buf.getIntLE(offset + 4);
        obj.floorPlacementOverrideBlockId = buf.getIntLE(offset + 8);
        obj.ceilingPlacementOverrideBlockId = buf.getIntLE(offset + 12);
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        return 16;
    }

    public void serialize(@Nonnull ByteBuf buf) {
        buf.writeByte(this.allowRotationKey ? 1 : 0);
        buf.writeByte(this.placeInEmptyBlocks ? 1 : 0);
        buf.writeByte(this.previewVisibility.getValue());
        buf.writeByte(this.rotationMode.getValue());
        buf.writeIntLE(this.wallPlacementOverrideBlockId);
        buf.writeIntLE(this.floorPlacementOverrideBlockId);
        buf.writeIntLE(this.ceilingPlacementOverrideBlockId);
    }

    public int computeSize() {
        return 16;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 16) {
            return ValidationResult.error("Buffer too small: expected at least 16 bytes");
        }
        return ValidationResult.OK;
    }

    public BlockPlacementSettings clone() {
        BlockPlacementSettings copy = new BlockPlacementSettings();
        copy.allowRotationKey = this.allowRotationKey;
        copy.placeInEmptyBlocks = this.placeInEmptyBlocks;
        copy.previewVisibility = this.previewVisibility;
        copy.rotationMode = this.rotationMode;
        copy.wallPlacementOverrideBlockId = this.wallPlacementOverrideBlockId;
        copy.floorPlacementOverrideBlockId = this.floorPlacementOverrideBlockId;
        copy.ceilingPlacementOverrideBlockId = this.ceilingPlacementOverrideBlockId;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockPlacementSettings)) {
            return false;
        }
        BlockPlacementSettings other = (BlockPlacementSettings)obj;
        return this.allowRotationKey == other.allowRotationKey && this.placeInEmptyBlocks == other.placeInEmptyBlocks && Objects.equals((Object)this.previewVisibility, (Object)other.previewVisibility) && Objects.equals((Object)this.rotationMode, (Object)other.rotationMode) && this.wallPlacementOverrideBlockId == other.wallPlacementOverrideBlockId && this.floorPlacementOverrideBlockId == other.floorPlacementOverrideBlockId && this.ceilingPlacementOverrideBlockId == other.ceilingPlacementOverrideBlockId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowRotationKey, this.placeInEmptyBlocks, this.previewVisibility, this.rotationMode, this.wallPlacementOverrideBlockId, this.floorPlacementOverrideBlockId, this.ceilingPlacementOverrideBlockId});
    }
}

