/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol;

import com.hypixel.hytale.protocol.Modifier;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ItemWeapon {
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 2;
    public static final int VARIABLE_FIELD_COUNT = 2;
    public static final int VARIABLE_BLOCK_START = 10;
    public static final int MAX_SIZE = 1626112020;
    @Nullable
    public int[] entityStatsToClear;
    @Nullable
    public Map<Integer, Modifier[]> statModifiers;
    public boolean renderDualWielded;

    public ItemWeapon() {
    }

    public ItemWeapon(@Nullable int[] entityStatsToClear, @Nullable Map<Integer, Modifier[]> statModifiers, boolean renderDualWielded) {
        this.entityStatsToClear = entityStatsToClear;
        this.statModifiers = statModifiers;
        this.renderDualWielded = renderDualWielded;
    }

    public ItemWeapon(@Nonnull ItemWeapon other) {
        this.entityStatsToClear = other.entityStatsToClear;
        this.statModifiers = other.statModifiers;
        this.renderDualWielded = other.renderDualWielded;
    }

    @Nonnull
    public static ItemWeapon deserialize(@Nonnull ByteBuf buf, int offset) {
        int varIntLen;
        ItemWeapon obj = new ItemWeapon();
        byte nullBits = buf.getByte(offset);
        boolean bl = obj.renderDualWielded = buf.getByte(offset + 1) != 0;
        if ((nullBits & 1) != 0) {
            int varPos0 = offset + 10 + buf.getIntLE(offset + 2);
            int entityStatsToClearCount = VarInt.peek(buf, varPos0);
            if (entityStatsToClearCount < 0) {
                throw ProtocolException.negativeLength("EntityStatsToClear", entityStatsToClearCount);
            }
            if (entityStatsToClearCount > 4096000) {
                throw ProtocolException.arrayTooLong("EntityStatsToClear", entityStatsToClearCount, 4096000);
            }
            varIntLen = VarInt.length(buf, varPos0);
            if ((long)(varPos0 + varIntLen) + (long)entityStatsToClearCount * 4L > (long)buf.readableBytes()) {
                throw ProtocolException.bufferTooSmall("EntityStatsToClear", varPos0 + varIntLen + entityStatsToClearCount * 4, buf.readableBytes());
            }
            obj.entityStatsToClear = new int[entityStatsToClearCount];
            for (int i = 0; i < entityStatsToClearCount; ++i) {
                obj.entityStatsToClear[i] = buf.getIntLE(varPos0 + varIntLen + i * 4);
            }
        }
        if ((nullBits & 2) != 0) {
            int varPos1 = offset + 10 + buf.getIntLE(offset + 6);
            int statModifiersCount = VarInt.peek(buf, varPos1);
            if (statModifiersCount < 0) {
                throw ProtocolException.negativeLength("StatModifiers", statModifiersCount);
            }
            if (statModifiersCount > 4096000) {
                throw ProtocolException.dictionaryTooLarge("StatModifiers", statModifiersCount, 4096000);
            }
            varIntLen = VarInt.length(buf, varPos1);
            obj.statModifiers = new HashMap<Integer, Modifier[]>(statModifiersCount);
            int dictPos = varPos1 + varIntLen;
            for (int i = 0; i < statModifiersCount; ++i) {
                int key = buf.getIntLE(dictPos);
                int valLen = VarInt.peek(buf, dictPos += 4);
                if (valLen < 0) {
                    throw ProtocolException.negativeLength("val", valLen);
                }
                if (valLen > 64) {
                    throw ProtocolException.arrayTooLong("val", valLen, 64);
                }
                int valVarLen = VarInt.length(buf, dictPos);
                if ((long)(dictPos + valVarLen) + (long)valLen * 6L > (long)buf.readableBytes()) {
                    throw ProtocolException.bufferTooSmall("val", dictPos + valVarLen + valLen * 6, buf.readableBytes());
                }
                dictPos += valVarLen;
                Modifier[] val = new Modifier[valLen];
                for (int valIdx = 0; valIdx < valLen; ++valIdx) {
                    val[valIdx] = Modifier.deserialize(buf, dictPos);
                    dictPos += Modifier.computeBytesConsumed(buf, dictPos);
                }
                if (obj.statModifiers.put(key, val) == null) continue;
                throw ProtocolException.duplicateKey("statModifiers", key);
            }
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int maxEnd = 10;
        if ((nullBits & 1) != 0) {
            int fieldOffset0 = buf.getIntLE(offset + 2);
            int pos0 = offset + 10 + fieldOffset0;
            int arrLen = VarInt.peek(buf, pos0);
            if ((pos0 += VarInt.length(buf, pos0) + arrLen * 4) - offset > maxEnd) {
                maxEnd = pos0 - offset;
            }
        }
        if ((nullBits & 2) != 0) {
            int fieldOffset1 = buf.getIntLE(offset + 6);
            int pos1 = offset + 10 + fieldOffset1;
            int dictLen = VarInt.peek(buf, pos1);
            pos1 += VarInt.length(buf, pos1);
            for (int i = 0; i < dictLen; ++i) {
                int al = VarInt.peek(buf, pos1 += 4);
                pos1 += VarInt.length(buf, pos1);
                for (int j = 0; j < al; ++j) {
                    pos1 += Modifier.computeBytesConsumed(buf, pos1);
                }
            }
            if (pos1 - offset > maxEnd) {
                maxEnd = pos1 - offset;
            }
        }
        return maxEnd;
    }

    public void serialize(@Nonnull ByteBuf buf) {
        int startPos = buf.writerIndex();
        byte nullBits = 0;
        if (this.entityStatsToClear != null) {
            nullBits = (byte)(nullBits | 1);
        }
        if (this.statModifiers != null) {
            nullBits = (byte)(nullBits | 2);
        }
        buf.writeByte(nullBits);
        buf.writeByte(this.renderDualWielded ? 1 : 0);
        int entityStatsToClearOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int statModifiersOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int varBlockStart = buf.writerIndex();
        if (this.entityStatsToClear != null) {
            buf.setIntLE(entityStatsToClearOffsetSlot, buf.writerIndex() - varBlockStart);
            if (this.entityStatsToClear.length > 4096000) {
                throw ProtocolException.arrayTooLong("EntityStatsToClear", this.entityStatsToClear.length, 4096000);
            }
            VarInt.write(buf, this.entityStatsToClear.length);
            for (int item : this.entityStatsToClear) {
                buf.writeIntLE(item);
            }
        } else {
            buf.setIntLE(entityStatsToClearOffsetSlot, -1);
        }
        if (this.statModifiers != null) {
            buf.setIntLE(statModifiersOffsetSlot, buf.writerIndex() - varBlockStart);
            if (this.statModifiers.size() > 4096000) {
                throw ProtocolException.dictionaryTooLarge("StatModifiers", this.statModifiers.size(), 4096000);
            }
            VarInt.write(buf, this.statModifiers.size());
            Object object = this.statModifiers.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry e = (Map.Entry)object.next();
                buf.writeIntLE((Integer)e.getKey());
                VarInt.write(buf, ((Modifier[])e.getValue()).length);
                for (Modifier arrItem : (Modifier[])e.getValue()) {
                    arrItem.serialize(buf);
                }
            }
        } else {
            buf.setIntLE(statModifiersOffsetSlot, -1);
        }
    }

    public int computeSize() {
        int size = 10;
        if (this.entityStatsToClear != null) {
            size += VarInt.size(this.entityStatsToClear.length) + this.entityStatsToClear.length * 4;
        }
        if (this.statModifiers != null) {
            int statModifiersSize = 0;
            for (Map.Entry<Integer, Modifier[]> kvp : this.statModifiers.entrySet()) {
                statModifiersSize += 4 + VarInt.size(kvp.getValue().length) + kvp.getValue().length * 6;
            }
            size += VarInt.size(this.statModifiers.size()) + statModifiersSize;
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        int pos;
        if (buffer.readableBytes() - offset < 10) {
            return ValidationResult.error("Buffer too small: expected at least 10 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        if ((nullBits & 1) != 0) {
            int entityStatsToClearOffset = buffer.getIntLE(offset + 2);
            if (entityStatsToClearOffset < 0) {
                return ValidationResult.error("Invalid offset for EntityStatsToClear");
            }
            pos = offset + 10 + entityStatsToClearOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for EntityStatsToClear");
            }
            int entityStatsToClearCount = VarInt.peek(buffer, pos);
            if (entityStatsToClearCount < 0) {
                return ValidationResult.error("Invalid array count for EntityStatsToClear");
            }
            if (entityStatsToClearCount > 4096000) {
                return ValidationResult.error("EntityStatsToClear exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += entityStatsToClearCount * 4) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading EntityStatsToClear");
            }
        }
        if ((nullBits & 2) != 0) {
            int statModifiersOffset = buffer.getIntLE(offset + 6);
            if (statModifiersOffset < 0) {
                return ValidationResult.error("Invalid offset for StatModifiers");
            }
            pos = offset + 10 + statModifiersOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for StatModifiers");
            }
            int statModifiersCount = VarInt.peek(buffer, pos);
            if (statModifiersCount < 0) {
                return ValidationResult.error("Invalid dictionary count for StatModifiers");
            }
            if (statModifiersCount > 4096000) {
                return ValidationResult.error("StatModifiers exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            for (int i = 0; i < statModifiersCount; ++i) {
                if ((pos += 4) > buffer.writerIndex()) {
                    return ValidationResult.error("Buffer overflow reading key");
                }
                int valueArrCount = VarInt.peek(buffer, pos);
                if (valueArrCount < 0) {
                    return ValidationResult.error("Invalid array count for value");
                }
                pos += VarInt.length(buffer, pos);
                for (int valueArrIdx = 0; valueArrIdx < valueArrCount; ++valueArrIdx) {
                    pos += 6;
                }
            }
        }
        return ValidationResult.OK;
    }

    public ItemWeapon clone() {
        ItemWeapon copy = new ItemWeapon();
        int[] nArray = copy.entityStatsToClear = this.entityStatsToClear != null ? Arrays.copyOf(this.entityStatsToClear, this.entityStatsToClear.length) : null;
        if (this.statModifiers != null) {
            HashMap<Integer, Modifier[]> m = new HashMap<Integer, Modifier[]>();
            for (Map.Entry<Integer, Modifier[]> e : this.statModifiers.entrySet()) {
                m.put(e.getKey(), (Modifier[])Arrays.stream(e.getValue()).map(x -> x.clone()).toArray(Modifier[]::new));
            }
            copy.statModifiers = m;
        }
        copy.renderDualWielded = this.renderDualWielded;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemWeapon)) {
            return false;
        }
        ItemWeapon other = (ItemWeapon)obj;
        return Arrays.equals(this.entityStatsToClear, other.entityStatsToClear) && Objects.equals(this.statModifiers, other.statModifiers) && this.renderDualWielded == other.renderDualWielded;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.entityStatsToClear);
        result = 31 * result + Objects.hashCode(this.statModifiers);
        result = 31 * result + Boolean.hashCode(this.renderDualWielded);
        return result;
    }
}

