/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol;

import com.hypixel.hytale.protocol.io.ValidationResult;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Vector3i {
    public static final int NULLABLE_BIT_FIELD_SIZE = 0;
    public static final int FIXED_BLOCK_SIZE = 12;
    public static final int VARIABLE_FIELD_COUNT = 0;
    public static final int VARIABLE_BLOCK_START = 12;
    public static final int MAX_SIZE = 12;
    public int x;
    public int y;
    public int z;

    public Vector3i() {
    }

    public Vector3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3i(@Nonnull Vector3i other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    @Nonnull
    public static Vector3i deserialize(@Nonnull ByteBuf buf, int offset) {
        Vector3i obj = new Vector3i();
        obj.x = buf.getIntLE(offset + 0);
        obj.y = buf.getIntLE(offset + 4);
        obj.z = buf.getIntLE(offset + 8);
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        return 12;
    }

    public void serialize(@Nonnull ByteBuf buf) {
        buf.writeIntLE(this.x);
        buf.writeIntLE(this.y);
        buf.writeIntLE(this.z);
    }

    public int computeSize() {
        return 12;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 12) {
            return ValidationResult.error("Buffer too small: expected at least 12 bytes");
        }
        return ValidationResult.OK;
    }

    public Vector3i clone() {
        Vector3i copy = new Vector3i();
        copy.x = this.x;
        copy.y = this.y;
        copy.z = this.z;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector3i)) {
            return false;
        }
        Vector3i other = (Vector3i)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }
}

