/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.asseteditor;

import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.io.PacketIO;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetEditorEnableAssetPack
implements Packet {
    public static final int PACKET_ID = 318;
    public static final boolean IS_COMPRESSED = false;
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 2;
    public static final int VARIABLE_FIELD_COUNT = 1;
    public static final int VARIABLE_BLOCK_START = 2;
    public static final int MAX_SIZE = 16384007;
    @Nullable
    public String id;
    public boolean enabled;

    @Override
    public int getId() {
        return 318;
    }

    public AssetEditorEnableAssetPack() {
    }

    public AssetEditorEnableAssetPack(@Nullable String id, boolean enabled) {
        this.id = id;
        this.enabled = enabled;
    }

    public AssetEditorEnableAssetPack(@Nonnull AssetEditorEnableAssetPack other) {
        this.id = other.id;
        this.enabled = other.enabled;
    }

    @Nonnull
    public static AssetEditorEnableAssetPack deserialize(@Nonnull ByteBuf buf, int offset) {
        AssetEditorEnableAssetPack obj = new AssetEditorEnableAssetPack();
        byte nullBits = buf.getByte(offset);
        obj.enabled = buf.getByte(offset + 1) != 0;
        int pos = offset + 2;
        if ((nullBits & 1) != 0) {
            int idLen = VarInt.peek(buf, pos);
            if (idLen < 0) {
                throw ProtocolException.negativeLength("Id", idLen);
            }
            if (idLen > 4096000) {
                throw ProtocolException.stringTooLong("Id", idLen, 4096000);
            }
            int idVarLen = VarInt.length(buf, pos);
            obj.id = PacketIO.readVarString(buf, pos, PacketIO.UTF8);
            pos += idVarLen + idLen;
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int pos = offset + 2;
        if ((nullBits & 1) != 0) {
            int sl = VarInt.peek(buf, pos);
            pos += VarInt.length(buf, pos) + sl;
        }
        return pos - offset;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        int nullBits = 0;
        if (this.id != null) {
            nullBits = (byte)(nullBits | 1);
        }
        buf.writeByte(nullBits);
        buf.writeByte(this.enabled ? 1 : 0);
        if (this.id != null) {
            PacketIO.writeVarString(buf, this.id, 4096000);
        }
    }

    @Override
    public int computeSize() {
        int size = 2;
        if (this.id != null) {
            size += PacketIO.stringSize(this.id);
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 2) {
            return ValidationResult.error("Buffer too small: expected at least 2 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        int pos = offset + 2;
        if ((nullBits & 1) != 0) {
            int idLen = VarInt.peek(buffer, pos);
            if (idLen < 0) {
                return ValidationResult.error("Invalid string length for Id");
            }
            if (idLen > 4096000) {
                return ValidationResult.error("Id exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += idLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Id");
            }
        }
        return ValidationResult.OK;
    }

    public AssetEditorEnableAssetPack clone() {
        AssetEditorEnableAssetPack copy = new AssetEditorEnableAssetPack();
        copy.id = this.id;
        copy.enabled = this.enabled;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssetEditorEnableAssetPack)) {
            return false;
        }
        AssetEditorEnableAssetPack other = (AssetEditorEnableAssetPack)obj;
        return Objects.equals(this.id, other.id) && this.enabled == other.enabled;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.enabled);
    }
}

