/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.asseteditor;

import com.hypixel.hytale.protocol.io.PacketIO;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import com.hypixel.hytale.protocol.packets.asseteditor.AuthorInfo;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetPackManifest {
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 1;
    public static final int VARIABLE_FIELD_COUNT = 6;
    public static final int VARIABLE_BLOCK_START = 25;
    public static final int MAX_SIZE = 0x64000000;
    @Nullable
    public String name;
    @Nullable
    public String group;
    @Nullable
    public String website;
    @Nullable
    public String description;
    @Nullable
    public String version;
    @Nullable
    public AuthorInfo[] authors;

    public AssetPackManifest() {
    }

    public AssetPackManifest(@Nullable String name, @Nullable String group, @Nullable String website, @Nullable String description, @Nullable String version, @Nullable AuthorInfo[] authors) {
        this.name = name;
        this.group = group;
        this.website = website;
        this.description = description;
        this.version = version;
        this.authors = authors;
    }

    public AssetPackManifest(@Nonnull AssetPackManifest other) {
        this.name = other.name;
        this.group = other.group;
        this.website = other.website;
        this.description = other.description;
        this.version = other.version;
        this.authors = other.authors;
    }

    @Nonnull
    public static AssetPackManifest deserialize(@Nonnull ByteBuf buf, int offset) {
        AssetPackManifest obj = new AssetPackManifest();
        byte nullBits = buf.getByte(offset);
        if ((nullBits & 1) != 0) {
            int varPos0 = offset + 25 + buf.getIntLE(offset + 1);
            int nameLen = VarInt.peek(buf, varPos0);
            if (nameLen < 0) {
                throw ProtocolException.negativeLength("Name", nameLen);
            }
            if (nameLen > 4096000) {
                throw ProtocolException.stringTooLong("Name", nameLen, 4096000);
            }
            obj.name = PacketIO.readVarString(buf, varPos0, PacketIO.UTF8);
        }
        if ((nullBits & 2) != 0) {
            int varPos1 = offset + 25 + buf.getIntLE(offset + 5);
            int groupLen = VarInt.peek(buf, varPos1);
            if (groupLen < 0) {
                throw ProtocolException.negativeLength("Group", groupLen);
            }
            if (groupLen > 4096000) {
                throw ProtocolException.stringTooLong("Group", groupLen, 4096000);
            }
            obj.group = PacketIO.readVarString(buf, varPos1, PacketIO.UTF8);
        }
        if ((nullBits & 4) != 0) {
            int varPos2 = offset + 25 + buf.getIntLE(offset + 9);
            int websiteLen = VarInt.peek(buf, varPos2);
            if (websiteLen < 0) {
                throw ProtocolException.negativeLength("Website", websiteLen);
            }
            if (websiteLen > 4096000) {
                throw ProtocolException.stringTooLong("Website", websiteLen, 4096000);
            }
            obj.website = PacketIO.readVarString(buf, varPos2, PacketIO.UTF8);
        }
        if ((nullBits & 8) != 0) {
            int varPos3 = offset + 25 + buf.getIntLE(offset + 13);
            int descriptionLen = VarInt.peek(buf, varPos3);
            if (descriptionLen < 0) {
                throw ProtocolException.negativeLength("Description", descriptionLen);
            }
            if (descriptionLen > 4096000) {
                throw ProtocolException.stringTooLong("Description", descriptionLen, 4096000);
            }
            obj.description = PacketIO.readVarString(buf, varPos3, PacketIO.UTF8);
        }
        if ((nullBits & 0x10) != 0) {
            int varPos4 = offset + 25 + buf.getIntLE(offset + 17);
            int versionLen = VarInt.peek(buf, varPos4);
            if (versionLen < 0) {
                throw ProtocolException.negativeLength("Version", versionLen);
            }
            if (versionLen > 4096000) {
                throw ProtocolException.stringTooLong("Version", versionLen, 4096000);
            }
            obj.version = PacketIO.readVarString(buf, varPos4, PacketIO.UTF8);
        }
        if ((nullBits & 0x20) != 0) {
            int varPos5 = offset + 25 + buf.getIntLE(offset + 21);
            int authorsCount = VarInt.peek(buf, varPos5);
            if (authorsCount < 0) {
                throw ProtocolException.negativeLength("Authors", authorsCount);
            }
            if (authorsCount > 4096000) {
                throw ProtocolException.arrayTooLong("Authors", authorsCount, 4096000);
            }
            int varIntLen = VarInt.length(buf, varPos5);
            if ((long)(varPos5 + varIntLen) + (long)authorsCount * 1L > (long)buf.readableBytes()) {
                throw ProtocolException.bufferTooSmall("Authors", varPos5 + varIntLen + authorsCount * 1, buf.readableBytes());
            }
            obj.authors = new AuthorInfo[authorsCount];
            int elemPos = varPos5 + varIntLen;
            for (int i = 0; i < authorsCount; ++i) {
                obj.authors[i] = AuthorInfo.deserialize(buf, elemPos);
                elemPos += AuthorInfo.computeBytesConsumed(buf, elemPos);
            }
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        int sl;
        byte nullBits = buf.getByte(offset);
        int maxEnd = 25;
        if ((nullBits & 1) != 0) {
            int fieldOffset0 = buf.getIntLE(offset + 1);
            int pos0 = offset + 25 + fieldOffset0;
            sl = VarInt.peek(buf, pos0);
            if ((pos0 += VarInt.length(buf, pos0) + sl) - offset > maxEnd) {
                maxEnd = pos0 - offset;
            }
        }
        if ((nullBits & 2) != 0) {
            int fieldOffset1 = buf.getIntLE(offset + 5);
            int pos1 = offset + 25 + fieldOffset1;
            sl = VarInt.peek(buf, pos1);
            if ((pos1 += VarInt.length(buf, pos1) + sl) - offset > maxEnd) {
                maxEnd = pos1 - offset;
            }
        }
        if ((nullBits & 4) != 0) {
            int fieldOffset2 = buf.getIntLE(offset + 9);
            int pos2 = offset + 25 + fieldOffset2;
            sl = VarInt.peek(buf, pos2);
            if ((pos2 += VarInt.length(buf, pos2) + sl) - offset > maxEnd) {
                maxEnd = pos2 - offset;
            }
        }
        if ((nullBits & 8) != 0) {
            int fieldOffset3 = buf.getIntLE(offset + 13);
            int pos3 = offset + 25 + fieldOffset3;
            sl = VarInt.peek(buf, pos3);
            if ((pos3 += VarInt.length(buf, pos3) + sl) - offset > maxEnd) {
                maxEnd = pos3 - offset;
            }
        }
        if ((nullBits & 0x10) != 0) {
            int fieldOffset4 = buf.getIntLE(offset + 17);
            int pos4 = offset + 25 + fieldOffset4;
            sl = VarInt.peek(buf, pos4);
            if ((pos4 += VarInt.length(buf, pos4) + sl) - offset > maxEnd) {
                maxEnd = pos4 - offset;
            }
        }
        if ((nullBits & 0x20) != 0) {
            int fieldOffset5 = buf.getIntLE(offset + 21);
            int pos5 = offset + 25 + fieldOffset5;
            int arrLen = VarInt.peek(buf, pos5);
            pos5 += VarInt.length(buf, pos5);
            for (int i = 0; i < arrLen; ++i) {
                pos5 += AuthorInfo.computeBytesConsumed(buf, pos5);
            }
            if (pos5 - offset > maxEnd) {
                maxEnd = pos5 - offset;
            }
        }
        return maxEnd;
    }

    public void serialize(@Nonnull ByteBuf buf) {
        int startPos = buf.writerIndex();
        byte nullBits = 0;
        if (this.name != null) {
            nullBits = (byte)(nullBits | 1);
        }
        if (this.group != null) {
            nullBits = (byte)(nullBits | 2);
        }
        if (this.website != null) {
            nullBits = (byte)(nullBits | 4);
        }
        if (this.description != null) {
            nullBits = (byte)(nullBits | 8);
        }
        if (this.version != null) {
            nullBits = (byte)(nullBits | 0x10);
        }
        if (this.authors != null) {
            nullBits = (byte)(nullBits | 0x20);
        }
        buf.writeByte(nullBits);
        int nameOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int groupOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int websiteOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int descriptionOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int versionOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int authorsOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int varBlockStart = buf.writerIndex();
        if (this.name != null) {
            buf.setIntLE(nameOffsetSlot, buf.writerIndex() - varBlockStart);
            PacketIO.writeVarString(buf, this.name, 4096000);
        } else {
            buf.setIntLE(nameOffsetSlot, -1);
        }
        if (this.group != null) {
            buf.setIntLE(groupOffsetSlot, buf.writerIndex() - varBlockStart);
            PacketIO.writeVarString(buf, this.group, 4096000);
        } else {
            buf.setIntLE(groupOffsetSlot, -1);
        }
        if (this.website != null) {
            buf.setIntLE(websiteOffsetSlot, buf.writerIndex() - varBlockStart);
            PacketIO.writeVarString(buf, this.website, 4096000);
        } else {
            buf.setIntLE(websiteOffsetSlot, -1);
        }
        if (this.description != null) {
            buf.setIntLE(descriptionOffsetSlot, buf.writerIndex() - varBlockStart);
            PacketIO.writeVarString(buf, this.description, 4096000);
        } else {
            buf.setIntLE(descriptionOffsetSlot, -1);
        }
        if (this.version != null) {
            buf.setIntLE(versionOffsetSlot, buf.writerIndex() - varBlockStart);
            PacketIO.writeVarString(buf, this.version, 4096000);
        } else {
            buf.setIntLE(versionOffsetSlot, -1);
        }
        if (this.authors != null) {
            buf.setIntLE(authorsOffsetSlot, buf.writerIndex() - varBlockStart);
            if (this.authors.length > 4096000) {
                throw ProtocolException.arrayTooLong("Authors", this.authors.length, 4096000);
            }
            VarInt.write(buf, this.authors.length);
            for (AuthorInfo item : this.authors) {
                item.serialize(buf);
            }
        } else {
            buf.setIntLE(authorsOffsetSlot, -1);
        }
    }

    public int computeSize() {
        int size = 25;
        if (this.name != null) {
            size += PacketIO.stringSize(this.name);
        }
        if (this.group != null) {
            size += PacketIO.stringSize(this.group);
        }
        if (this.website != null) {
            size += PacketIO.stringSize(this.website);
        }
        if (this.description != null) {
            size += PacketIO.stringSize(this.description);
        }
        if (this.version != null) {
            size += PacketIO.stringSize(this.version);
        }
        if (this.authors != null) {
            int authorsSize = 0;
            for (AuthorInfo elem : this.authors) {
                authorsSize += elem.computeSize();
            }
            size += VarInt.size(this.authors.length) + authorsSize;
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        int pos;
        if (buffer.readableBytes() - offset < 25) {
            return ValidationResult.error("Buffer too small: expected at least 25 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        if ((nullBits & 1) != 0) {
            int nameOffset = buffer.getIntLE(offset + 1);
            if (nameOffset < 0) {
                return ValidationResult.error("Invalid offset for Name");
            }
            pos = offset + 25 + nameOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Name");
            }
            int nameLen = VarInt.peek(buffer, pos);
            if (nameLen < 0) {
                return ValidationResult.error("Invalid string length for Name");
            }
            if (nameLen > 4096000) {
                return ValidationResult.error("Name exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += nameLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Name");
            }
        }
        if ((nullBits & 2) != 0) {
            int groupOffset = buffer.getIntLE(offset + 5);
            if (groupOffset < 0) {
                return ValidationResult.error("Invalid offset for Group");
            }
            pos = offset + 25 + groupOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Group");
            }
            int groupLen = VarInt.peek(buffer, pos);
            if (groupLen < 0) {
                return ValidationResult.error("Invalid string length for Group");
            }
            if (groupLen > 4096000) {
                return ValidationResult.error("Group exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += groupLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Group");
            }
        }
        if ((nullBits & 4) != 0) {
            int websiteOffset = buffer.getIntLE(offset + 9);
            if (websiteOffset < 0) {
                return ValidationResult.error("Invalid offset for Website");
            }
            pos = offset + 25 + websiteOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Website");
            }
            int websiteLen = VarInt.peek(buffer, pos);
            if (websiteLen < 0) {
                return ValidationResult.error("Invalid string length for Website");
            }
            if (websiteLen > 4096000) {
                return ValidationResult.error("Website exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += websiteLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Website");
            }
        }
        if ((nullBits & 8) != 0) {
            int descriptionOffset = buffer.getIntLE(offset + 13);
            if (descriptionOffset < 0) {
                return ValidationResult.error("Invalid offset for Description");
            }
            pos = offset + 25 + descriptionOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Description");
            }
            int descriptionLen = VarInt.peek(buffer, pos);
            if (descriptionLen < 0) {
                return ValidationResult.error("Invalid string length for Description");
            }
            if (descriptionLen > 4096000) {
                return ValidationResult.error("Description exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += descriptionLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Description");
            }
        }
        if ((nullBits & 0x10) != 0) {
            int versionOffset = buffer.getIntLE(offset + 17);
            if (versionOffset < 0) {
                return ValidationResult.error("Invalid offset for Version");
            }
            pos = offset + 25 + versionOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Version");
            }
            int versionLen = VarInt.peek(buffer, pos);
            if (versionLen < 0) {
                return ValidationResult.error("Invalid string length for Version");
            }
            if (versionLen > 4096000) {
                return ValidationResult.error("Version exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += versionLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Version");
            }
        }
        if ((nullBits & 0x20) != 0) {
            int authorsOffset = buffer.getIntLE(offset + 21);
            if (authorsOffset < 0) {
                return ValidationResult.error("Invalid offset for Authors");
            }
            pos = offset + 25 + authorsOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Authors");
            }
            int authorsCount = VarInt.peek(buffer, pos);
            if (authorsCount < 0) {
                return ValidationResult.error("Invalid array count for Authors");
            }
            if (authorsCount > 4096000) {
                return ValidationResult.error("Authors exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            for (int i = 0; i < authorsCount; ++i) {
                ValidationResult structResult = AuthorInfo.validateStructure(buffer, pos);
                if (!structResult.isValid()) {
                    return ValidationResult.error("Invalid AuthorInfo in Authors[" + i + "]: " + structResult.error());
                }
                pos += AuthorInfo.computeBytesConsumed(buffer, pos);
            }
        }
        return ValidationResult.OK;
    }

    public AssetPackManifest clone() {
        AssetPackManifest copy = new AssetPackManifest();
        copy.name = this.name;
        copy.group = this.group;
        copy.website = this.website;
        copy.description = this.description;
        copy.version = this.version;
        copy.authors = this.authors != null ? (AuthorInfo[])Arrays.stream(this.authors).map(e -> e.clone()).toArray(AuthorInfo[]::new) : null;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssetPackManifest)) {
            return false;
        }
        AssetPackManifest other = (AssetPackManifest)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.group, other.group) && Objects.equals(this.website, other.website) && Objects.equals(this.description, other.description) && Objects.equals(this.version, other.version) && Arrays.equals(this.authors, other.authors);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.group);
        result = 31 * result + Objects.hashCode(this.website);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Arrays.hashCode(this.authors);
        return result;
    }
}

