/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.asseteditor;

import com.hypixel.hytale.protocol.io.PacketIO;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SchemaFile {
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 1;
    public static final int VARIABLE_FIELD_COUNT = 1;
    public static final int VARIABLE_BLOCK_START = 1;
    public static final int MAX_SIZE = 16384006;
    @Nullable
    public String content;

    public SchemaFile() {
    }

    public SchemaFile(@Nullable String content) {
        this.content = content;
    }

    public SchemaFile(@Nonnull SchemaFile other) {
        this.content = other.content;
    }

    @Nonnull
    public static SchemaFile deserialize(@Nonnull ByteBuf buf, int offset) {
        SchemaFile obj = new SchemaFile();
        byte nullBits = buf.getByte(offset);
        int pos = offset + 1;
        if ((nullBits & 1) != 0) {
            int contentLen = VarInt.peek(buf, pos);
            if (contentLen < 0) {
                throw ProtocolException.negativeLength("Content", contentLen);
            }
            if (contentLen > 4096000) {
                throw ProtocolException.stringTooLong("Content", contentLen, 4096000);
            }
            int contentVarLen = VarInt.length(buf, pos);
            obj.content = PacketIO.readVarString(buf, pos, PacketIO.UTF8);
            pos += contentVarLen + contentLen;
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int pos = offset + 1;
        if ((nullBits & 1) != 0) {
            int sl = VarInt.peek(buf, pos);
            pos += VarInt.length(buf, pos) + sl;
        }
        return pos - offset;
    }

    public void serialize(@Nonnull ByteBuf buf) {
        int nullBits = 0;
        if (this.content != null) {
            nullBits = (byte)(nullBits | 1);
        }
        buf.writeByte(nullBits);
        if (this.content != null) {
            PacketIO.writeVarString(buf, this.content, 4096000);
        }
    }

    public int computeSize() {
        int size = 1;
        if (this.content != null) {
            size += PacketIO.stringSize(this.content);
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 1) {
            return ValidationResult.error("Buffer too small: expected at least 1 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        int pos = offset + 1;
        if ((nullBits & 1) != 0) {
            int contentLen = VarInt.peek(buffer, pos);
            if (contentLen < 0) {
                return ValidationResult.error("Invalid string length for Content");
            }
            if (contentLen > 4096000) {
                return ValidationResult.error("Content exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += contentLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Content");
            }
        }
        return ValidationResult.OK;
    }

    public SchemaFile clone() {
        SchemaFile copy = new SchemaFile();
        copy.content = this.content;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SchemaFile)) {
            return false;
        }
        SchemaFile other = (SchemaFile)obj;
        return Objects.equals(this.content, other.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }
}

