/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.asseteditor;

import com.hypixel.hytale.protocol.FormattedMessage;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.io.ValidationResult;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SuccessReply
implements Packet {
    public static final int PACKET_ID = 301;
    public static final boolean IS_COMPRESSED = false;
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 5;
    public static final int VARIABLE_FIELD_COUNT = 1;
    public static final int VARIABLE_BLOCK_START = 5;
    public static final int MAX_SIZE = 0x64000000;
    public int token;
    @Nullable
    public FormattedMessage message;

    @Override
    public int getId() {
        return 301;
    }

    public SuccessReply() {
    }

    public SuccessReply(int token, @Nullable FormattedMessage message) {
        this.token = token;
        this.message = message;
    }

    public SuccessReply(@Nonnull SuccessReply other) {
        this.token = other.token;
        this.message = other.message;
    }

    @Nonnull
    public static SuccessReply deserialize(@Nonnull ByteBuf buf, int offset) {
        SuccessReply obj = new SuccessReply();
        byte nullBits = buf.getByte(offset);
        obj.token = buf.getIntLE(offset + 1);
        int pos = offset + 5;
        if ((nullBits & 1) != 0) {
            obj.message = FormattedMessage.deserialize(buf, pos);
            pos += FormattedMessage.computeBytesConsumed(buf, pos);
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int pos = offset + 5;
        if ((nullBits & 1) != 0) {
            pos += FormattedMessage.computeBytesConsumed(buf, pos);
        }
        return pos - offset;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        int nullBits = 0;
        if (this.message != null) {
            nullBits = (byte)(nullBits | 1);
        }
        buf.writeByte(nullBits);
        buf.writeIntLE(this.token);
        if (this.message != null) {
            this.message.serialize(buf);
        }
    }

    @Override
    public int computeSize() {
        int size = 5;
        if (this.message != null) {
            size += this.message.computeSize();
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 5) {
            return ValidationResult.error("Buffer too small: expected at least 5 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        int pos = offset + 5;
        if ((nullBits & 1) != 0) {
            ValidationResult messageResult = FormattedMessage.validateStructure(buffer, pos);
            if (!messageResult.isValid()) {
                return ValidationResult.error("Invalid Message: " + messageResult.error());
            }
            pos += FormattedMessage.computeBytesConsumed(buffer, pos);
        }
        return ValidationResult.OK;
    }

    public SuccessReply clone() {
        SuccessReply copy = new SuccessReply();
        copy.token = this.token;
        copy.message = this.message != null ? this.message.clone() : null;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SuccessReply)) {
            return false;
        }
        SuccessReply other = (SuccessReply)obj;
        return this.token == other.token && Objects.equals(this.message, other.message);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.message);
    }
}

