/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.assets;

import com.hypixel.hytale.protocol.ItemReticleConfig;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.UpdateType;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateItemReticles
implements Packet {
    public static final int PACKET_ID = 57;
    public static final boolean IS_COMPRESSED = true;
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 6;
    public static final int VARIABLE_FIELD_COUNT = 1;
    public static final int VARIABLE_BLOCK_START = 6;
    public static final int MAX_SIZE = 0x64000000;
    @Nonnull
    public UpdateType type = UpdateType.Init;
    public int maxId;
    @Nullable
    public Map<Integer, ItemReticleConfig> itemReticleConfigs;

    @Override
    public int getId() {
        return 57;
    }

    public UpdateItemReticles() {
    }

    public UpdateItemReticles(@Nonnull UpdateType type, int maxId, @Nullable Map<Integer, ItemReticleConfig> itemReticleConfigs) {
        this.type = type;
        this.maxId = maxId;
        this.itemReticleConfigs = itemReticleConfigs;
    }

    public UpdateItemReticles(@Nonnull UpdateItemReticles other) {
        this.type = other.type;
        this.maxId = other.maxId;
        this.itemReticleConfigs = other.itemReticleConfigs;
    }

    @Nonnull
    public static UpdateItemReticles deserialize(@Nonnull ByteBuf buf, int offset) {
        UpdateItemReticles obj = new UpdateItemReticles();
        byte nullBits = buf.getByte(offset);
        obj.type = UpdateType.fromValue(buf.getByte(offset + 1));
        obj.maxId = buf.getIntLE(offset + 2);
        int pos = offset + 6;
        if ((nullBits & 1) != 0) {
            int itemReticleConfigsCount = VarInt.peek(buf, pos);
            if (itemReticleConfigsCount < 0) {
                throw ProtocolException.negativeLength("ItemReticleConfigs", itemReticleConfigsCount);
            }
            if (itemReticleConfigsCount > 4096000) {
                throw ProtocolException.dictionaryTooLarge("ItemReticleConfigs", itemReticleConfigsCount, 4096000);
            }
            pos += VarInt.size(itemReticleConfigsCount);
            obj.itemReticleConfigs = new HashMap<Integer, ItemReticleConfig>(itemReticleConfigsCount);
            for (int i = 0; i < itemReticleConfigsCount; ++i) {
                int key = buf.getIntLE(pos);
                ItemReticleConfig val = ItemReticleConfig.deserialize(buf, pos += 4);
                pos += ItemReticleConfig.computeBytesConsumed(buf, pos);
                if (obj.itemReticleConfigs.put(key, val) == null) continue;
                throw ProtocolException.duplicateKey("itemReticleConfigs", key);
            }
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int pos = offset + 6;
        if ((nullBits & 1) != 0) {
            int dictLen = VarInt.peek(buf, pos);
            pos += VarInt.length(buf, pos);
            for (int i = 0; i < dictLen; ++i) {
                pos += 4;
                pos += ItemReticleConfig.computeBytesConsumed(buf, pos);
            }
        }
        return pos - offset;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        int nullBits = 0;
        if (this.itemReticleConfigs != null) {
            nullBits = (byte)(nullBits | 1);
        }
        buf.writeByte(nullBits);
        buf.writeByte(this.type.getValue());
        buf.writeIntLE(this.maxId);
        if (this.itemReticleConfigs != null) {
            if (this.itemReticleConfigs.size() > 4096000) {
                throw ProtocolException.dictionaryTooLarge("ItemReticleConfigs", this.itemReticleConfigs.size(), 4096000);
            }
            VarInt.write(buf, this.itemReticleConfigs.size());
            for (Map.Entry<Integer, ItemReticleConfig> e : this.itemReticleConfigs.entrySet()) {
                buf.writeIntLE(e.getKey());
                e.getValue().serialize(buf);
            }
        }
    }

    @Override
    public int computeSize() {
        int size = 6;
        if (this.itemReticleConfigs != null) {
            int itemReticleConfigsSize = 0;
            for (Map.Entry<Integer, ItemReticleConfig> kvp : this.itemReticleConfigs.entrySet()) {
                itemReticleConfigsSize += 4 + kvp.getValue().computeSize();
            }
            size += VarInt.size(this.itemReticleConfigs.size()) + itemReticleConfigsSize;
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 6) {
            return ValidationResult.error("Buffer too small: expected at least 6 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        int pos = offset + 6;
        if ((nullBits & 1) != 0) {
            int itemReticleConfigsCount = VarInt.peek(buffer, pos);
            if (itemReticleConfigsCount < 0) {
                return ValidationResult.error("Invalid dictionary count for ItemReticleConfigs");
            }
            if (itemReticleConfigsCount > 4096000) {
                return ValidationResult.error("ItemReticleConfigs exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            for (int i = 0; i < itemReticleConfigsCount; ++i) {
                if ((pos += 4) > buffer.writerIndex()) {
                    return ValidationResult.error("Buffer overflow reading key");
                }
                pos += ItemReticleConfig.computeBytesConsumed(buffer, pos);
            }
        }
        return ValidationResult.OK;
    }

    public UpdateItemReticles clone() {
        UpdateItemReticles copy = new UpdateItemReticles();
        copy.type = this.type;
        copy.maxId = this.maxId;
        if (this.itemReticleConfigs != null) {
            HashMap<Integer, ItemReticleConfig> m = new HashMap<Integer, ItemReticleConfig>();
            for (Map.Entry<Integer, ItemReticleConfig> e : this.itemReticleConfigs.entrySet()) {
                m.put(e.getKey(), e.getValue().clone());
            }
            copy.itemReticleConfigs = m;
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateItemReticles)) {
            return false;
        }
        UpdateItemReticles other = (UpdateItemReticles)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && this.maxId == other.maxId && Objects.equals(this.itemReticleConfigs, other.itemReticleConfigs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.maxId, this.itemReticleConfigs});
    }
}

