/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.assets;

import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.RootInteraction;
import com.hypixel.hytale.protocol.UpdateType;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateRootInteractions
implements Packet {
    public static final int PACKET_ID = 67;
    public static final boolean IS_COMPRESSED = true;
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 6;
    public static final int VARIABLE_FIELD_COUNT = 1;
    public static final int VARIABLE_BLOCK_START = 6;
    public static final int MAX_SIZE = 0x64000000;
    @Nonnull
    public UpdateType type = UpdateType.Init;
    public int maxId;
    @Nullable
    public Map<Integer, RootInteraction> interactions;

    @Override
    public int getId() {
        return 67;
    }

    public UpdateRootInteractions() {
    }

    public UpdateRootInteractions(@Nonnull UpdateType type, int maxId, @Nullable Map<Integer, RootInteraction> interactions) {
        this.type = type;
        this.maxId = maxId;
        this.interactions = interactions;
    }

    public UpdateRootInteractions(@Nonnull UpdateRootInteractions other) {
        this.type = other.type;
        this.maxId = other.maxId;
        this.interactions = other.interactions;
    }

    @Nonnull
    public static UpdateRootInteractions deserialize(@Nonnull ByteBuf buf, int offset) {
        UpdateRootInteractions obj = new UpdateRootInteractions();
        byte nullBits = buf.getByte(offset);
        obj.type = UpdateType.fromValue(buf.getByte(offset + 1));
        obj.maxId = buf.getIntLE(offset + 2);
        int pos = offset + 6;
        if ((nullBits & 1) != 0) {
            int interactionsCount = VarInt.peek(buf, pos);
            if (interactionsCount < 0) {
                throw ProtocolException.negativeLength("Interactions", interactionsCount);
            }
            if (interactionsCount > 4096000) {
                throw ProtocolException.dictionaryTooLarge("Interactions", interactionsCount, 4096000);
            }
            pos += VarInt.size(interactionsCount);
            obj.interactions = new HashMap<Integer, RootInteraction>(interactionsCount);
            for (int i = 0; i < interactionsCount; ++i) {
                int key = buf.getIntLE(pos);
                RootInteraction val = RootInteraction.deserialize(buf, pos += 4);
                pos += RootInteraction.computeBytesConsumed(buf, pos);
                if (obj.interactions.put(key, val) == null) continue;
                throw ProtocolException.duplicateKey("interactions", key);
            }
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int pos = offset + 6;
        if ((nullBits & 1) != 0) {
            int dictLen = VarInt.peek(buf, pos);
            pos += VarInt.length(buf, pos);
            for (int i = 0; i < dictLen; ++i) {
                pos += 4;
                pos += RootInteraction.computeBytesConsumed(buf, pos);
            }
        }
        return pos - offset;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        int nullBits = 0;
        if (this.interactions != null) {
            nullBits = (byte)(nullBits | 1);
        }
        buf.writeByte(nullBits);
        buf.writeByte(this.type.getValue());
        buf.writeIntLE(this.maxId);
        if (this.interactions != null) {
            if (this.interactions.size() > 4096000) {
                throw ProtocolException.dictionaryTooLarge("Interactions", this.interactions.size(), 4096000);
            }
            VarInt.write(buf, this.interactions.size());
            for (Map.Entry<Integer, RootInteraction> e : this.interactions.entrySet()) {
                buf.writeIntLE(e.getKey());
                e.getValue().serialize(buf);
            }
        }
    }

    @Override
    public int computeSize() {
        int size = 6;
        if (this.interactions != null) {
            int interactionsSize = 0;
            for (Map.Entry<Integer, RootInteraction> kvp : this.interactions.entrySet()) {
                interactionsSize += 4 + kvp.getValue().computeSize();
            }
            size += VarInt.size(this.interactions.size()) + interactionsSize;
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 6) {
            return ValidationResult.error("Buffer too small: expected at least 6 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        int pos = offset + 6;
        if ((nullBits & 1) != 0) {
            int interactionsCount = VarInt.peek(buffer, pos);
            if (interactionsCount < 0) {
                return ValidationResult.error("Invalid dictionary count for Interactions");
            }
            if (interactionsCount > 4096000) {
                return ValidationResult.error("Interactions exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            for (int i = 0; i < interactionsCount; ++i) {
                if ((pos += 4) > buffer.writerIndex()) {
                    return ValidationResult.error("Buffer overflow reading key");
                }
                pos += RootInteraction.computeBytesConsumed(buffer, pos);
            }
        }
        return ValidationResult.OK;
    }

    public UpdateRootInteractions clone() {
        UpdateRootInteractions copy = new UpdateRootInteractions();
        copy.type = this.type;
        copy.maxId = this.maxId;
        if (this.interactions != null) {
            HashMap<Integer, RootInteraction> m = new HashMap<Integer, RootInteraction>();
            for (Map.Entry<Integer, RootInteraction> e : this.interactions.entrySet()) {
                m.put(e.getKey(), e.getValue().clone());
            }
            copy.interactions = m;
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateRootInteractions)) {
            return false;
        }
        UpdateRootInteractions other = (UpdateRootInteractions)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && this.maxId == other.maxId && Objects.equals(this.interactions, other.interactions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.maxId, this.interactions});
    }
}

