/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.assets;

import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.UpdateType;
import com.hypixel.hytale.protocol.io.PacketIO;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateTranslations
implements Packet {
    public static final int PACKET_ID = 64;
    public static final boolean IS_COMPRESSED = true;
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 2;
    public static final int VARIABLE_FIELD_COUNT = 1;
    public static final int VARIABLE_BLOCK_START = 2;
    public static final int MAX_SIZE = 0x64000000;
    @Nonnull
    public UpdateType type = UpdateType.Init;
    @Nullable
    public Map<String, String> translations;

    @Override
    public int getId() {
        return 64;
    }

    public UpdateTranslations() {
    }

    public UpdateTranslations(@Nonnull UpdateType type, @Nullable Map<String, String> translations) {
        this.type = type;
        this.translations = translations;
    }

    public UpdateTranslations(@Nonnull UpdateTranslations other) {
        this.type = other.type;
        this.translations = other.translations;
    }

    @Nonnull
    public static UpdateTranslations deserialize(@Nonnull ByteBuf buf, int offset) {
        UpdateTranslations obj = new UpdateTranslations();
        byte nullBits = buf.getByte(offset);
        obj.type = UpdateType.fromValue(buf.getByte(offset + 1));
        int pos = offset + 2;
        if ((nullBits & 1) != 0) {
            int translationsCount = VarInt.peek(buf, pos);
            if (translationsCount < 0) {
                throw ProtocolException.negativeLength("Translations", translationsCount);
            }
            if (translationsCount > 4096000) {
                throw ProtocolException.dictionaryTooLarge("Translations", translationsCount, 4096000);
            }
            pos += VarInt.size(translationsCount);
            obj.translations = new HashMap<String, String>(translationsCount);
            for (int i = 0; i < translationsCount; ++i) {
                int keyLen = VarInt.peek(buf, pos);
                if (keyLen < 0) {
                    throw ProtocolException.negativeLength("key", keyLen);
                }
                if (keyLen > 4096000) {
                    throw ProtocolException.stringTooLong("key", keyLen, 4096000);
                }
                int keyVarLen = VarInt.length(buf, pos);
                String key = PacketIO.readVarString(buf, pos);
                int valLen = VarInt.peek(buf, pos += keyVarLen + keyLen);
                if (valLen < 0) {
                    throw ProtocolException.negativeLength("val", valLen);
                }
                if (valLen > 4096000) {
                    throw ProtocolException.stringTooLong("val", valLen, 4096000);
                }
                int valVarLen = VarInt.length(buf, pos);
                String val = PacketIO.readVarString(buf, pos);
                pos += valVarLen + valLen;
                if (obj.translations.put(key, val) == null) continue;
                throw ProtocolException.duplicateKey("translations", key);
            }
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int pos = offset + 2;
        if ((nullBits & 1) != 0) {
            int dictLen = VarInt.peek(buf, pos);
            pos += VarInt.length(buf, pos);
            for (int i = 0; i < dictLen; ++i) {
                int sl = VarInt.peek(buf, pos);
                pos += VarInt.length(buf, pos) + sl;
                sl = VarInt.peek(buf, pos);
                pos += VarInt.length(buf, pos) + sl;
            }
        }
        return pos - offset;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        int nullBits = 0;
        if (this.translations != null) {
            nullBits = (byte)(nullBits | 1);
        }
        buf.writeByte(nullBits);
        buf.writeByte(this.type.getValue());
        if (this.translations != null) {
            if (this.translations.size() > 4096000) {
                throw ProtocolException.dictionaryTooLarge("Translations", this.translations.size(), 4096000);
            }
            VarInt.write(buf, this.translations.size());
            for (Map.Entry<String, String> e : this.translations.entrySet()) {
                PacketIO.writeVarString(buf, e.getKey(), 4096000);
                PacketIO.writeVarString(buf, e.getValue(), 4096000);
            }
        }
    }

    @Override
    public int computeSize() {
        int size = 2;
        if (this.translations != null) {
            int translationsSize = 0;
            for (Map.Entry<String, String> kvp : this.translations.entrySet()) {
                translationsSize += PacketIO.stringSize(kvp.getKey()) + PacketIO.stringSize(kvp.getValue());
            }
            size += VarInt.size(this.translations.size()) + translationsSize;
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 2) {
            return ValidationResult.error("Buffer too small: expected at least 2 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        int pos = offset + 2;
        if ((nullBits & 1) != 0) {
            int translationsCount = VarInt.peek(buffer, pos);
            if (translationsCount < 0) {
                return ValidationResult.error("Invalid dictionary count for Translations");
            }
            if (translationsCount > 4096000) {
                return ValidationResult.error("Translations exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            for (int i = 0; i < translationsCount; ++i) {
                int keyLen = VarInt.peek(buffer, pos);
                if (keyLen < 0) {
                    return ValidationResult.error("Invalid string length for key");
                }
                if (keyLen > 4096000) {
                    return ValidationResult.error("key exceeds max length 4096000");
                }
                pos += VarInt.length(buffer, pos);
                if ((pos += keyLen) > buffer.writerIndex()) {
                    return ValidationResult.error("Buffer overflow reading key");
                }
                int valueLen = VarInt.peek(buffer, pos);
                if (valueLen < 0) {
                    return ValidationResult.error("Invalid string length for value");
                }
                if (valueLen > 4096000) {
                    return ValidationResult.error("value exceeds max length 4096000");
                }
                pos += VarInt.length(buffer, pos);
                if ((pos += valueLen) <= buffer.writerIndex()) continue;
                return ValidationResult.error("Buffer overflow reading value");
            }
        }
        return ValidationResult.OK;
    }

    public UpdateTranslations clone() {
        UpdateTranslations copy = new UpdateTranslations();
        copy.type = this.type;
        copy.translations = this.translations != null ? new HashMap<String, String>(this.translations) : null;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateTranslations)) {
            return false;
        }
        UpdateTranslations other = (UpdateTranslations)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.translations, other.translations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.translations});
    }
}

