/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.buildertools;

import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.io.ValidationResult;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BuilderToolShowAnchor
implements Packet {
    public static final int PACKET_ID = 415;
    public static final boolean IS_COMPRESSED = false;
    public static final int NULLABLE_BIT_FIELD_SIZE = 0;
    public static final int FIXED_BLOCK_SIZE = 12;
    public static final int VARIABLE_FIELD_COUNT = 0;
    public static final int VARIABLE_BLOCK_START = 12;
    public static final int MAX_SIZE = 12;
    public int x;
    public int y;
    public int z;

    @Override
    public int getId() {
        return 415;
    }

    public BuilderToolShowAnchor() {
    }

    public BuilderToolShowAnchor(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BuilderToolShowAnchor(@Nonnull BuilderToolShowAnchor other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    @Nonnull
    public static BuilderToolShowAnchor deserialize(@Nonnull ByteBuf buf, int offset) {
        BuilderToolShowAnchor obj = new BuilderToolShowAnchor();
        obj.x = buf.getIntLE(offset + 0);
        obj.y = buf.getIntLE(offset + 4);
        obj.z = buf.getIntLE(offset + 8);
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        return 12;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        buf.writeIntLE(this.x);
        buf.writeIntLE(this.y);
        buf.writeIntLE(this.z);
    }

    @Override
    public int computeSize() {
        return 12;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 12) {
            return ValidationResult.error("Buffer too small: expected at least 12 bytes");
        }
        return ValidationResult.OK;
    }

    public BuilderToolShowAnchor clone() {
        BuilderToolShowAnchor copy = new BuilderToolShowAnchor();
        copy.x = this.x;
        copy.y = this.y;
        copy.z = this.z;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuilderToolShowAnchor)) {
            return false;
        }
        BuilderToolShowAnchor other = (BuilderToolShowAnchor)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }
}

