/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.interface_;

import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.io.PacketIO;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChatMessage
implements Packet {
    public static final int PACKET_ID = 211;
    public static final boolean IS_COMPRESSED = false;
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 1;
    public static final int VARIABLE_FIELD_COUNT = 1;
    public static final int VARIABLE_BLOCK_START = 1;
    public static final int MAX_SIZE = 16384006;
    @Nullable
    public String message;

    @Override
    public int getId() {
        return 211;
    }

    public ChatMessage() {
    }

    public ChatMessage(@Nullable String message) {
        this.message = message;
    }

    public ChatMessage(@Nonnull ChatMessage other) {
        this.message = other.message;
    }

    @Nonnull
    public static ChatMessage deserialize(@Nonnull ByteBuf buf, int offset) {
        ChatMessage obj = new ChatMessage();
        byte nullBits = buf.getByte(offset);
        int pos = offset + 1;
        if ((nullBits & 1) != 0) {
            int messageLen = VarInt.peek(buf, pos);
            if (messageLen < 0) {
                throw ProtocolException.negativeLength("Message", messageLen);
            }
            if (messageLen > 4096000) {
                throw ProtocolException.stringTooLong("Message", messageLen, 4096000);
            }
            int messageVarLen = VarInt.length(buf, pos);
            obj.message = PacketIO.readVarString(buf, pos, PacketIO.UTF8);
            pos += messageVarLen + messageLen;
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int pos = offset + 1;
        if ((nullBits & 1) != 0) {
            int sl = VarInt.peek(buf, pos);
            pos += VarInt.length(buf, pos) + sl;
        }
        return pos - offset;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        int nullBits = 0;
        if (this.message != null) {
            nullBits = (byte)(nullBits | 1);
        }
        buf.writeByte(nullBits);
        if (this.message != null) {
            PacketIO.writeVarString(buf, this.message, 4096000);
        }
    }

    @Override
    public int computeSize() {
        int size = 1;
        if (this.message != null) {
            size += PacketIO.stringSize(this.message);
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 1) {
            return ValidationResult.error("Buffer too small: expected at least 1 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        int pos = offset + 1;
        if ((nullBits & 1) != 0) {
            int messageLen = VarInt.peek(buffer, pos);
            if (messageLen < 0) {
                return ValidationResult.error("Invalid string length for Message");
            }
            if (messageLen > 4096000) {
                return ValidationResult.error("Message exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += messageLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading Message");
            }
        }
        return ValidationResult.OK;
    }

    public ChatMessage clone() {
        ChatMessage copy = new ChatMessage();
        copy.message = this.message;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)obj;
        return Objects.equals(this.message, other.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }
}

