/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.window;

import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.packets.window.WindowType;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ClientOpenWindow
implements Packet {
    public static final int PACKET_ID = 204;
    public static final boolean IS_COMPRESSED = false;
    public static final int NULLABLE_BIT_FIELD_SIZE = 0;
    public static final int FIXED_BLOCK_SIZE = 1;
    public static final int VARIABLE_FIELD_COUNT = 0;
    public static final int VARIABLE_BLOCK_START = 1;
    public static final int MAX_SIZE = 1;
    @Nonnull
    public WindowType type = WindowType.Container;

    @Override
    public int getId() {
        return 204;
    }

    public ClientOpenWindow() {
    }

    public ClientOpenWindow(@Nonnull WindowType type) {
        this.type = type;
    }

    public ClientOpenWindow(@Nonnull ClientOpenWindow other) {
        this.type = other.type;
    }

    @Nonnull
    public static ClientOpenWindow deserialize(@Nonnull ByteBuf buf, int offset) {
        ClientOpenWindow obj = new ClientOpenWindow();
        obj.type = WindowType.fromValue(buf.getByte(offset + 0));
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        return 1;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        buf.writeByte(this.type.getValue());
    }

    @Override
    public int computeSize() {
        return 1;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        if (buffer.readableBytes() - offset < 1) {
            return ValidationResult.error("Buffer too small: expected at least 1 bytes");
        }
        return ValidationResult.OK;
    }

    public ClientOpenWindow clone() {
        ClientOpenWindow copy = new ClientOpenWindow();
        copy.type = this.type;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientOpenWindow)) {
            return false;
        }
        ClientOpenWindow other = (ClientOpenWindow)obj;
        return Objects.equals((Object)this.type, (Object)other.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }
}

