/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.protocol.packets.window;

import com.hypixel.hytale.protocol.ExtraResources;
import com.hypixel.hytale.protocol.InventorySection;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.io.PacketIO;
import com.hypixel.hytale.protocol.io.ProtocolException;
import com.hypixel.hytale.protocol.io.ValidationResult;
import com.hypixel.hytale.protocol.io.VarInt;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UpdateWindow
implements Packet {
    public static final int PACKET_ID = 201;
    public static final boolean IS_COMPRESSED = true;
    public static final int NULLABLE_BIT_FIELD_SIZE = 1;
    public static final int FIXED_BLOCK_SIZE = 5;
    public static final int VARIABLE_FIELD_COUNT = 3;
    public static final int VARIABLE_BLOCK_START = 17;
    public static final int MAX_SIZE = 0x64000000;
    public int id;
    @Nullable
    public String windowData;
    @Nullable
    public InventorySection inventory;
    @Nullable
    public ExtraResources extraResources;

    @Override
    public int getId() {
        return 201;
    }

    public UpdateWindow() {
    }

    public UpdateWindow(int id, @Nullable String windowData, @Nullable InventorySection inventory, @Nullable ExtraResources extraResources) {
        this.id = id;
        this.windowData = windowData;
        this.inventory = inventory;
        this.extraResources = extraResources;
    }

    public UpdateWindow(@Nonnull UpdateWindow other) {
        this.id = other.id;
        this.windowData = other.windowData;
        this.inventory = other.inventory;
        this.extraResources = other.extraResources;
    }

    @Nonnull
    public static UpdateWindow deserialize(@Nonnull ByteBuf buf, int offset) {
        UpdateWindow obj = new UpdateWindow();
        byte nullBits = buf.getByte(offset);
        obj.id = buf.getIntLE(offset + 1);
        if ((nullBits & 1) != 0) {
            int varPos0 = offset + 17 + buf.getIntLE(offset + 5);
            int windowDataLen = VarInt.peek(buf, varPos0);
            if (windowDataLen < 0) {
                throw ProtocolException.negativeLength("WindowData", windowDataLen);
            }
            if (windowDataLen > 4096000) {
                throw ProtocolException.stringTooLong("WindowData", windowDataLen, 4096000);
            }
            obj.windowData = PacketIO.readVarString(buf, varPos0, PacketIO.UTF8);
        }
        if ((nullBits & 2) != 0) {
            int varPos1 = offset + 17 + buf.getIntLE(offset + 9);
            obj.inventory = InventorySection.deserialize(buf, varPos1);
        }
        if ((nullBits & 4) != 0) {
            int varPos2 = offset + 17 + buf.getIntLE(offset + 13);
            obj.extraResources = ExtraResources.deserialize(buf, varPos2);
        }
        return obj;
    }

    public static int computeBytesConsumed(@Nonnull ByteBuf buf, int offset) {
        byte nullBits = buf.getByte(offset);
        int maxEnd = 17;
        if ((nullBits & 1) != 0) {
            int fieldOffset0 = buf.getIntLE(offset + 5);
            int pos0 = offset + 17 + fieldOffset0;
            int sl = VarInt.peek(buf, pos0);
            if ((pos0 += VarInt.length(buf, pos0) + sl) - offset > maxEnd) {
                maxEnd = pos0 - offset;
            }
        }
        if ((nullBits & 2) != 0) {
            int fieldOffset1 = buf.getIntLE(offset + 9);
            int pos1 = offset + 17 + fieldOffset1;
            if ((pos1 += InventorySection.computeBytesConsumed(buf, pos1)) - offset > maxEnd) {
                maxEnd = pos1 - offset;
            }
        }
        if ((nullBits & 4) != 0) {
            int fieldOffset2 = buf.getIntLE(offset + 13);
            int pos2 = offset + 17 + fieldOffset2;
            if ((pos2 += ExtraResources.computeBytesConsumed(buf, pos2)) - offset > maxEnd) {
                maxEnd = pos2 - offset;
            }
        }
        return maxEnd;
    }

    @Override
    public void serialize(@Nonnull ByteBuf buf) {
        int startPos = buf.writerIndex();
        byte nullBits = 0;
        if (this.windowData != null) {
            nullBits = (byte)(nullBits | 1);
        }
        if (this.inventory != null) {
            nullBits = (byte)(nullBits | 2);
        }
        if (this.extraResources != null) {
            nullBits = (byte)(nullBits | 4);
        }
        buf.writeByte(nullBits);
        buf.writeIntLE(this.id);
        int windowDataOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int inventoryOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int extraResourcesOffsetSlot = buf.writerIndex();
        buf.writeIntLE(0);
        int varBlockStart = buf.writerIndex();
        if (this.windowData != null) {
            buf.setIntLE(windowDataOffsetSlot, buf.writerIndex() - varBlockStart);
            PacketIO.writeVarString(buf, this.windowData, 4096000);
        } else {
            buf.setIntLE(windowDataOffsetSlot, -1);
        }
        if (this.inventory != null) {
            buf.setIntLE(inventoryOffsetSlot, buf.writerIndex() - varBlockStart);
            this.inventory.serialize(buf);
        } else {
            buf.setIntLE(inventoryOffsetSlot, -1);
        }
        if (this.extraResources != null) {
            buf.setIntLE(extraResourcesOffsetSlot, buf.writerIndex() - varBlockStart);
            this.extraResources.serialize(buf);
        } else {
            buf.setIntLE(extraResourcesOffsetSlot, -1);
        }
    }

    @Override
    public int computeSize() {
        int size = 17;
        if (this.windowData != null) {
            size += PacketIO.stringSize(this.windowData);
        }
        if (this.inventory != null) {
            size += this.inventory.computeSize();
        }
        if (this.extraResources != null) {
            size += this.extraResources.computeSize();
        }
        return size;
    }

    public static ValidationResult validateStructure(@Nonnull ByteBuf buffer, int offset) {
        int pos;
        if (buffer.readableBytes() - offset < 17) {
            return ValidationResult.error("Buffer too small: expected at least 17 bytes");
        }
        byte nullBits = buffer.getByte(offset);
        if ((nullBits & 1) != 0) {
            int windowDataOffset = buffer.getIntLE(offset + 5);
            if (windowDataOffset < 0) {
                return ValidationResult.error("Invalid offset for WindowData");
            }
            pos = offset + 17 + windowDataOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for WindowData");
            }
            int windowDataLen = VarInt.peek(buffer, pos);
            if (windowDataLen < 0) {
                return ValidationResult.error("Invalid string length for WindowData");
            }
            if (windowDataLen > 4096000) {
                return ValidationResult.error("WindowData exceeds max length 4096000");
            }
            pos += VarInt.length(buffer, pos);
            if ((pos += windowDataLen) > buffer.writerIndex()) {
                return ValidationResult.error("Buffer overflow reading WindowData");
            }
        }
        if ((nullBits & 2) != 0) {
            int inventoryOffset = buffer.getIntLE(offset + 9);
            if (inventoryOffset < 0) {
                return ValidationResult.error("Invalid offset for Inventory");
            }
            pos = offset + 17 + inventoryOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for Inventory");
            }
            ValidationResult inventoryResult = InventorySection.validateStructure(buffer, pos);
            if (!inventoryResult.isValid()) {
                return ValidationResult.error("Invalid Inventory: " + inventoryResult.error());
            }
            pos += InventorySection.computeBytesConsumed(buffer, pos);
        }
        if ((nullBits & 4) != 0) {
            int extraResourcesOffset = buffer.getIntLE(offset + 13);
            if (extraResourcesOffset < 0) {
                return ValidationResult.error("Invalid offset for ExtraResources");
            }
            pos = offset + 17 + extraResourcesOffset;
            if (pos >= buffer.writerIndex()) {
                return ValidationResult.error("Offset out of bounds for ExtraResources");
            }
            ValidationResult extraResourcesResult = ExtraResources.validateStructure(buffer, pos);
            if (!extraResourcesResult.isValid()) {
                return ValidationResult.error("Invalid ExtraResources: " + extraResourcesResult.error());
            }
            pos += ExtraResources.computeBytesConsumed(buffer, pos);
        }
        return ValidationResult.OK;
    }

    public UpdateWindow clone() {
        UpdateWindow copy = new UpdateWindow();
        copy.id = this.id;
        copy.windowData = this.windowData;
        copy.inventory = this.inventory != null ? this.inventory.clone() : null;
        copy.extraResources = this.extraResources != null ? this.extraResources.clone() : null;
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateWindow)) {
            return false;
        }
        UpdateWindow other = (UpdateWindow)obj;
        return this.id == other.id && Objects.equals(this.windowData, other.windowData) && Objects.equals(this.inventory, other.inventory) && Objects.equals(this.extraResources, other.extraResources);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.windowData, this.inventory, this.extraResources);
    }
}

