/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.asset.type.ambiencefx;

import com.hypixel.hytale.assetstore.map.IndexedAssetMap;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.UpdateType;
import com.hypixel.hytale.protocol.packets.assets.UpdateAmbienceFX;
import com.hypixel.hytale.server.core.asset.packet.SimpleAssetPacketGenerator;
import com.hypixel.hytale.server.core.asset.type.ambiencefx.config.AmbienceFX;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class AmbienceFXPacketGenerator
extends SimpleAssetPacketGenerator<String, AmbienceFX, IndexedAssetMap<String, AmbienceFX>> {
    @Override
    @Nonnull
    public Packet generateInitPacket(@Nonnull IndexedAssetMap<String, AmbienceFX> assetMap, @Nonnull Map<String, AmbienceFX> assets) {
        UpdateAmbienceFX packet = new UpdateAmbienceFX();
        packet.type = UpdateType.Init;
        packet.ambienceFX = new Object2ObjectOpenHashMap<Integer, com.hypixel.hytale.protocol.AmbienceFX>();
        for (Map.Entry<String, AmbienceFX> entry : assets.entrySet()) {
            String key = entry.getKey();
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.ambienceFX.put(index, entry.getValue().toPacket());
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateUpdatePacket(@Nonnull IndexedAssetMap<String, AmbienceFX> assetMap, @Nonnull Map<String, AmbienceFX> loadedAssets) {
        UpdateAmbienceFX packet = new UpdateAmbienceFX();
        packet.type = UpdateType.AddOrUpdate;
        packet.ambienceFX = new Object2ObjectOpenHashMap<Integer, com.hypixel.hytale.protocol.AmbienceFX>();
        for (Map.Entry<String, AmbienceFX> entry : loadedAssets.entrySet()) {
            String key = entry.getKey();
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.ambienceFX.put(index, entry.getValue().toPacket());
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateRemovePacket(@Nonnull IndexedAssetMap<String, AmbienceFX> assetMap, @Nonnull Set<String> removed) {
        UpdateAmbienceFX packet = new UpdateAmbienceFX();
        packet.type = UpdateType.Remove;
        packet.ambienceFX = new Object2ObjectOpenHashMap<Integer, com.hypixel.hytale.protocol.AmbienceFX>();
        for (String key : removed) {
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.ambienceFX.put(index, null);
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }
}

