/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.asset.type.blocksound;

import com.hypixel.hytale.assetstore.map.IndexedLookupTableAssetMap;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.UpdateType;
import com.hypixel.hytale.protocol.packets.assets.UpdateBlockSoundSets;
import com.hypixel.hytale.server.core.asset.packet.SimpleAssetPacketGenerator;
import com.hypixel.hytale.server.core.asset.type.blocksound.config.BlockSoundSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class BlockSoundSetPacketGenerator
extends SimpleAssetPacketGenerator<String, BlockSoundSet, IndexedLookupTableAssetMap<String, BlockSoundSet>> {
    @Override
    @Nonnull
    public Packet generateInitPacket(@Nonnull IndexedLookupTableAssetMap<String, BlockSoundSet> assetMap, @Nonnull Map<String, BlockSoundSet> assets) {
        UpdateBlockSoundSets packet = new UpdateBlockSoundSets();
        packet.type = UpdateType.Init;
        packet.blockSoundSets = new Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.BlockSoundSet>();
        for (Map.Entry<String, BlockSoundSet> entry : assets.entrySet()) {
            String key = entry.getKey();
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.blockSoundSets.put(index, entry.getValue().toPacket());
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateUpdatePacket(@Nonnull IndexedLookupTableAssetMap<String, BlockSoundSet> assetMap, @Nonnull Map<String, BlockSoundSet> loadedAssets) {
        UpdateBlockSoundSets packet = new UpdateBlockSoundSets();
        packet.type = UpdateType.AddOrUpdate;
        packet.blockSoundSets = new Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.BlockSoundSet>();
        for (Map.Entry<String, BlockSoundSet> entry : loadedAssets.entrySet()) {
            String key = entry.getKey();
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.blockSoundSets.put(index, entry.getValue().toPacket());
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateRemovePacket(@Nonnull IndexedLookupTableAssetMap<String, BlockSoundSet> assetMap, @Nonnull Set<String> removed) {
        UpdateBlockSoundSets packet = new UpdateBlockSoundSets();
        packet.type = UpdateType.Remove;
        packet.blockSoundSets = new Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.BlockSoundSet>();
        for (String key : removed) {
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.blockSoundSets.put(index, null);
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }
}

