/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.asset.type.fluid;

import com.hypixel.hytale.assetstore.map.BlockTypeAssetMap;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.lookup.CodecMapCodec;
import com.hypixel.hytale.codec.validation.Validators;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.math.shape.Box;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.math.util.HashUtil;
import com.hypixel.hytale.math.vector.Vector2i;
import com.hypixel.hytale.protocol.BlockMaterial;
import com.hypixel.hytale.protocol.DrawType;
import com.hypixel.hytale.server.core.asset.type.blockhitbox.BlockBoundingBoxes;
import com.hypixel.hytale.server.core.asset.type.blocktick.BlockTickStrategy;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.fluid.Fluid;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.AbstractCachedAccessor;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.chunk.section.BlockSection;
import com.hypixel.hytale.server.core.universe.world.chunk.section.FluidSection;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import com.hypixel.hytale.server.core.util.FillerBlockUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class FluidTicker {
    public static final BuilderCodec<FluidTicker> BASE_CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.abstractBuilder(FluidTicker.class).appendInherited(new KeyedCodec<Float>("FlowRate", Codec.FLOAT), (ticker, r) -> {
        ticker.flowRate = r.floatValue();
    }, ticker -> Float.valueOf(ticker.flowRate), (ticker, parent) -> {
        ticker.flowRate = parent.flowRate;
    }).documentation("The tick frequency for this fluid type, in seconds").addValidator(Validators.greaterThan(Float.valueOf(0.0f))).add()).appendInherited(new KeyedCodec<Boolean>("CanDemote", Codec.BOOLEAN), (ticker, o) -> {
        ticker.canDemote = o;
    }, ticker -> ticker.canDemote, (ticker, parent) -> {
        ticker.canDemote = parent.canDemote;
    }).documentation("If false then the fluid will stay at its level").add()).appendInherited(new KeyedCodec<String>("SupportedBy", Codec.STRING), (ticker, o) -> {
        ticker.supportedBy = o;
    }, ticker -> ticker.supportedBy, (ticker, parent) -> {
        ticker.supportedBy = parent.supportedBy;
    }).add()).build();
    public static final CodecMapCodec<FluidTicker> CODEC = new CodecMapCodec("Type", true);
    protected static final Vector2i[] ORTO_OFFSETS = new Vector2i[]{new Vector2i(-1, 0), new Vector2i(1, 0), new Vector2i(0, -1), new Vector2i(0, 1)};
    protected static final int SPREAD_NO_PATH = Integer.MAX_VALUE;
    protected static final int SPREAD_NO_CHUNK = 0x7FFFFFFE;
    protected static final int OFFSET_DROP_NONE = 0;
    public static final int FLUID_BLOCK_DISTANCE = 5;
    private static final double FULL_DIMENSION_THRESHOLD = 0.9;
    private static final double PARTIAL_DIMENSION_THRESHOLD = 0.6;
    private static final double FACE_BLOCK_THRESHOLD = 0.1;
    private float flowRate = 0.5f;
    private boolean canDemote = true;
    private String supportedBy;
    private transient int supportedById = 0;

    public int getSupportedById() {
        if (this.supportedById == 0) {
            this.supportedById = this.supportedBy != null ? Fluid.getAssetMap().getIndex(this.supportedBy) : Integer.MIN_VALUE;
        }
        return this.supportedById;
    }

    public BlockTickStrategy tick(@Nonnull CommandBuffer<ChunkStore> commandBuffer, @Nonnull CachedAccessor cachedAccessor, @Nonnull FluidSection fluidSection, @Nonnull BlockSection blockSection, @Nonnull Fluid fluid, int fluidId, int worldX, int worldY, int worldZ) {
        int flowRateLimitTicks;
        long tick;
        World world = commandBuffer.getExternalData().getWorld();
        long hash = HashUtil.rehash(worldX, worldY, worldZ, 4030921250L);
        if ((hash + (tick = commandBuffer.getExternalData().getWorld().getTick())) % (long)(flowRateLimitTicks = Math.round(this.flowRate * (float)world.getTps())) != 0L) {
            return BlockTickStrategy.CONTINUE;
        }
        return this.process(world, tick, cachedAccessor, fluidSection, blockSection, fluid, fluidId, worldX, worldY, worldZ);
    }

    public BlockTickStrategy process(World world, long tick, @Nonnull Accessor accessor, @Nonnull FluidSection fluidSection, @Nonnull BlockSection blockSection, @Nonnull Fluid fluid, int fluidId, int worldX, int worldY, int worldZ) {
        int fluidLevel = fluidSection.getFluidLevel(worldX, worldY, worldZ);
        int block = blockSection.get(worldX, worldY, worldZ);
        if (FluidTicker.isFullySolid(BlockType.getAssetMap().getAsset(block))) {
            fluidSection.setFluid(worldX, worldY, worldZ, 0, (byte)0);
            FluidTicker.setTickingSurrounding(accessor, blockSection, worldX, worldY, worldZ);
            return BlockTickStrategy.SLEEP;
        }
        switch (this.isAlive(accessor, fluidSection, blockSection, fluid, fluidId, (byte)fluidLevel, worldX, worldY, worldZ).ordinal()) {
            case 2: {
                return BlockTickStrategy.WAIT_FOR_ADJACENT_CHUNK_LOAD;
            }
            case 0: {
                return this.spread(world, tick, accessor, fluidSection, blockSection, fluid, fluidId, (byte)fluidLevel, worldX, worldY, worldZ);
            }
            case 1: {
                if (fluidLevel == 1) {
                    fluidSection.setFluid(worldX, worldY, worldZ, 0, (byte)0);
                    FluidTicker.setTickingSurrounding(accessor, blockSection, worldX, worldY, worldZ);
                    return BlockTickStrategy.SLEEP;
                }
                fluidSection.setFluid(worldX, worldY, worldZ, fluidId, (byte)((fluidLevel == 0 ? fluid.getMaxFluidLevel() : fluidLevel) - 1));
                FluidTicker.setTickingSurrounding(accessor, blockSection, worldX, worldY, worldZ);
                return BlockTickStrategy.SLEEP;
            }
        }
        return BlockTickStrategy.SLEEP;
    }

    @Nonnull
    protected AliveStatus isAlive(@Nonnull Accessor accessor, @Nonnull FluidSection fluidSection, @Nonnull BlockSection blockSection, Fluid fluid, int fluidId, byte fluidLevel, int worldX, int worldY, int worldZ) {
        FluidSection aboveFluidSection;
        if (!this.canDemote) {
            return AliveStatus.ALIVE;
        }
        int supportId = this.getSupportedById();
        BlockTypeAssetMap<String, BlockType> blockMap = BlockType.getAssetMap();
        FluidSection fluidSection2 = aboveFluidSection = ChunkUtil.chunkCoordinate(worldY + 1) == fluidSection.getY() ? fluidSection : accessor.getFluidSectionByBlock(worldX, worldY + 1, worldZ);
        if (aboveFluidSection == null) {
            return AliveStatus.WAIT_FOR_ADJACENT_CHUNK;
        }
        int fluidAbove = aboveFluidSection.getFluidId(worldX, worldY + 1, worldZ);
        if (fluidAbove == fluidId || fluidAbove == supportId) {
            return AliveStatus.ALIVE;
        }
        BlockType thisBlock = blockMap.getAsset(blockSection.get(worldX, worldY, worldZ));
        int thisRotation = blockSection.getRotationIndex(worldX, worldY, worldZ);
        int thisFiller = blockSection.getFiller(worldX, worldY, worldZ);
        boolean chunkNotLoaded = false;
        for (Vector2i offset : ORTO_OFFSETS) {
            int sourceFiller;
            int sourceRotation;
            BlockType sourceBlock;
            BlockSection otherBlockSection;
            int x = offset.x;
            int blockX = x + worldX;
            int blockY = worldY;
            int z = offset.y;
            int blockZ = z + worldZ;
            boolean isDifferentSection = !ChunkUtil.isSameChunkSection(worldX, worldY, worldZ, blockX, blockY, blockZ);
            FluidSection otherFluidSection = isDifferentSection ? accessor.getFluidSectionByBlock(blockX, blockY, blockZ) : fluidSection;
            BlockSection blockSection2 = otherBlockSection = isDifferentSection ? accessor.getBlockSectionByBlock(blockX, blockY, blockZ) : blockSection;
            if (otherFluidSection == null || otherBlockSection == null) {
                chunkNotLoaded = true;
                continue;
            }
            int otherFluid = otherFluidSection.getFluidId(blockX, worldY, blockZ);
            if (supportId != Integer.MIN_VALUE && otherFluid == supportId) {
                int sourceFiller2;
                int sourceRotation2;
                BlockType sourceBlock2 = blockMap.getAsset(otherBlockSection.get(blockX, blockY, blockZ));
                if (sourceBlock2 == null || FluidTicker.blocksFluidFrom(sourceBlock2, sourceRotation2 = otherBlockSection.getRotationIndex(blockX, blockY, blockZ), x, z, sourceFiller2 = otherBlockSection.getFiller(blockX, blockY, blockZ)) || FluidTicker.blocksFluidFrom(thisBlock, thisRotation, -x, -z, thisFiller)) continue;
                return AliveStatus.ALIVE;
            }
            byte otherFluidLevel = otherFluidSection.getFluidLevel(blockX, blockY, blockZ);
            if (otherFluid == 0 || otherFluid != fluidId || otherFluidLevel <= fluidLevel || (sourceBlock = blockMap.getAsset(otherBlockSection.get(blockX, blockY, blockZ))) == null || FluidTicker.blocksFluidFrom(sourceBlock, sourceRotation = otherBlockSection.getRotationIndex(blockX, blockY, blockZ), x, z, sourceFiller = otherBlockSection.getFiller(blockX, blockY, blockZ)) || FluidTicker.blocksFluidFrom(thisBlock, thisRotation, -x, -z, thisFiller)) continue;
            return AliveStatus.ALIVE;
        }
        if (chunkNotLoaded) {
            return AliveStatus.WAIT_FOR_ADJACENT_CHUNK;
        }
        return AliveStatus.DEMOTE;
    }

    protected abstract BlockTickStrategy spread(World var1, long var2, Accessor var4, FluidSection var5, BlockSection var6, Fluid var7, int var8, byte var9, int var10, int var11, int var12);

    public static void setTickingSurrounding(@Nonnull Accessor accessor, BlockSection blockSection, int worldX, int worldY, int worldZ) {
        for (int y = -1; y <= 1; ++y) {
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    BlockSection chunk;
                    int bx = worldX + x;
                    int by = worldY + y;
                    int bz = worldZ + z;
                    BlockSection blockSection2 = chunk = ChunkUtil.isSameChunkSection(worldX, worldY, worldZ, bx, by, bz) ? blockSection : accessor.getBlockSectionByBlock(bx, by, bz);
                    if (chunk == null) continue;
                    chunk.setTicking(bx, by, bz, true);
                }
            }
        }
    }

    protected int getSpreadOffsets(@Nonnull BlockTypeAssetMap<String, BlockType> blockMap, @Nonnull Accessor accessor, @Nonnull FluidSection fluidSection, BlockSection blockSection, int worldX, int worldY, int worldZ, @Nonnull Vector2i[] offsetArray, int fluidId, int maxDropDistance) {
        int shortestDistanceToDrop = Integer.MAX_VALUE;
        int offsets = 0;
        if (worldY <= 0) {
            return offsets;
        }
        for (int i = 0; i < offsetArray.length; ++i) {
            Vector2i offset = offsetArray[i];
            int distance = this.distanceToDrop(blockMap, accessor, fluidSection, blockSection, worldX, worldY, worldZ, offset, fluidId, maxDropDistance);
            if (distance == 0x7FFFFFFE) {
                return 0x7FFFFFFE;
            }
            if (distance < shortestDistanceToDrop) {
                offsets = 0;
                shortestDistanceToDrop = distance;
            }
            if (distance > shortestDistanceToDrop || distance == Integer.MAX_VALUE) continue;
            offsets |= 1 << i;
        }
        return offsets;
    }

    protected int distanceToDrop(@Nonnull BlockTypeAssetMap<String, BlockType> blockMap, @Nonnull Accessor accessor, @Nonnull FluidSection fluidSection, BlockSection blockSection, int worldX, int worldY, int worldZ, @Nonnull Vector2i offset, int fluidId, int maxDropDistance) {
        boolean isBelowDifferent;
        int ox = offset.x;
        int oz = offset.y;
        int yMinus1 = worldY - 1;
        FluidSection belowFluidSection = fluidSection;
        BlockSection belowBlockSection = blockSection;
        boolean bl = isBelowDifferent = fluidSection.getY() != ChunkUtil.chunkCoordinate(yMinus1);
        if (isBelowDifferent) {
            belowFluidSection = accessor.getFluidSectionByBlock(worldX, yMinus1, worldZ);
            belowBlockSection = accessor.getBlockSectionByBlock(worldX, yMinus1, worldZ);
        }
        int curX = worldX;
        int curZ = worldZ;
        for (int i = 1; i < maxDropDistance; ++i) {
            int blockX = worldX + ox * i;
            int blockZ = worldZ + oz * i;
            if (!ChunkUtil.isSameChunk(curX, curZ, blockX, blockZ)) {
                curX = blockX;
                curZ = blockZ;
                fluidSection = accessor.getFluidSectionByBlock(blockX, worldY, blockZ);
                blockSection = accessor.getBlockSectionByBlock(blockX, worldY, blockZ);
                if (isBelowDifferent) {
                    belowFluidSection = accessor.getFluidSectionByBlock(worldX, yMinus1, worldZ);
                    belowBlockSection = accessor.getBlockSectionByBlock(worldX, yMinus1, worldZ);
                } else {
                    belowFluidSection = fluidSection;
                    belowBlockSection = blockSection;
                }
            }
            if (fluidSection == null || blockSection == null || belowFluidSection == null || belowBlockSection == null) {
                return 0x7FFFFFFE;
            }
            int otherFluidId = fluidSection.getFluidId(blockX, worldY, blockZ);
            BlockType block = blockMap.getAsset(blockSection.get(blockX, worldY, blockZ));
            if (otherFluidId != 0 && !this.isSelfFluid(fluidId, otherFluidId) || otherFluidId == 0 && FluidTicker.isSolid(block)) break;
            BlockType belowBlock = blockMap.getAsset(belowBlockSection.get(blockX, yMinus1, blockZ));
            if (FluidTicker.isSolid(belowBlock)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isFullySolid(@Nonnull BlockType blockType) {
        DrawType drawType = blockType.getDrawType();
        return blockType.getMaterial() == BlockMaterial.Solid && (drawType == DrawType.Cube || drawType == DrawType.CubeWithModel);
    }

    public static boolean isSolid(@Nonnull BlockType blockType) {
        DrawType drawType = blockType.getDrawType();
        return drawType == DrawType.Cube || drawType == DrawType.CubeWithModel;
    }

    public static boolean blocksFluidFrom(@Nonnull BlockType blockType, int rotationIndex, int offsetX, int offsetZ) {
        return FluidTicker.blocksFluidFrom(blockType, rotationIndex, offsetX, offsetZ, 0);
    }

    public static boolean blocksFluidFrom(@Nonnull BlockType blockType, int rotationIndex, int offsetX, int offsetZ, int filler) {
        boolean isPartialDepth;
        boolean isPartialWidth;
        boolean isTall;
        if (blockType.getMaterial() != BlockMaterial.Solid) {
            return false;
        }
        if (FluidTicker.isFullySolid(blockType)) {
            return true;
        }
        int hitboxIndex = blockType.getHitboxTypeIndex();
        BlockBoundingBoxes hitboxAsset = BlockBoundingBoxes.getAssetMap().getAsset(hitboxIndex);
        if (hitboxAsset == null) {
            return true;
        }
        BlockBoundingBoxes.RotatedVariantBoxes rotatedHitbox = hitboxAsset.get(rotationIndex);
        Box boundingBox = rotatedHitbox.getBoundingBox();
        if (hitboxAsset.protrudesUnitBox() || filler != 0) {
            int fillerX = FillerBlockUtil.unpackX(filler);
            int fillerY = FillerBlockUtil.unpackY(filler);
            int fillerZ = FillerBlockUtil.unpackZ(filler);
            Box[] detailBoxes = rotatedHitbox.getDetailBoxes();
            double maxCrossSectionCoverage = 0.0;
            for (Box box : detailBoxes) {
                double clampedMinX = Math.max(box.min.x, (double)fillerX);
                double clampedMaxX = Math.min(box.max.x, (double)(fillerX + 1));
                double clampedMinY = Math.max(box.min.y, (double)fillerY);
                double clampedMaxY = Math.min(box.max.y, (double)(fillerY + 1));
                double clampedMinZ = Math.max(box.min.z, (double)fillerZ);
                double clampedMaxZ = Math.min(box.max.z, (double)(fillerZ + 1));
                if (clampedMaxX <= clampedMinX || clampedMaxY <= clampedMinY || clampedMaxZ <= clampedMinZ) continue;
                double boxWidth = clampedMaxX - clampedMinX;
                double boxHeight = clampedMaxY - clampedMinY;
                double boxDepth = clampedMaxZ - clampedMinZ;
                double crossSectionCoverage = 0.0;
                if (offsetX != 0) {
                    crossSectionCoverage = boxHeight * boxDepth;
                } else if (offsetZ != 0) {
                    crossSectionCoverage = boxHeight * boxWidth;
                }
                maxCrossSectionCoverage = Math.max(maxCrossSectionCoverage, crossSectionCoverage);
            }
            return maxCrossSectionCoverage > 0.9;
        }
        double width = boundingBox.max.x - boundingBox.min.x;
        double height = boundingBox.max.y - boundingBox.min.y;
        double depth = boundingBox.max.z - boundingBox.min.z;
        boolean bl = isTall = height > 0.9;
        if (!isTall) {
            return false;
        }
        boolean isFullDepth = depth > 0.9;
        boolean bl2 = isPartialWidth = width < 0.6;
        if (isPartialWidth && isFullDepth) {
            if (offsetX != 0) {
                if (offsetX > 0) {
                    return boundingBox.min.x < 0.1;
                }
                return boundingBox.max.x > 0.9;
            }
            return false;
        }
        boolean isFullWidth = width > 0.9;
        boolean bl3 = isPartialDepth = depth < 0.6;
        if (isFullWidth && isPartialDepth) {
            if (offsetZ != 0) {
                if (offsetZ > 0) {
                    return boundingBox.min.z < 0.1;
                }
                return boundingBox.max.z > 0.9;
            }
            return false;
        }
        Box[] detailBoxes = rotatedHitbox.getDetailBoxes();
        if (detailBoxes.length > 1) {
            return FluidTicker.boxesBlockFace(detailBoxes, offsetX, offsetZ);
        }
        double faceCoverage = 0.0;
        if (offsetX > 0 && boundingBox.min.x < 0.1) {
            faceCoverage = height * depth;
        } else if (offsetX < 0 && boundingBox.max.x > 0.9) {
            faceCoverage = height * depth;
        } else if (offsetZ > 0 && boundingBox.min.z < 0.1) {
            faceCoverage = height * width;
        } else if (offsetZ < 0 && boundingBox.max.z > 0.9) {
            faceCoverage = height * width;
        }
        return faceCoverage > 0.9;
    }

    private static boolean boxesBlockFace(Box[] boxes, int offsetX, int offsetZ) {
        double totalArea = 0.0;
        for (Box box : boxes) {
            double areaOnFace = 0.0;
            if (offsetX > 0 && box.min.x < 0.1) {
                height = box.max.y - box.min.y;
                depth = box.max.z - box.min.z;
                areaOnFace = height * depth;
            } else if (offsetX < 0 && box.max.x > 0.9) {
                height = box.max.y - box.min.y;
                depth = box.max.z - box.min.z;
                areaOnFace = height * depth;
            } else if (offsetZ > 0 && box.min.z < 0.1) {
                height = box.max.y - box.min.y;
                width = box.max.x - box.min.x;
                areaOnFace = height * width;
            } else if (offsetZ < 0 && box.max.z > 0.9) {
                height = box.max.y - box.min.y;
                width = box.max.x - box.min.x;
                areaOnFace = height * width;
            }
            totalArea += areaOnFace;
        }
        return totalArea > 0.9;
    }

    public boolean isSelfFluid(int selfFluidId, int otherFluidId) {
        return selfFluidId == otherFluidId || otherFluidId == this.getSupportedById();
    }

    public boolean canDemote() {
        return this.canDemote;
    }

    public static interface Accessor {
        @Nullable
        public FluidSection getFluidSection(int var1, int var2, int var3);

        @Nullable
        default public FluidSection getFluidSectionByBlock(int bx, int by, int bz) {
            return this.getFluidSection(ChunkUtil.chunkCoordinate(bx), ChunkUtil.chunkCoordinate(by), ChunkUtil.chunkCoordinate(bz));
        }

        @Nullable
        public BlockSection getBlockSection(int var1, int var2, int var3);

        @Nullable
        default public BlockSection getBlockSectionByBlock(int bx, int by, int bz) {
            return this.getBlockSection(ChunkUtil.chunkCoordinate(bx), ChunkUtil.chunkCoordinate(by), ChunkUtil.chunkCoordinate(bz));
        }

        @Deprecated(forRemoval=true)
        public void setBlock(int var1, int var2, int var3, int var4);
    }

    protected static enum AliveStatus {
        ALIVE,
        DEMOTE,
        WAIT_FOR_ADJACENT_CHUNK;

    }

    public static class CachedAccessor
    extends AbstractCachedAccessor
    implements Accessor {
        private static final ThreadLocal<CachedAccessor> THREAD_LOCAL = ThreadLocal.withInitial(CachedAccessor::new);
        private static final int FLUID_COMPONENT = 0;
        private static final int BLOCK_COMPONENT = 1;
        private CommandBuffer<ChunkStore> commandBuffer;
        public FluidSection selfFluidSection;
        public BlockSection selfBlockSection;

        protected CachedAccessor() {
            super(2);
        }

        @Nonnull
        public static CachedAccessor of(CommandBuffer<ChunkStore> commandBuffer, @Nonnull FluidSection section, BlockSection blockSection, int radius) {
            CachedAccessor accessor = THREAD_LOCAL.get();
            accessor.init(commandBuffer, section, blockSection, radius);
            accessor.insertSectionComponent(0, section, section.getX(), section.getY(), section.getZ());
            accessor.insertSectionComponent(1, blockSection, section.getX(), section.getY(), section.getZ());
            return accessor;
        }

        private void init(CommandBuffer<ChunkStore> commandBuffer, @Nonnull FluidSection section, BlockSection blockSection, int radius) {
            this.init(commandBuffer, section.getX(), section.getY(), section.getZ(), radius);
            this.commandBuffer = commandBuffer;
            this.selfFluidSection = section;
            this.selfBlockSection = blockSection;
        }

        @Override
        public FluidSection getFluidSection(int cx, int cy, int cz) {
            return this.getComponentSection(cx, cy, cz, 0, FluidSection.getComponentType());
        }

        @Override
        public BlockSection getBlockSection(int cx, int cy, int cz) {
            return this.getComponentSection(cx, cy, cz, 1, BlockSection.getComponentType());
        }

        @Override
        public void setBlock(int x, int y, int z, int blockId) {
            Ref<ChunkStore> chunk = this.getChunk(ChunkUtil.chunkCoordinate(x), ChunkUtil.chunkCoordinate(z));
            if (chunk == null || !chunk.isValid()) {
                return;
            }
            this.commandBuffer.run(store -> {
                if (!chunk.isValid()) {
                    return;
                }
                WorldChunk wc = store.getComponent(chunk, WorldChunk.getComponentType());
                if (wc == null) {
                    return;
                }
                wc.setBlock(x, y, z, blockId);
            });
        }
    }
}

