/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.asset.type.particle.config;

import com.hypixel.hytale.assetstore.AssetExtraInfo;
import com.hypixel.hytale.assetstore.AssetKeyValidator;
import com.hypixel.hytale.assetstore.AssetRegistry;
import com.hypixel.hytale.assetstore.AssetStore;
import com.hypixel.hytale.assetstore.codec.AssetBuilderCodec;
import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.assetstore.map.JsonAssetWithMap;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.codecs.EnumCodec;
import com.hypixel.hytale.codec.codecs.array.ArrayCodec;
import com.hypixel.hytale.codec.schema.metadata.ui.UIDefaultCollapsedState;
import com.hypixel.hytale.codec.schema.metadata.ui.UIEditorSectionStart;
import com.hypixel.hytale.codec.schema.metadata.ui.UITypeIcon;
import com.hypixel.hytale.codec.validation.ValidatorCache;
import com.hypixel.hytale.codec.validation.Validators;
import com.hypixel.hytale.common.util.ArrayUtil;
import com.hypixel.hytale.protocol.EmitShape;
import com.hypixel.hytale.protocol.FXRenderMode;
import com.hypixel.hytale.protocol.InitialVelocity;
import com.hypixel.hytale.protocol.IntersectionHighlight;
import com.hypixel.hytale.protocol.ParticleRotationInfluence;
import com.hypixel.hytale.protocol.Range;
import com.hypixel.hytale.protocol.RangeVector3f;
import com.hypixel.hytale.protocol.Rangef;
import com.hypixel.hytale.protocol.UVMotion;
import com.hypixel.hytale.server.core.asset.type.particle.config.Particle;
import com.hypixel.hytale.server.core.asset.type.particle.config.ParticleAttractor;
import com.hypixel.hytale.server.core.asset.type.particle.config.ParticleCollision;
import com.hypixel.hytale.server.core.codec.ProtocolCodecs;
import com.hypixel.hytale.server.core.io.NetworkSerializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class ParticleSpawner
implements JsonAssetWithMap<String, DefaultAssetMap<String, ParticleSpawner>>,
NetworkSerializable<com.hypixel.hytale.protocol.ParticleSpawner> {
    public static final String PARTICLE_PATH = "Particles/";
    public static final String PARTICLE_EXTENSION = ".particle";
    public static final AssetBuilderCodec<String, ParticleSpawner> CODEC = ((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)((AssetBuilderCodec.Builder)AssetBuilderCodec.builder(ParticleSpawner.class, ParticleSpawner::new, Codec.STRING, (particleSpawner, s) -> {
        particleSpawner.id = s;
    }, particleSpawner -> particleSpawner.id, (asset, data) -> {
        asset.data = data;
    }, asset -> asset.data).metadata(new UITypeIcon("ParticleSpawner.png"))).appendInherited(new KeyedCodec<EmitShape>("Shape", new EnumCodec<EmitShape>(EmitShape.class)), (particleSpawner, s) -> {
        particleSpawner.shape = s;
    }, particleSpawner -> particleSpawner.shape, (particleSpawner, parent) -> {
        particleSpawner.shape = parent.shape;
    }).addValidator(Validators.nonNull()).add()).appendInherited(new KeyedCodec<RangeVector3f>("EmitOffset", ProtocolCodecs.RANGE_VECTOR3F), (particleSpawner, s) -> {
        particleSpawner.emitOffset = s;
    }, particleSpawner -> particleSpawner.emitOffset, (particleSpawner, parent) -> {
        particleSpawner.emitOffset = parent.emitOffset;
    }).add()).appendInherited(new KeyedCodec<Boolean>("UseEmitDirection", Codec.BOOLEAN), (particleSpawner, b) -> {
        particleSpawner.useEmitDirection = b;
    }, particleSpawner -> particleSpawner.useEmitDirection, (particleSpawner, parent) -> {
        particleSpawner.useEmitDirection = parent.useEmitDirection;
    }).documentation("Use spawn position to determine direction. Overrides pitch/yaw in InitialVelocity.").add()).appendInherited(new KeyedCodec<Range>("TotalParticles", ProtocolCodecs.RANGE), (particleSpawner, s) -> {
        particleSpawner.totalParticles = s;
    }, particleSpawner -> particleSpawner.totalParticles, (particleSpawner, parent) -> {
        particleSpawner.totalParticles = parent.totalParticles;
    }).add()).appendInherited(new KeyedCodec<Float>("LifeSpan", Codec.FLOAT), (particleSpawner, f) -> {
        particleSpawner.lifeSpan = f.floatValue();
    }, particleSpawner -> Float.valueOf(particleSpawner.lifeSpan), (particleSpawner, parent) -> {
        particleSpawner.lifeSpan = parent.lifeSpan;
    }).add()).appendInherited(new KeyedCodec<Integer>("MaxConcurrentParticles", Codec.INTEGER), (particleSpawner, s) -> {
        particleSpawner.maxConcurrentParticles = s;
    }, particleSpawner -> particleSpawner.maxConcurrentParticles, (particleSpawner, parent) -> {
        particleSpawner.maxConcurrentParticles = parent.maxConcurrentParticles;
    }).add()).appendInherited(new KeyedCodec<Rangef>("ParticleLifeSpan", ProtocolCodecs.RANGEF), (particleSpawner, s) -> {
        particleSpawner.particleLifeSpan = s;
    }, particleSpawner -> particleSpawner.particleLifeSpan, (particleSpawner, parent) -> {
        particleSpawner.particleLifeSpan = parent.particleLifeSpan;
    }).add()).appendInherited(new KeyedCodec<Rangef>("SpawnRate", ProtocolCodecs.RANGEF), (particleSpawner, s) -> {
        particleSpawner.spawnRate = s;
    }, particleSpawner -> particleSpawner.spawnRate, (particleSpawner, parent) -> {
        particleSpawner.spawnRate = parent.spawnRate;
    }).add()).appendInherited(new KeyedCodec<Boolean>("SpawnBurst", Codec.BOOLEAN), (particleSpawner, b) -> {
        particleSpawner.spawnBurst = b;
    }, particleSpawner -> particleSpawner.spawnBurst, (particleSpawner, parent) -> {
        particleSpawner.spawnRate = parent.spawnRate;
    }).add()).append(new KeyedCodec<Rangef>("WaveDelay", ProtocolCodecs.RANGEF), (particleSpawner, b) -> {
        particleSpawner.waveDelay = b;
    }, particleSpawner -> particleSpawner.waveDelay).add()).appendInherited(new KeyedCodec<InitialVelocity>("InitialVelocity", ProtocolCodecs.INITIAL_VELOCITY), (particleSpawner, s) -> {
        particleSpawner.initialVelocity = s;
    }, particleSpawner -> particleSpawner.initialVelocity, (particleSpawner, parent) -> {
        particleSpawner.initialVelocity = parent.initialVelocity;
    }).add()).appendInherited(new KeyedCodec<ParticleRotationInfluence>("ParticleRotationInfluence", new EnumCodec<ParticleRotationInfluence>(ParticleRotationInfluence.class)), (particleSpawner, s) -> {
        particleSpawner.particleRotationInfluence = s;
    }, particleSpawner -> particleSpawner.particleRotationInfluence, (particleSpawner, parent) -> {
        particleSpawner.particleRotationInfluence = parent.particleRotationInfluence;
    }).addValidator(Validators.nonNull()).metadata(new UIEditorSectionStart("Motion")).add()).appendInherited(new KeyedCodec<Boolean>("ParticleRotateWithSpawner", Codec.BOOLEAN), (particleSpawner, s) -> {
        particleSpawner.particleRotateWithSpawner = s;
    }, particleSpawner -> particleSpawner.particleRotateWithSpawner, (particleSpawner, parent) -> {
        particleSpawner.particleRotateWithSpawner = parent.particleRotateWithSpawner;
    }).add()).appendInherited(new KeyedCodec<Float>("TrailSpawnerPositionMultiplier", Codec.FLOAT), (particleSpawner, f) -> {
        particleSpawner.trailSpawnerPositionMultiplier = f.floatValue();
    }, particleSpawner -> Float.valueOf(particleSpawner.trailSpawnerPositionMultiplier), (particleSpawner, parent) -> {
        particleSpawner.trailSpawnerPositionMultiplier = parent.trailSpawnerPositionMultiplier;
    }).addValidator(Validators.range(Float.valueOf(0.0f), Float.valueOf(1.0f))).add()).appendInherited(new KeyedCodec<Float>("TrailSpawnerRotationMultiplier", Codec.FLOAT), (particleSpawner, f) -> {
        particleSpawner.trailSpawnerRotationMultiplier = f.floatValue();
    }, particleSpawner -> Float.valueOf(particleSpawner.trailSpawnerRotationMultiplier), (particleSpawner, parent) -> {
        particleSpawner.trailSpawnerRotationMultiplier = parent.trailSpawnerRotationMultiplier;
    }).addValidator(Validators.range(Float.valueOf(0.0f), Float.valueOf(1.0f))).add()).append(new KeyedCodec<Float>("VelocityStretchMultiplier", Codec.FLOAT), (particleSpawner, f) -> {
        particleSpawner.velocityStretchMultiplier = f.floatValue();
    }, particleSpawner -> Float.valueOf(particleSpawner.velocityStretchMultiplier)).add()).appendInherited(new KeyedCodec<T[]>("Attractors", new ArrayCodec<ParticleAttractor>(ParticleAttractor.CODEC, ParticleAttractor[]::new)), (particleSpawner, o) -> {
        particleSpawner.attractors = o;
    }, particleSpawner -> particleSpawner.attractors, (particleSpawner, parent) -> {
        particleSpawner.attractors = parent.attractors;
    }).metadata(new UIEditorSectionStart("Attractors")).metadata(UIDefaultCollapsedState.UNCOLLAPSED).add()).appendInherited(new KeyedCodec<FXRenderMode>("RenderMode", new EnumCodec<FXRenderMode>(FXRenderMode.class)), (particleSpawner, s) -> {
        particleSpawner.renderMode = s;
    }, particleSpawner -> particleSpawner.renderMode, (particleSpawner, parent) -> {
        particleSpawner.renderMode = parent.renderMode;
    }).addValidator(Validators.nonNull()).metadata(new UIEditorSectionStart("Material")).add()).appendInherited(new KeyedCodec<Float>("LightInfluence", Codec.FLOAT), (particleSpawner, f) -> {
        particleSpawner.lightInfluence = f.floatValue();
    }, particleSpawner -> Float.valueOf(particleSpawner.lightInfluence), (particleSpawner, parent) -> {
        particleSpawner.lightInfluence = parent.lightInfluence;
    }).add()).appendInherited(new KeyedCodec<IntersectionHighlight>("IntersectionHighlight", ProtocolCodecs.INTERSECTION_HIGHLIGHT), (particleSpawner, s) -> {
        particleSpawner.intersectionHighlight = s;
    }, particleSpawner -> particleSpawner.intersectionHighlight, (particleSpawner, parent) -> {
        particleSpawner.intersectionHighlight = parent.intersectionHighlight;
    }).add()).appendInherited(new KeyedCodec<Boolean>("LinearFiltering", Codec.BOOLEAN), (particleSpawner, s) -> {
        particleSpawner.linearFiltering = s;
    }, particleSpawner -> particleSpawner.linearFiltering, (particleSpawner, parent) -> {
        particleSpawner.linearFiltering = parent.linearFiltering;
    }).add()).appendInherited(new KeyedCodec<UVMotion>("UVMotion", ProtocolCodecs.UV_MOTION), (particleSpawner, s) -> {
        particleSpawner.uvMotion = s;
    }, particleSpawner -> particleSpawner.uvMotion, (particleSpawner, parent) -> {
        particleSpawner.uvMotion = parent.uvMotion;
    }).add()).append(new KeyedCodec<Float>("CameraOffset", Codec.FLOAT), (particleSpawner, f) -> {
        particleSpawner.cameraOffset = f.floatValue();
    }, particleSpawner -> Float.valueOf(particleSpawner.cameraOffset)).addValidator(Validators.range(Float.valueOf(-10.0f), Float.valueOf(10.0f))).add()).appendInherited(new KeyedCodec<ParticleCollision>("ParticleCollision", ParticleCollision.CODEC), (particleSpawner, s) -> {
        particleSpawner.particleCollision = s;
    }, particleSpawner -> particleSpawner.particleCollision, (particleSpawner, parent) -> {
        particleSpawner.particleCollision = parent.particleCollision;
    }).metadata(new UIEditorSectionStart("Collision")).metadata(UIDefaultCollapsedState.UNCOLLAPSED).add()).appendInherited(new KeyedCodec<Boolean>("IsLowRes", Codec.BOOLEAN), (particleSpawner, s) -> {
        particleSpawner.isLowRes = s;
    }, particleSpawner -> particleSpawner.isLowRes, (particleSpawner, parent) -> {
        particleSpawner.isLowRes = parent.isLowRes;
    }).metadata(new UIEditorSectionStart("Optimization")).add()).appendInherited(new KeyedCodec<Particle>("Particle", Particle.CODEC), (particleSpawner, o) -> {
        particleSpawner.particle = o;
    }, particleSpawner -> particleSpawner.particle, (particleSpawner, parent) -> {
        particleSpawner.particle = parent.particle;
    }).addValidator(Validators.nonNull()).metadata(new UIEditorSectionStart("Particle")).metadata(UIDefaultCollapsedState.UNCOLLAPSED).add()).build();
    public static final ValidatorCache<String> VALIDATOR_CACHE = new ValidatorCache(new AssetKeyValidator(ParticleSpawner::getAssetStore));
    private static AssetStore<String, ParticleSpawner, DefaultAssetMap<String, ParticleSpawner>> ASSET_STORE;
    protected AssetExtraInfo.Data data;
    protected String id;
    protected Particle particle;
    @Nonnull
    protected FXRenderMode renderMode = FXRenderMode.BlendLinear;
    @Nonnull
    protected EmitShape shape = EmitShape.Sphere;
    protected RangeVector3f emitOffset;
    protected boolean useEmitDirection;
    protected float cameraOffset;
    @Nonnull
    protected ParticleRotationInfluence particleRotationInfluence = ParticleRotationInfluence.None;
    protected boolean particleRotateWithSpawner;
    protected boolean isLowRes;
    protected float trailSpawnerPositionMultiplier;
    protected float trailSpawnerRotationMultiplier;
    protected ParticleCollision particleCollision;
    protected float lightInfluence;
    protected boolean linearFiltering;
    protected Range totalParticles;
    protected float lifeSpan;
    protected int maxConcurrentParticles;
    protected Rangef particleLifeSpan;
    protected Rangef spawnRate;
    protected boolean spawnBurst;
    protected Rangef waveDelay;
    protected InitialVelocity initialVelocity;
    protected float velocityStretchMultiplier;
    protected UVMotion uvMotion;
    protected ParticleAttractor[] attractors;
    protected IntersectionHighlight intersectionHighlight;
    private SoftReference<com.hypixel.hytale.protocol.ParticleSpawner> cachedPacket;

    public static AssetStore<String, ParticleSpawner, DefaultAssetMap<String, ParticleSpawner>> getAssetStore() {
        if (ASSET_STORE == null) {
            ASSET_STORE = AssetRegistry.getAssetStore(ParticleSpawner.class);
        }
        return ASSET_STORE;
    }

    public static DefaultAssetMap<String, ParticleSpawner> getAssetMap() {
        return ParticleSpawner.getAssetStore().getAssetMap();
    }

    public ParticleSpawner(String id, Particle particle, FXRenderMode renderMode, EmitShape shape, RangeVector3f emitOffset, boolean useEmitDirection, float cameraOffset, ParticleRotationInfluence particleRotationInfluence, boolean particleRotateWithSpawner, boolean isLowRes, float trailSpawnerPositionMultiplier, float trailSpawnerRotationMultiplier, ParticleCollision particleCollision, float lightInfluence, boolean linearFiltering, Range totalParticles, float lifeSpan, int maxConcurrentParticles, Rangef particleLifeSpan, Rangef spawnRate, boolean spawnBurst, Rangef waveDelay, InitialVelocity initialVelocity, float velocityStretchMultiplier, UVMotion uvMotion, ParticleAttractor[] attractors, IntersectionHighlight intersectionHighlight) {
        this.id = id;
        this.particle = particle;
        this.renderMode = renderMode;
        this.shape = shape;
        this.emitOffset = emitOffset;
        this.useEmitDirection = useEmitDirection;
        this.cameraOffset = cameraOffset;
        this.particleRotationInfluence = particleRotationInfluence;
        this.particleRotateWithSpawner = particleRotateWithSpawner;
        this.isLowRes = isLowRes;
        this.trailSpawnerPositionMultiplier = trailSpawnerPositionMultiplier;
        this.trailSpawnerRotationMultiplier = trailSpawnerRotationMultiplier;
        this.particleCollision = particleCollision;
        this.lightInfluence = lightInfluence;
        this.linearFiltering = linearFiltering;
        this.totalParticles = totalParticles;
        this.lifeSpan = lifeSpan;
        this.maxConcurrentParticles = maxConcurrentParticles;
        this.particleLifeSpan = particleLifeSpan;
        this.spawnRate = spawnRate;
        this.spawnBurst = spawnBurst;
        this.waveDelay = waveDelay;
        this.initialVelocity = initialVelocity;
        this.velocityStretchMultiplier = velocityStretchMultiplier;
        this.uvMotion = uvMotion;
        this.attractors = attractors;
        this.intersectionHighlight = intersectionHighlight;
    }

    protected ParticleSpawner() {
    }

    @Override
    @Nonnull
    public com.hypixel.hytale.protocol.ParticleSpawner toPacket() {
        com.hypixel.hytale.protocol.ParticleSpawner cached;
        com.hypixel.hytale.protocol.ParticleSpawner particleSpawner = cached = this.cachedPacket == null ? null : this.cachedPacket.get();
        if (cached != null) {
            return cached;
        }
        com.hypixel.hytale.protocol.ParticleSpawner packet = new com.hypixel.hytale.protocol.ParticleSpawner();
        packet.id = this.id;
        if (this.particle != null) {
            packet.particle = this.particle.toPacket();
        }
        packet.shape = this.shape;
        packet.renderMode = this.renderMode;
        packet.emitOffset = this.emitOffset;
        packet.useEmitDirection = this.useEmitDirection;
        packet.cameraOffset = this.cameraOffset;
        packet.particleRotationInfluence = this.particleRotationInfluence;
        packet.particleRotateWithSpawner = this.particleRotateWithSpawner;
        packet.isLowRes = this.isLowRes;
        packet.trailSpawnerPositionMultiplier = this.trailSpawnerPositionMultiplier;
        packet.trailSpawnerRotationMultiplier = this.trailSpawnerRotationMultiplier;
        if (this.particleCollision != null) {
            packet.particleCollision = this.particleCollision.toPacket();
            if (this.particleCollision.getParticleRotationInfluence() == null) {
                packet.particleCollision.particleRotationInfluence = this.particleRotationInfluence;
            }
        }
        packet.lightInfluence = this.lightInfluence;
        packet.linearFiltering = this.linearFiltering;
        packet.totalParticles = this.totalParticles;
        packet.lifeSpan = this.lifeSpan;
        packet.maxConcurrentParticles = this.maxConcurrentParticles;
        if (this.particleLifeSpan != null) {
            packet.particleLifeSpan = this.particleLifeSpan;
        }
        if (this.spawnRate != null) {
            packet.spawnRate = this.spawnRate;
        }
        packet.spawnBurst = this.spawnBurst;
        if (this.waveDelay != null) {
            packet.waveDelay = this.waveDelay;
        }
        packet.initialVelocity = this.initialVelocity;
        packet.velocityStretchMultiplier = this.velocityStretchMultiplier;
        packet.uvMotion = this.uvMotion;
        if (this.attractors != null && this.attractors.length > 0) {
            packet.attractors = ArrayUtil.copyAndMutate(this.attractors, ParticleAttractor::toPacket, com.hypixel.hytale.protocol.ParticleAttractor[]::new);
        }
        packet.intersectionHighlight = this.intersectionHighlight;
        this.cachedPacket = new SoftReference<com.hypixel.hytale.protocol.ParticleSpawner>(packet);
        return packet;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public FXRenderMode getRenderMode() {
        return this.renderMode;
    }

    public EmitShape getShape() {
        return this.shape;
    }

    public RangeVector3f getEmitOffset() {
        return this.emitOffset;
    }

    public boolean getUseEmitDirection() {
        return this.useEmitDirection;
    }

    public float getCameraOffset() {
        return this.cameraOffset;
    }

    public ParticleRotationInfluence getParticleRotationInfluence() {
        return this.particleRotationInfluence;
    }

    public boolean isParticleRotateWithSpawner() {
        return this.particleRotateWithSpawner;
    }

    public boolean isLowRes() {
        return this.isLowRes;
    }

    public float getTrailSpawnerPositionMultiplier() {
        return this.trailSpawnerPositionMultiplier;
    }

    public float getTrailSpawnerRotationMultiplier() {
        return this.trailSpawnerRotationMultiplier;
    }

    public ParticleCollision getParticleCollision() {
        return this.particleCollision;
    }

    public float getLightInfluence() {
        return this.lightInfluence;
    }

    public boolean isLinearFiltering() {
        return this.linearFiltering;
    }

    public Range getTotalParticles() {
        return this.totalParticles;
    }

    public float getLifeSpan() {
        return this.lifeSpan;
    }

    public int getMaxConcurrentParticles() {
        return this.maxConcurrentParticles;
    }

    public Rangef getParticleLifeSpan() {
        return this.particleLifeSpan;
    }

    public Rangef getSpawnRate() {
        return this.spawnRate;
    }

    public boolean isSpawnBurst() {
        return this.spawnBurst;
    }

    public Rangef getWaveDelay() {
        return this.waveDelay;
    }

    public InitialVelocity getInitialVelocity() {
        return this.initialVelocity;
    }

    public float getVelocityStretchMultiplier() {
        return this.velocityStretchMultiplier;
    }

    public UVMotion getUVMotion() {
        return this.uvMotion;
    }

    public ParticleAttractor[] getAttractors() {
        return this.attractors;
    }

    public IntersectionHighlight getIntersectionHighlight() {
        return this.intersectionHighlight;
    }

    @Nonnull
    public String toString() {
        return "ParticleSpawner{id='" + this.id + "', particle='" + String.valueOf(this.particle) + ", renderMode=" + String.valueOf((Object)this.renderMode) + ", shape=" + String.valueOf((Object)this.shape) + ", emitOffset=" + String.valueOf(this.emitOffset) + ", useEmitDirection=" + this.useEmitDirection + ", cameraOffset=" + this.cameraOffset + ", particleRotationInfluence=" + String.valueOf((Object)this.particleRotationInfluence) + ", particleRotateWithSpawner=" + this.particleRotateWithSpawner + ", isLowRes=" + this.isLowRes + ", trailSpawnerPositionMultiplier=" + this.trailSpawnerPositionMultiplier + ", trailSpawnerRotationMultiplier=" + this.trailSpawnerRotationMultiplier + ", particleCollision=" + String.valueOf(this.particleCollision) + ", lightInfluence=" + this.lightInfluence + ", linearFiltering=" + this.linearFiltering + ", totalParticles=" + String.valueOf(this.totalParticles) + ", lifeSpan=" + this.lifeSpan + ", maxConcurrentParticles=" + this.maxConcurrentParticles + ", particleLifeSpan=" + String.valueOf(this.particleLifeSpan) + ", spawnRate=" + String.valueOf(this.spawnRate) + ", spawnBurst=" + this.spawnBurst + ", waveDelay=" + String.valueOf(this.waveDelay) + ", initialVelocity=" + String.valueOf(this.initialVelocity) + ", velocityStretchMultiplier=" + this.velocityStretchMultiplier + ", uvMotion=" + String.valueOf(this.uvMotion) + ", attractors=" + Arrays.toString(this.attractors) + ", intersectionHighlight" + String.valueOf(this.intersectionHighlight) + "}";
    }
}

