/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.asset.type.tagpattern;

import com.hypixel.hytale.assetstore.map.IndexedLookupTableAssetMap;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.UpdateType;
import com.hypixel.hytale.protocol.packets.assets.UpdateTagPatterns;
import com.hypixel.hytale.server.core.asset.packet.SimpleAssetPacketGenerator;
import com.hypixel.hytale.server.core.asset.type.tagpattern.config.TagPattern;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class TagPatternPacketGenerator
extends SimpleAssetPacketGenerator<String, TagPattern, IndexedLookupTableAssetMap<String, TagPattern>> {
    @Override
    @Nonnull
    public Packet generateInitPacket(@Nonnull IndexedLookupTableAssetMap<String, TagPattern> assetMap, @Nonnull Map<String, TagPattern> assets) {
        UpdateTagPatterns packet = new UpdateTagPatterns();
        packet.type = UpdateType.Init;
        packet.patterns = new Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.TagPattern>(assets.size());
        for (Map.Entry<String, TagPattern> entry : assets.entrySet()) {
            String key = entry.getKey();
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.patterns.put(index, (com.hypixel.hytale.protocol.TagPattern)entry.getValue().toPacket());
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateUpdatePacket(@Nonnull IndexedLookupTableAssetMap<String, TagPattern> assetMap, @Nonnull Map<String, TagPattern> loadedAssets) {
        UpdateTagPatterns packet = new UpdateTagPatterns();
        packet.type = UpdateType.AddOrUpdate;
        packet.patterns = new Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.TagPattern>(loadedAssets.size());
        for (Map.Entry<String, TagPattern> entry : loadedAssets.entrySet()) {
            String key = entry.getKey();
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.patterns.put(index, (com.hypixel.hytale.protocol.TagPattern)entry.getValue().toPacket());
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateRemovePacket(@Nonnull IndexedLookupTableAssetMap<String, TagPattern> assetMap, @Nonnull Set<String> removed) {
        UpdateTagPatterns packet = new UpdateTagPatterns();
        packet.type = UpdateType.Remove;
        packet.patterns = new Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.TagPattern>(removed.size());
        for (String key : removed) {
            int index = assetMap.getIndex(key);
            if (index == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Unknown key! " + key);
            }
            packet.patterns.put(index, null);
        }
        packet.maxId = assetMap.getNextIndex();
        return packet;
    }
}

