/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.command.commands.debug.server;

import com.hypixel.hytale.common.util.FormatUtil;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ServerStatsCpuCommand
extends CommandBase {
    @Nonnull
    private static final Message MESSAGE_COMMANDS_SERVER_STATS_CPU_FULL_USAGE_INFO = Message.translation("server.commands.server.stats.cpu.fullUsageInfo");
    @Nonnull
    private static final Message MESSAGE_COMMANDS_SERVER_STATS_FULL_INFO_UNAVAILABLE = Message.translation("server.commands.server.stats.fullInfoUnavailable");
    @Nonnull
    private static final Message MESSAGE_COMMANDS_SERVER_STATS_CPU_USAGE_INFO = Message.translation("server.commands.server.stats.cpu.usageInfo");

    public ServerStatsCpuCommand() {
        super("cpu", "server.commands.server.stats.cpu.desc");
    }

    @Override
    protected void executeSync(@Nonnull CommandContext context) {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOSBean = (OperatingSystemMXBean)operatingSystemMXBean;
            context.sendMessage(MESSAGE_COMMANDS_SERVER_STATS_CPU_FULL_USAGE_INFO.param("systemLoad", sunOSBean.getSystemCpuLoad()).param("processLoad", sunOSBean.getProcessCpuLoad()));
        } else {
            context.sendMessage(MESSAGE_COMMANDS_SERVER_STATS_FULL_INFO_UNAVAILABLE);
        }
        context.sendMessage(MESSAGE_COMMANDS_SERVER_STATS_CPU_USAGE_INFO.param("loadAverage", operatingSystemMXBean.getSystemLoadAverage()).param("processUptime", FormatUtil.timeUnitToString(runtimeMXBean.getUptime(), TimeUnit.MILLISECONDS)));
    }
}

