/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.command.commands.player.effect;

import com.hypixel.hytale.codec.validation.Validators;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.asset.type.entityeffect.config.EntityEffect;
import com.hypixel.hytale.server.core.asset.type.entityeffect.config.OverlapBehavior;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.DefaultArg;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.hypixel.hytale.server.core.entity.effect.EffectControllerComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.permissions.HytalePermissions;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;

public class PlayerEffectApplyCommand
extends AbstractPlayerCommand {
    private static final float DEFAULT_DURATION = 100.0f;
    private static final Message MESSAGE_EFFECT_APPLIED_SELF = Message.translation("server.commands.player.effect.apply.success.self");
    @Nonnull
    private final RequiredArg<EntityEffect> effectArg = this.withRequiredArg("effect", "server.commands.player.effect.apply.effect.desc", ArgTypes.EFFECT_ASSET);
    @Nonnull
    private final DefaultArg<Float> durationArg = (DefaultArg)this.withDefaultArg("duration", "server.commands.player.effect.apply.duration.desc", ArgTypes.FLOAT, Float.valueOf(100.0f), "server.commands.entity.effect.duration").addValidator(Validators.greaterThan(Float.valueOf(0.0f)));

    public PlayerEffectApplyCommand() {
        super("apply", "server.commands.player.effect.apply.desc");
        this.requirePermission(HytalePermissions.fromCommand("player.effect.apply.self"));
        this.addUsageVariant(new PlayerEffectApplyOtherCommand());
    }

    @Override
    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        EffectControllerComponent effectControllerComponent = store.getComponent(ref, EffectControllerComponent.getComponentType());
        assert (effectControllerComponent != null);
        EntityEffect effect = (EntityEffect)this.effectArg.get(context);
        Float duration = (Float)this.durationArg.get(context);
        effectControllerComponent.addEffect(ref, effect, duration.floatValue(), OverlapBehavior.OVERWRITE, store);
        context.sendMessage(MESSAGE_EFFECT_APPLIED_SELF.param("effect", effect.getId()).param("duration", duration.floatValue()));
    }

    private static class PlayerEffectApplyOtherCommand
    extends CommandBase {
        private static final Message MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD = Message.translation("server.commands.errors.playerNotInWorld");
        private static final Message MESSAGE_EFFECT_APPLIED_OTHER = Message.translation("server.commands.player.effect.apply.success.other");
        @Nonnull
        private final RequiredArg<PlayerRef> playerArg = this.withRequiredArg("player", "server.commands.argtype.player.desc", ArgTypes.PLAYER_REF);
        @Nonnull
        private final RequiredArg<EntityEffect> effectArg = this.withRequiredArg("effect", "server.commands.player.effect.apply.effect.desc", ArgTypes.EFFECT_ASSET);
        @Nonnull
        private final DefaultArg<Float> durationArg = (DefaultArg)this.withDefaultArg("duration", "server.commands.player.effect.apply.duration.desc", ArgTypes.FLOAT, Float.valueOf(100.0f), "server.commands.entity.effect.duration").addValidator(Validators.greaterThan(Float.valueOf(0.0f)));

        PlayerEffectApplyOtherCommand() {
            super("server.commands.player.effect.apply.other.desc");
            this.requirePermission(HytalePermissions.fromCommand("player.effect.apply.other"));
        }

        @Override
        protected void executeSync(@Nonnull CommandContext context) {
            PlayerRef targetPlayerRef = (PlayerRef)this.playerArg.get(context);
            Ref<EntityStore> ref = targetPlayerRef.getReference();
            if (ref == null || !ref.isValid()) {
                context.sendMessage(MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
                return;
            }
            Store<EntityStore> store = ref.getStore();
            World world = store.getExternalData().getWorld();
            world.execute(() -> {
                Player playerComponent = store.getComponent(ref, Player.getComponentType());
                if (playerComponent == null) {
                    context.sendMessage(MESSAGE_COMMANDS_ERRORS_PLAYER_NOT_IN_WORLD);
                    return;
                }
                PlayerRef playerRefComponent = store.getComponent(ref, PlayerRef.getComponentType());
                assert (playerRefComponent != null);
                EffectControllerComponent effectControllerComponent = store.getComponent(ref, EffectControllerComponent.getComponentType());
                assert (effectControllerComponent != null);
                EntityEffect effect = (EntityEffect)this.effectArg.get(context);
                Float duration = (Float)this.durationArg.get(context);
                effectControllerComponent.addEffect(ref, effect, duration.floatValue(), OverlapBehavior.OVERWRITE, store);
                context.sendMessage(MESSAGE_EFFECT_APPLIED_OTHER.param("username", playerRefComponent.getUsername()).param("effect", effect.getId()).param("duration", duration.floatValue()));
            });
        }
    }
}

