/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.command.commands.utility.git;

import com.hypixel.hytale.common.util.PathUtil;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractAsyncCommand;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractCommandCollection;
import com.hypixel.hytale.server.core.util.AssetUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class UpdateAssetsCommand
extends AbstractCommandCollection {
    public UpdateAssetsCommand() {
        super("assets", "server.commands.update.assets.desc");
        this.addSubCommand(new UpdateAssetsStatusCommand());
        this.addSubCommand(new UpdateAssetsResetCommand());
        this.addSubCommand(new UpdateAssetsPullCommand());
    }

    private static class UpdateAssetsStatusCommand
    extends UpdateAssetsGitCommand {
        public UpdateAssetsStatusCommand() {
            super("status", "server.commands.update.assets.status.desc");
        }

        @Override
        @Nonnull
        protected String[] getCommand(@Nonnull Path gitPath) {
            return new String[]{"git", "status"};
        }
    }

    private static class UpdateAssetsResetCommand
    extends UpdateAssetsGitCommand {
        public UpdateAssetsResetCommand() {
            super("reset", "server.commands.update.assets.reset.desc");
        }

        @Override
        @Nonnull
        protected String[] getCommand(@Nonnull Path gitPath) {
            return new String[]{"git", "reset", "--hard", "head"};
        }
    }

    private static class UpdateAssetsPullCommand
    extends UpdateAssetsGitCommand {
        public UpdateAssetsPullCommand() {
            super("pull", "server.commands.update.assets.pull.desc");
        }

        @Override
        @Nonnull
        protected String[] getCommand(@Nonnull Path gitPath) {
            Path script = gitPath.resolve("../../updateAssets.sh");
            if (Files.exists(script, new LinkOption[0])) {
                Path relative = gitPath.relativize(script);
                return new String[]{"sh", relative.toString()};
            }
            return new String[]{"git", "pull"};
        }
    }

    private static abstract class UpdateAssetsGitCommand
    extends AbstractAsyncCommand {
        protected UpdateAssetsGitCommand(@Nonnull String name, @Nonnull String description) {
            super(name, description);
        }

        @Nonnull
        protected abstract String[] getCommand(@Nonnull Path var1);

        @Override
        @Nonnull
        protected CompletableFuture<Void> executeAsync(@Nonnull CommandContext context) {
            return CompletableFuture.runAsync(() -> {
                Path assetPath = AssetUtil.getHytaleAssetsPath();
                Path gitPath = null;
                if (Files.exists(assetPath.resolve(".git"), new LinkOption[0])) {
                    gitPath = assetPath;
                } else {
                    Path parent = PathUtil.getParent(assetPath.toAbsolutePath());
                    if (Files.exists(parent.resolve(".git"), new LinkOption[0])) {
                        gitPath = parent;
                    }
                }
                if (gitPath == null) {
                    context.sendMessage(Message.translation("server.general.pathNotGitRepo").param("path", assetPath.toString()));
                    return;
                }
                CharSequence[] processCommand = this.getCommand(gitPath);
                String commandDisplay = String.join((CharSequence)" ", processCommand);
                try {
                    context.sendMessage(Message.translation("server.commands.update.running").param("cmd", commandDisplay));
                    Process process = new ProcessBuilder((String[])processCommand).directory(gitPath.toFile()).start();
                    try {
                        String line;
                        process.waitFor();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                        while ((line = reader.readLine()) != null) {
                            context.sendMessage(Message.translation("server.commands.update.runningStdOut").param("cmd", commandDisplay).param("line", line));
                        }
                        reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                        while ((line = reader.readLine()) != null) {
                            context.sendMessage(Message.translation("server.commands.update.runningStdErr").param("cmd", commandDisplay).param("line", line));
                        }
                        context.sendMessage(Message.translation("server.commands.update.done").param("cmd", commandDisplay));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (IOException e) {
                    context.sendMessage(Message.translation("server.commands.update.failed").param("cmd", commandDisplay).param("msg", e.getMessage()));
                }
            });
        }
    }
}

