/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.modules.entity.component;

import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.protocol.ColorLight;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;

public class DynamicLight
implements Component<EntityStore> {
    private ColorLight colorLight = new ColorLight();
    private boolean isNetworkOutdated = true;

    public static ComponentType<EntityStore, DynamicLight> getComponentType() {
        return EntityModule.get().getDynamicLightComponentType();
    }

    public DynamicLight() {
    }

    public DynamicLight(ColorLight colorLight) {
        this.colorLight = colorLight;
    }

    public ColorLight getColorLight() {
        return this.colorLight;
    }

    public void setColorLight(ColorLight colorLight) {
        this.colorLight = colorLight;
        this.isNetworkOutdated = true;
    }

    public boolean consumeNetworkOutdated() {
        boolean temp = this.isNetworkOutdated;
        this.isNetworkOutdated = false;
        return temp;
    }

    @Override
    @Nonnull
    public Component<EntityStore> clone() {
        return new DynamicLight(new ColorLight(this.colorLight));
    }
}

