/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.modules.entity.player;

import com.hypixel.hytale.component.AddReason;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.RemoveReason;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.HolderSystem;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.server.core.modules.entity.player.ChunkTracker;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;

public class PlayerChunkTrackerSystems {

    public static class UpdateSystem
    extends EntityTickingSystem<EntityStore> {
        @Nonnull
        private static final ComponentType<EntityStore, ChunkTracker> CHUNK_TRACKER_COMPONENT_TYPE = ChunkTracker.getComponentType();

        @Override
        public Query<EntityStore> getQuery() {
            return CHUNK_TRACKER_COMPONENT_TYPE;
        }

        @Override
        public boolean isParallel(int archetypeChunkSize, int taskCount) {
            return false;
        }

        @Override
        public void tick(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
            Ref<EntityStore> ref = archetypeChunk.getReferenceTo(index);
            ChunkTracker chunkTrackerComponent = archetypeChunk.getComponent(index, CHUNK_TRACKER_COMPONENT_TYPE);
            assert (chunkTrackerComponent != null);
            chunkTrackerComponent.tick(ref, dt, commandBuffer);
        }
    }

    public static class AddSystem
    extends HolderSystem<EntityStore> {
        @Nonnull
        private static final ComponentType<EntityStore, ChunkTracker> CHUNK_TRACKER_COMPONENT_TYPE = ChunkTracker.getComponentType();

        @Override
        public Query<EntityStore> getQuery() {
            return CHUNK_TRACKER_COMPONENT_TYPE;
        }

        @Override
        public void onEntityAdd(@Nonnull Holder<EntityStore> holder, @Nonnull AddReason reason, @Nonnull Store<EntityStore> store) {
            ChunkTracker chunkTrackerComponent = holder.getComponent(CHUNK_TRACKER_COMPONENT_TYPE);
            assert (chunkTrackerComponent != null);
            chunkTrackerComponent.setReadyForChunks(true);
        }

        @Override
        public void onEntityRemoved(@Nonnull Holder<EntityStore> holder, @Nonnull RemoveReason reason, @Nonnull Store<EntityStore> store) {
        }
    }
}

