/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.modules.entity.system;

import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Resource;
import com.hypixel.hytale.component.ResourceType;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.SystemGroup;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.RefChangeSystem;
import com.hypixel.hytale.component.system.tick.EntityTickingSystem;
import com.hypixel.hytale.protocol.ComponentUpdate;
import com.hypixel.hytale.protocol.ComponentUpdateType;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.modules.entity.EntityModule;
import com.hypixel.hytale.server.core.modules.entity.component.RespondToHit;
import com.hypixel.hytale.server.core.modules.entity.player.PlayerSettings;
import com.hypixel.hytale.server.core.modules.entity.tracker.EntityTrackerSystems;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class RespondToHitSystems {

    public static class OnPlayerSettingsChange
    extends RefChangeSystem<EntityStore, PlayerSettings> {
        @Override
        @NonNullDecl
        public ComponentType<EntityStore, PlayerSettings> componentType() {
            return PlayerSettings.getComponentType();
        }

        @Override
        public void onComponentAdded(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerSettings component, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
            Player player = commandBuffer.getComponent(ref, Player.getComponentType());
            if (player.getGameMode() != GameMode.Creative) {
                return;
            }
            if (component.creativeSettings().respondToHit()) {
                commandBuffer.ensureComponent(ref, RespondToHit.getComponentType());
            } else {
                commandBuffer.tryRemoveComponent(ref, RespondToHit.getComponentType());
            }
        }

        @Override
        public void onComponentSet(@NonNullDecl Ref<EntityStore> ref, @NullableDecl PlayerSettings oldComponent, @NonNullDecl PlayerSettings newComponent, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
            Player player = commandBuffer.getComponent(ref, Player.getComponentType());
            if (player.getGameMode() != GameMode.Creative) {
                return;
            }
            if (newComponent.creativeSettings().respondToHit()) {
                commandBuffer.ensureComponent(ref, RespondToHit.getComponentType());
            } else {
                commandBuffer.tryRemoveComponent(ref, RespondToHit.getComponentType());
            }
        }

        @Override
        public void onComponentRemoved(@NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerSettings component, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer) {
        }

        @Override
        @NullableDecl
        public Query<EntityStore> getQuery() {
            return Player.getComponentType();
        }
    }

    public static class EntityTrackerAddAndRemove
    extends RefChangeSystem<EntityStore, RespondToHit> {
        private final ComponentType<EntityStore, RespondToHit> respondToHitComponentType = RespondToHit.getComponentType();
        private final ComponentType<EntityStore, EntityTrackerSystems.Visible> visibleComponentType;
        @Nonnull
        private final Query<EntityStore> query;

        public EntityTrackerAddAndRemove(ComponentType<EntityStore, EntityTrackerSystems.Visible> visibleComponentType) {
            this.visibleComponentType = visibleComponentType;
            this.query = Query.and(visibleComponentType, this.respondToHitComponentType);
        }

        @Override
        @Nonnull
        public Query<EntityStore> getQuery() {
            return this.query;
        }

        @Override
        @Nonnull
        public ComponentType<EntityStore, RespondToHit> componentType() {
            return this.respondToHitComponentType;
        }

        @Override
        public void onComponentAdded(@Nonnull Ref<EntityStore> ref, @Nonnull RespondToHit component, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
            commandBuffer.getResource(QueueResource.getResourceType()).queue.add(ref);
        }

        @Override
        public void onComponentSet(@Nonnull Ref<EntityStore> ref, RespondToHit oldComponent, @Nonnull RespondToHit newComponent, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
        }

        @Override
        public void onComponentRemoved(@Nonnull Ref<EntityStore> ref, @Nonnull RespondToHit component, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
            for (EntityTrackerSystems.EntityViewer viewer : store.getComponent(ref, this.visibleComponentType).visibleTo.values()) {
                viewer.queueRemove(ref, ComponentUpdateType.RespondToHit);
            }
        }
    }

    public static class EntityTrackerUpdate
    extends EntityTickingSystem<EntityStore> {
        private final ComponentType<EntityStore, EntityTrackerSystems.Visible> componentType;
        @Nonnull
        private final Query<EntityStore> query;

        public EntityTrackerUpdate(ComponentType<EntityStore, EntityTrackerSystems.Visible> componentType) {
            this.componentType = componentType;
            this.query = Query.and(componentType, RespondToHit.getComponentType());
        }

        @Override
        @Nullable
        public SystemGroup<EntityStore> getGroup() {
            return EntityTrackerSystems.QUEUE_UPDATE_GROUP;
        }

        @Override
        @Nonnull
        public Query<EntityStore> getQuery() {
            return this.query;
        }

        @Override
        public boolean isParallel(int archetypeChunkSize, int taskCount) {
            return EntityTickingSystem.maybeUseParallel(archetypeChunkSize, taskCount);
        }

        @Override
        public void tick(float dt, int systemIndex, @Nonnull Store<EntityStore> store) {
            super.tick(dt, systemIndex, store);
            store.getResource(QueueResource.getResourceType()).queue.clear();
        }

        @Override
        public void tick(float dt, int index, @Nonnull ArchetypeChunk<EntityStore> archetypeChunk, @Nonnull Store<EntityStore> store, @Nonnull CommandBuffer<EntityStore> commandBuffer) {
            EntityTrackerSystems.Visible visible = archetypeChunk.getComponent(index, this.componentType);
            Ref<EntityStore> ref = archetypeChunk.getReferenceTo(index);
            if (commandBuffer.getResource(QueueResource.getResourceType()).queue.remove(ref)) {
                EntityTrackerUpdate.queueUpdatesFor(ref, visible.visibleTo);
            } else if (!visible.newlyVisibleTo.isEmpty()) {
                EntityTrackerUpdate.queueUpdatesFor(ref, visible.newlyVisibleTo);
            }
        }

        private static void queueUpdatesFor(Ref<EntityStore> ref, @Nonnull Map<Ref<EntityStore>, EntityTrackerSystems.EntityViewer> visibleTo) {
            ComponentUpdate update = new ComponentUpdate();
            update.type = ComponentUpdateType.RespondToHit;
            for (EntityTrackerSystems.EntityViewer viewer : visibleTo.values()) {
                viewer.queueUpdate(ref, update);
            }
        }
    }

    public static class QueueResource
    implements Resource<EntityStore> {
        private final Set<Ref<EntityStore>> queue = ConcurrentHashMap.newKeySet();

        public static ResourceType<EntityStore, QueueResource> getResourceType() {
            return EntityModule.get().getRespondToHitQueueResourceType();
        }

        @Override
        @Nonnull
        public Resource<EntityStore> clone() {
            return new QueueResource();
        }
    }
}

