/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.modules.entitystats;

import com.hypixel.hytale.assetstore.map.IndexedLookupTableAssetMap;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.codec.codecs.map.MapCodec;
import com.hypixel.hytale.common.util.ArrayUtil;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.protocol.ChangeStatBehaviour;
import com.hypixel.hytale.protocol.EntityStatOp;
import com.hypixel.hytale.protocol.EntityStatResetBehavior;
import com.hypixel.hytale.protocol.EntityStatUpdate;
import com.hypixel.hytale.protocol.ValueType;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatValue;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatsModule;
import com.hypixel.hytale.server.core.modules.entitystats.asset.EntityStatType;
import com.hypixel.hytale.server.core.modules.entitystats.modifier.Modifier;
import com.hypixel.hytale.server.core.modules.entitystats.modifier.StaticModifier;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityStatMap
implements Component<EntityStore> {
    public static final int VERSION = 5;
    public static final BuilderCodec<EntityStatMap> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(EntityStatMap.class, EntityStatMap::new).legacyVersioned()).codecVersion(5)).addField(new KeyedCodec("Stats", new MapCodec<EntityStatValue, HashMap>(EntityStatValue.CODEC, HashMap::new, false)), (statMap, value) -> {
        statMap.unknown = value;
    }, statMap -> {
        HashMap<String, EntityStatValue> outMap = new HashMap<String, EntityStatValue>();
        if (statMap.unknown != null) {
            outMap.putAll(statMap.unknown);
        }
        for (EntityStatValue value : statMap.values) {
            if (value == null) continue;
            outMap.putIfAbsent(value.getId(), value);
        }
        return outMap;
    })).afterDecode(map -> {
        map.values = EntityStatValue.EMPTY_ARRAY;
        map.update();
    })).build();
    private Map<String, EntityStatValue> unknown;
    @Nonnull
    private EntityStatValue[] values = EntityStatValue.EMPTY_ARRAY;
    float[] tempRegenerationValues = ArrayUtil.EMPTY_FLOAT_ARRAY;
    public final Int2ObjectMap<List<EntityStatUpdate>> selfUpdates = new Int2ObjectOpenHashMap<List<EntityStatUpdate>>();
    public final Int2ObjectMap<FloatList> selfStatValues = new Int2ObjectOpenHashMap<FloatList>();
    public final Int2ObjectMap<List<EntityStatUpdate>> otherUpdates = new Int2ObjectOpenHashMap<List<EntityStatUpdate>>();
    protected boolean isSelfNetworkOutdated;
    protected boolean isNetworkOutdated;

    public static ComponentType<EntityStore, EntityStatMap> getComponentType() {
        return EntityStatsModule.get().getEntityStatMapComponentType();
    }

    public int size() {
        return this.values.length;
    }

    @Nullable
    public EntityStatValue get(int index) {
        if (index >= this.values.length) {
            return null;
        }
        return this.values[index];
    }

    @Deprecated
    @Nullable
    public EntityStatValue get(String entityStat) {
        return this.get(EntityStatType.getAssetMap().getIndex(entityStat));
    }

    public void update() {
        IndexedLookupTableAssetMap<String, EntityStatType> assetMap = EntityStatType.getAssetMap();
        for (int index = 0; index < this.values.length; ++index) {
            EntityStatType asset = assetMap.getAsset(index);
            EntityStatValue value = this.values[index];
            if (value == null) continue;
            if (asset.isUnknown()) {
                if (this.unknown == null) {
                    this.unknown = new Object2ObjectOpenHashMap<String, EntityStatValue>();
                }
                this.unknown.put(asset.getId(), value);
                this.values[index] = new EntityStatValue(index, asset);
                continue;
            }
            if (!value.synchronizeAsset(index, asset)) continue;
            this.addInitChange(index, value);
        }
        int oldLength = this.values.length;
        int assetCount = assetMap.getNextIndex();
        if (oldLength <= assetCount) {
            this.values = Arrays.copyOf(this.values, assetCount);
            for (int index = oldLength; index < assetCount; ++index) {
                EntityStatValue value;
                EntityStatType asset = assetMap.getAsset(index);
                if (asset.isUnknown()) {
                    value = this.values[index] = new EntityStatValue(index, asset);
                    this.addInitChange(index, value);
                    continue;
                }
                EntityStatValue entityStatValue = value = this.unknown == null ? null : this.unknown.remove(asset.getId());
                if (value != null) {
                    value.synchronizeAsset(index, asset);
                    this.values[index] = value;
                    this.addInitChange(index, value);
                    continue;
                }
                value = this.values[index] = new EntityStatValue(index, asset);
                this.addInitChange(index, value);
            }
        }
    }

    @Nullable
    public Modifier getModifier(int index, String key) {
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return null;
        }
        return entityStatValue.getModifiers() != null ? entityStatValue.getModifiers().get(key) : null;
    }

    @Nullable
    public Modifier putModifier(int index, String key, Modifier modifier) {
        return this.putModifier(Predictable.NONE, index, key, modifier);
    }

    @Nullable
    public Modifier putModifier(Predictable predictable, int index, String key, Modifier modifier) {
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return null;
        }
        float previousValue = entityStatValue.get();
        Modifier previous = entityStatValue.putModifier(key, modifier);
        this.addChange(predictable, index, EntityStatOp.PutModifier, previousValue, key, modifier);
        return previous;
    }

    @Nullable
    public Modifier removeModifier(int index, String key) {
        return this.removeModifier(Predictable.NONE, index, key);
    }

    @Nullable
    public Modifier removeModifier(Predictable predictable, int index, String key) {
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return null;
        }
        float previousValue = entityStatValue.get();
        Modifier previous = entityStatValue.removeModifier(key);
        if (previous != null) {
            this.addChange(predictable, index, EntityStatOp.RemoveModifier, previousValue, key, null);
        }
        return previous;
    }

    public float setStatValue(int index, float newValue) {
        return this.setStatValue(Predictable.NONE, index, newValue);
    }

    public float setStatValue(Predictable predictable, int index, float newValue) {
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return 0.0f;
        }
        float currentValue = entityStatValue.get();
        float ret = entityStatValue.set(newValue);
        if (predictable != Predictable.NONE || newValue != currentValue) {
            this.addChange(predictable, index, EntityStatOp.Set, currentValue, newValue);
        }
        return ret;
    }

    public float addStatValue(int index, float amount) {
        return this.addStatValue(Predictable.NONE, index, amount);
    }

    public float addStatValue(Predictable predictable, int index, float amount) {
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return 0.0f;
        }
        float currentValue = entityStatValue.get();
        float ret = entityStatValue.set(currentValue + amount);
        if (predictable != Predictable.NONE || ret != currentValue) {
            this.addChange(predictable, index, EntityStatOp.Add, currentValue, amount);
        }
        return ret;
    }

    public float subtractStatValue(int index, float amount) {
        return this.addStatValue(index, -amount);
    }

    public float subtractStatValue(Predictable predictable, int index, float amount) {
        return this.addStatValue(predictable, index, -amount);
    }

    public float minimizeStatValue(int index) {
        return this.minimizeStatValue(Predictable.NONE, index);
    }

    public float minimizeStatValue(Predictable predictable, int index) {
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return 0.0f;
        }
        float previousValue = entityStatValue.get();
        float ret = entityStatValue.set(entityStatValue.getMin());
        this.addChange(predictable, index, EntityStatOp.Minimize, previousValue, 0.0f);
        return ret;
    }

    public float maximizeStatValue(int index) {
        return this.maximizeStatValue(Predictable.NONE, index);
    }

    public float maximizeStatValue(Predictable predictable, int index) {
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return 0.0f;
        }
        float previousValue = entityStatValue.get();
        float ret = entityStatValue.set(entityStatValue.getMax());
        this.addChange(predictable, index, EntityStatOp.Maximize, previousValue, 0.0f);
        return ret;
    }

    public float resetStatValue(int index) {
        return this.resetStatValue(Predictable.NONE, index);
    }

    public float resetStatValue(Predictable predictable, int index) {
        EntityStatType entityStatType = EntityStatType.getAssetMap().getAsset(index);
        if (entityStatType == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatType found for index: " + index);
            return 0.0f;
        }
        EntityStatValue entityStatValue = this.get(index);
        if (entityStatValue == null) {
            HytaleLogger.getLogger().at(Level.WARNING).log("No EntityStatValue found for index: " + index);
            return 0.0f;
        }
        float previousValue = entityStatValue.get();
        float ret = switch (entityStatType.getResetBehavior()) {
            case EntityStatResetBehavior.InitialValue -> entityStatValue.set(entityStatType.getInitialValue());
            case EntityStatResetBehavior.MaxValue -> entityStatValue.set(entityStatValue.getMax());
            default -> 0.0f;
        };
        this.addChange(predictable, index, EntityStatOp.Reset, previousValue, 0.0f);
        return ret;
    }

    @Nonnull
    public Int2ObjectMap<List<EntityStatUpdate>> getSelfUpdates() {
        return this.selfUpdates;
    }

    @Nonnull
    public Int2ObjectMap<FloatList> getSelfStatValues() {
        return this.selfStatValues;
    }

    @Nonnull
    public Int2ObjectMap<EntityStatUpdate[]> consumeSelfUpdates() {
        return this.updatesToProtocol(this.selfUpdates);
    }

    public void clearUpdates() {
        this.selfUpdates.values().forEach(List::clear);
        this.selfStatValues.values().forEach(List::clear);
        this.otherUpdates.values().forEach(List::clear);
    }

    @Nonnull
    public Int2ObjectMap<EntityStatUpdate[]> consumeOtherUpdates() {
        return this.updatesToProtocol(this.otherUpdates);
    }

    @Nonnull
    private Int2ObjectOpenHashMap<EntityStatUpdate[]> updatesToProtocol(@Nonnull Int2ObjectMap<List<EntityStatUpdate>> localUpdates) {
        Int2ObjectOpenHashMap<EntityStatUpdate[]> updates = new Int2ObjectOpenHashMap<EntityStatUpdate[]>(localUpdates.size());
        ObjectIterator<Int2ObjectMap.Entry<List<EntityStatUpdate>>> iterator = Int2ObjectMaps.fastIterator(localUpdates);
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry e = (Int2ObjectMap.Entry)iterator.next();
            if (((List)e.getValue()).isEmpty()) continue;
            updates.put(e.getIntKey(), (EntityStatUpdate[])((List)e.getValue()).toArray(EntityStatUpdate[]::new));
        }
        return updates;
    }

    @Nonnull
    public Int2ObjectMap<EntityStatUpdate[]> createInitUpdate(boolean all) {
        Int2ObjectOpenHashMap<EntityStatUpdate[]> updates = new Int2ObjectOpenHashMap<EntityStatUpdate[]>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            EntityStatValue stat = this.get(i);
            if (stat == null || !EntityStatType.getAssetMap().getAsset(i).isShared() && !all) continue;
            updates.put(i, new EntityStatUpdate[]{EntityStatMap.makeInitChange(stat)});
        }
        return updates;
    }

    public boolean consumeSelfNetworkOutdated() {
        boolean temp = this.isSelfNetworkOutdated;
        this.isSelfNetworkOutdated = false;
        return temp;
    }

    public boolean consumeNetworkOutdated() {
        boolean temp = this.isNetworkOutdated;
        this.isNetworkOutdated = false;
        return temp;
    }

    private void addInitChange(int index, @Nonnull EntityStatValue value) {
        this.addChange(Predictable.NONE, index, EntityStatOp.Init, value.get(), value.get(), value.getModifiers());
    }

    private void addChange(Predictable predictable, int index, @Nonnull EntityStatOp op, float previousValue, float value) {
        this.addChange(predictable, index, op, previousValue, value, null);
    }

    private void addChange(Predictable predictable, int index, @Nonnull EntityStatOp op, float previousValue, float value, Map<String, Modifier> modifierMap) {
        boolean isPredictable;
        EntityStatType statType = EntityStatType.getAssetMap().getAsset(index);
        if (statType.isShared()) {
            isPredictable = predictable == Predictable.ALL;
            List other = this.otherUpdates.computeIfAbsent(index, v -> new ObjectArrayList());
            this.tryMergeUpdate(other, op, value, modifierMap, isPredictable);
            this.isNetworkOutdated = true;
        }
        isPredictable = predictable != Predictable.NONE;
        List self = this.selfUpdates.computeIfAbsent(index, v -> new ObjectArrayList());
        FloatList values = this.selfStatValues.computeIfAbsent(index, v -> new FloatArrayList());
        if (this.tryMergeUpdate(self, op, value, modifierMap, isPredictable)) {
            values.set(values.size() - 1, this.get(index).get());
            return;
        }
        values.add(previousValue);
        values.add(this.get(index).get());
        this.isSelfNetworkOutdated = true;
    }

    private void addChange(Predictable predictable, int index, EntityStatOp op, float previousValue, String key, @Nullable Modifier modifier) {
        boolean isPredictable;
        com.hypixel.hytale.protocol.Modifier modifierPacket;
        EntityStatType statType = EntityStatType.getAssetMap().getAsset(index);
        com.hypixel.hytale.protocol.Modifier modifier2 = modifierPacket = modifier != null ? modifier.toPacket() : null;
        if (statType.isShared()) {
            isPredictable = predictable == Predictable.ALL;
            List other = this.otherUpdates.computeIfAbsent(index, v -> new ObjectArrayList());
            other.add(new EntityStatUpdate(op, isPredictable, 0.0f, null, key, modifierPacket));
            this.isNetworkOutdated = true;
        }
        isPredictable = predictable != Predictable.NONE;
        List self = this.selfUpdates.computeIfAbsent(index, v -> new ObjectArrayList());
        self.add(new EntityStatUpdate(op, isPredictable, 0.0f, null, key, modifierPacket));
        FloatList values = this.selfStatValues.computeIfAbsent(index, v -> new FloatArrayList());
        values.add(previousValue);
        values.add(this.get(index).get());
        this.isSelfNetworkOutdated = true;
    }

    private boolean tryMergeUpdate(@Nonnull List<EntityStatUpdate> updates, @Nonnull EntityStatOp op, float value, @Nullable Map<String, Modifier> modifierMap, boolean isPredictable) {
        EntityStatUpdate last = updates.isEmpty() ? null : updates.getLast();
        switch (op) {
            case Init: {
                if (!isPredictable && last != null && !last.predictable && last.op == EntityStatOp.Init) {
                    last.value = value;
                    return true;
                }
                Object2ObjectOpenHashMap<String, com.hypixel.hytale.protocol.Modifier> modifiers = null;
                if (modifierMap != null) {
                    modifiers = new Object2ObjectOpenHashMap<String, com.hypixel.hytale.protocol.Modifier>();
                    for (Map.Entry<String, Modifier> e : modifierMap.entrySet()) {
                        modifiers.put(e.getKey(), e.getValue().toPacket());
                    }
                }
                updates.add(new EntityStatUpdate(op, isPredictable, value, modifiers, null, null));
                return false;
            }
            case Remove: {
                updates.add(new EntityStatUpdate(op, isPredictable, 0.0f, null, null, null));
                break;
            }
            case Add: {
                if (!(isPredictable || last == null || last.predictable || last.op != EntityStatOp.Init && last.op != EntityStatOp.Add && last.op != EntityStatOp.Set)) {
                    last.value += value;
                    return true;
                }
                updates.add(new EntityStatUpdate(op, isPredictable, value, null, null, null));
                return false;
            }
            case Set: 
            case Minimize: 
            case Maximize: 
            case Reset: {
                if (!isPredictable && last != null && !last.predictable && last.op != EntityStatOp.Remove) {
                    if (last.op != EntityStatOp.Init) {
                        last.op = op;
                    }
                    last.value = value;
                    return true;
                }
                updates.add(new EntityStatUpdate(op, isPredictable, value, null, null, null));
                return false;
            }
        }
        return false;
    }

    public void processStatChanges(Predictable predictable, @Nonnull Int2FloatMap entityStats, ValueType valueType, @Nonnull ChangeStatBehaviour changeStatBehaviour) {
        for (Int2FloatMap.Entry entry : entityStats.int2FloatEntrySet()) {
            int statIndex = entry.getIntKey();
            float amount = entry.getFloatValue();
            if (valueType == ValueType.Percent) {
                EntityStatValue stat = this.get(statIndex);
                if (stat == null) continue;
                amount = amount * (stat.getMax() - stat.getMin()) / 100.0f;
            }
            switch (changeStatBehaviour) {
                case Set: {
                    this.setStatValue(predictable, statIndex, amount);
                    break;
                }
                case Add: {
                    this.addStatValue(predictable, statIndex, amount);
                }
            }
        }
    }

    @Nonnull
    public String toString() {
        return "EntityStatMap{unknown=" + String.valueOf(this.unknown) + "values=" + Arrays.toString(this.values) + "}";
    }

    @Nonnull
    public EntityStatMap clone() {
        EntityStatMap map = new EntityStatMap();
        map.unknown = this.unknown;
        map.update();
        for (int i = 0; i < this.values.length; ++i) {
            map.values[i].set(this.values[i].get());
        }
        map.selfUpdates.putAll(this.selfUpdates);
        map.selfStatValues.putAll(this.selfStatValues);
        map.otherUpdates.putAll(this.otherUpdates);
        return map;
    }

    @Nonnull
    private static EntityStatUpdate makeInitChange(@Nonnull EntityStatValue value) {
        Object2ObjectOpenHashMap<String, com.hypixel.hytale.protocol.Modifier> modifiers = null;
        if (value.getModifiers() != null) {
            modifiers = new Object2ObjectOpenHashMap<String, com.hypixel.hytale.protocol.Modifier>();
            for (Map.Entry<String, Modifier> e : value.getModifiers().entrySet()) {
                modifiers.put(e.getKey(), e.getValue().toPacket());
            }
        }
        return new EntityStatUpdate(EntityStatOp.Init, false, value.get(), modifiers, null, null);
    }

    public static Int2ObjectMap<com.hypixel.hytale.protocol.Modifier[]> toPacket(@Nullable Int2ObjectMap<StaticModifier[]> modifiers) {
        if (modifiers == null) {
            return null;
        }
        Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.Modifier[]> packet = new Int2ObjectOpenHashMap<com.hypixel.hytale.protocol.Modifier[]>(modifiers.size());
        for (Int2ObjectMap.Entry entry : modifiers.int2ObjectEntrySet()) {
            com.hypixel.hytale.protocol.Modifier[] out = new com.hypixel.hytale.protocol.Modifier[((StaticModifier[])entry.getValue()).length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = ((StaticModifier[])entry.getValue())[i].toPacket();
            }
            packet.put(entry.getIntKey(), out);
        }
        return packet;
    }

    public static enum Predictable {
        NONE,
        SELF,
        ALL;

    }
}

