/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.modules.item;

import com.hypixel.hytale.assetstore.AssetUpdateQuery;
import com.hypixel.hytale.assetstore.map.DefaultAssetMap;
import com.hypixel.hytale.protocol.ItemBase;
import com.hypixel.hytale.protocol.Packet;
import com.hypixel.hytale.protocol.UpdateType;
import com.hypixel.hytale.protocol.packets.assets.UpdateItems;
import com.hypixel.hytale.server.core.asset.packet.AssetPacketGenerator;
import com.hypixel.hytale.server.core.asset.type.item.config.Item;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ItemPacketGenerator
extends AssetPacketGenerator<String, Item, DefaultAssetMap<String, Item>> {
    @Override
    @Nonnull
    public Packet generateInitPacket(DefaultAssetMap<String, Item> assetMap, @Nonnull Map<String, Item> assets) {
        UpdateItems packet = new UpdateItems();
        packet.type = UpdateType.Init;
        packet.items = new Object2ObjectOpenHashMap<String, ItemBase>();
        for (Map.Entry<String, Item> entry : assets.entrySet()) {
            packet.items.put(entry.getKey(), entry.getValue().toPacket());
        }
        packet.updateModels = true;
        packet.updateIcons = true;
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateUpdatePacket(DefaultAssetMap<String, Item> assetMap, @Nonnull Map<String, Item> loadedAssets, @Nonnull AssetUpdateQuery query) {
        UpdateItems packet = new UpdateItems();
        packet.type = UpdateType.AddOrUpdate;
        packet.items = new Object2ObjectOpenHashMap<String, ItemBase>();
        for (Map.Entry<String, Item> entry : loadedAssets.entrySet()) {
            packet.items.put(entry.getKey(), entry.getValue().toPacket());
        }
        AssetUpdateQuery.RebuildCache rebuildCache = query.getRebuildCache();
        packet.updateModels = rebuildCache.isBlockTextures() || rebuildCache.isModels();
        packet.updateIcons = rebuildCache.isItemIcons();
        return packet;
    }

    @Override
    @Nonnull
    public Packet generateRemovePacket(DefaultAssetMap<String, Item> assetMap, @Nonnull Set<String> removed, @Nonnull AssetUpdateQuery query) {
        UpdateItems packet = new UpdateItems();
        packet.type = UpdateType.Remove;
        packet.removedItems = (String[])removed.toArray(String[]::new);
        AssetUpdateQuery.RebuildCache rebuildCache = query.getRebuildCache();
        packet.updateModels = rebuildCache.isBlockTextures() || rebuildCache.isModels();
        packet.updateIcons = rebuildCache.isItemIcons();
        return packet;
    }
}

