/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.core.universe.world.chunk.section;

import com.hypixel.hytale.assetstore.map.BlockTypeAssetMap;
import com.hypixel.hytale.assetstore.map.IndexedLookupTableAssetMap;
import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.ExtraInfo;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.common.util.BitSetUtil;
import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.ComponentType;
import com.hypixel.hytale.function.predicate.ObjectPositionBlockFunction;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.protocol.CachedPacket;
import com.hypixel.hytale.protocol.packets.world.PaletteType;
import com.hypixel.hytale.protocol.packets.world.SetChunk;
import com.hypixel.hytale.server.core.asset.type.blockhitbox.BlockBoundingBoxes;
import com.hypixel.hytale.server.core.asset.type.blocktick.BlockTickStrategy;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockMigration;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.BlockType;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.Rotation;
import com.hypixel.hytale.server.core.asset.type.blocktype.config.RotationTuple;
import com.hypixel.hytale.server.core.asset.type.fluid.Fluid;
import com.hypixel.hytale.server.core.blocktype.component.BlockPhysics;
import com.hypixel.hytale.server.core.modules.LegacyModule;
import com.hypixel.hytale.server.core.universe.world.chunk.BlockChunk;
import com.hypixel.hytale.server.core.universe.world.chunk.section.ChunkLightData;
import com.hypixel.hytale.server.core.universe.world.chunk.section.ChunkLightDataBuilder;
import com.hypixel.hytale.server.core.universe.world.chunk.section.FluidSection;
import com.hypixel.hytale.server.core.universe.world.chunk.section.palette.EmptySectionPalette;
import com.hypixel.hytale.server.core.universe.world.chunk.section.palette.ISectionPalette;
import com.hypixel.hytale.server.core.universe.world.chunk.section.palette.PaletteTypeEnum;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import com.hypixel.hytale.server.core.util.FillerBlockUtil;
import com.hypixel.hytale.server.core.util.io.ByteBufUtil;
import com.hypixel.hytale.sneakythrow.SneakyThrow;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ShortMap;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.lang.ref.SoftReference;
import java.time.Instant;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlockSection
implements Component<ChunkStore> {
    public static final int VERSION = 6;
    public static final BuilderCodec<BlockSection> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(BlockSection.class, BlockSection::new).versioned()).codecVersion(6)).append(new KeyedCodec<byte[]>("Data", Codec.BYTE_ARRAY), BlockSection::deserialize, BlockSection::serialize).add()).build();
    private final StampedLock chunkSectionLock = new StampedLock();
    public boolean loaded = false;
    @Nonnull
    private IntOpenHashSet changedPositions = new IntOpenHashSet(0);
    @Nonnull
    private IntOpenHashSet swapChangedPositions = new IntOpenHashSet(0);
    private ISectionPalette chunkSection;
    private ISectionPalette fillerSection;
    private ISectionPalette rotationSection;
    private ChunkLightData localLight;
    private short localChangeCounter;
    private ChunkLightData globalLight;
    private short globalChangeCounter;
    private BitSet tickingBlocks;
    private final BitSet tickingBlocksCopy;
    @Nonnull
    private final BitSet tickingWaitAdjacentBlocks;
    private int tickingBlocksCount;
    private int tickingBlocksCountCopy;
    private int tickingWaitAdjacentBlockCount;
    private final ObjectHeapPriorityQueue<TickRequest> tickRequests = new ObjectHeapPriorityQueue<TickRequest>(TICK_REQUEST_COMPARATOR);
    private double maximumHitboxExtent = -1.0;
    @Nullable
    private transient SoftReference<CompletableFuture<CachedPacket<SetChunk>>> cachedChunkPacket;
    @Nullable
    @Deprecated(forRemoval=true)
    private FluidSection migratedFluidSection;
    @Nullable
    @Deprecated(forRemoval=true)
    private BlockPhysics migratedBlockPhysics;
    private static final Comparator<TickRequest> TICK_REQUEST_COMPARATOR = Comparator.comparing(t -> t.requestedGameTime);

    public static ComponentType<ChunkStore, BlockSection> getComponentType() {
        return LegacyModule.get().getBlockSectionComponentType();
    }

    public BlockSection() {
        this(EmptySectionPalette.INSTANCE, EmptySectionPalette.INSTANCE, EmptySectionPalette.INSTANCE);
    }

    public BlockSection(ISectionPalette chunkSection, ISectionPalette fillerSection, ISectionPalette rotationSection) {
        this.chunkSection = chunkSection;
        this.fillerSection = fillerSection;
        this.rotationSection = rotationSection;
        this.tickingBlocks = new BitSet();
        this.tickingBlocksCopy = new BitSet();
        this.tickingWaitAdjacentBlocks = new BitSet();
        this.tickingBlocksCount = 0;
        this.tickingBlocksCountCopy = 0;
        this.localLight = ChunkLightData.EMPTY;
        this.localChangeCounter = 0;
        this.globalLight = ChunkLightData.EMPTY;
        this.globalChangeCounter = 0;
    }

    public ISectionPalette getChunkSection() {
        return this.chunkSection;
    }

    public void setChunkSection(ISectionPalette chunkSection) {
        this.chunkSection = chunkSection;
    }

    public void setLocalLight(@Nonnull ChunkLightDataBuilder localLight) {
        Objects.requireNonNull(localLight);
        this.localLight = localLight.build();
    }

    public void setGlobalLight(@Nonnull ChunkLightDataBuilder globalLight) {
        Objects.requireNonNull(globalLight);
        this.globalLight = globalLight.build();
    }

    public ChunkLightData getLocalLight() {
        return this.localLight;
    }

    public ChunkLightData getGlobalLight() {
        return this.globalLight;
    }

    public boolean hasLocalLight() {
        return this.localLight.getChangeId() == this.localChangeCounter;
    }

    public boolean hasGlobalLight() {
        return this.globalLight.getChangeId() == this.globalChangeCounter;
    }

    public void invalidateLocalLight() {
        this.localChangeCounter = (short)(this.localChangeCounter + 1);
        this.invalidateGlobalLight();
    }

    public void invalidateGlobalLight() {
        this.globalChangeCounter = (short)(this.globalChangeCounter + 1);
    }

    public short getLocalChangeCounter() {
        return this.localChangeCounter;
    }

    public short getGlobalChangeCounter() {
        return this.globalChangeCounter;
    }

    public void invalidate() {
        this.cachedChunkPacket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(int index) {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        int i = this.chunkSection.get(index);
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                int n = this.chunkSection.get(index);
                return n;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFiller(int index) {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        int i = this.fillerSection.get(index);
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                int n = this.fillerSection.get(index);
                return n;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return i;
    }

    public int getFiller(int x, int y, int z) {
        return this.getFiller(ChunkUtil.indexBlock(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRotationIndex(int index) {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        int i = this.rotationSection.get(index);
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                int n = this.rotationSection.get(index);
                return n;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return i;
    }

    public int getRotationIndex(int x, int y, int z) {
        return this.getRotationIndex(ChunkUtil.indexBlock(x, y, z));
    }

    public RotationTuple getRotation(int index) {
        return RotationTuple.get(this.getRotationIndex(index));
    }

    public RotationTuple getRotation(int x, int y, int z) {
        return this.getRotation(ChunkUtil.indexBlock(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(int blockIdx, int blockId, int rotation, int filler) {
        boolean changed;
        long lock = this.chunkSectionLock.writeLock();
        try {
            ISectionPalette.SetResult repeatResult;
            ISectionPalette.SetResult result = this.chunkSection.set(blockIdx, blockId);
            if (result == ISectionPalette.SetResult.REQUIRES_PROMOTE) {
                this.chunkSection = this.chunkSection.promote();
                repeatResult = this.chunkSection.set(blockIdx, blockId);
                if (repeatResult != ISectionPalette.SetResult.ADDED_OR_REMOVED) {
                    throw new IllegalStateException("Promoted chunk section failed to correctly add the new block!");
                }
            } else {
                if (result == ISectionPalette.SetResult.ADDED_OR_REMOVED) {
                    this.maximumHitboxExtent = -1.0;
                }
                if (this.chunkSection.shouldDemote()) {
                    this.chunkSection = this.chunkSection.demote();
                }
            }
            changed = result != ISectionPalette.SetResult.UNCHANGED;
            result = this.fillerSection.set(blockIdx, filler);
            if (result == ISectionPalette.SetResult.REQUIRES_PROMOTE) {
                this.fillerSection = this.fillerSection.promote();
                repeatResult = this.fillerSection.set(blockIdx, filler);
                if (repeatResult != ISectionPalette.SetResult.ADDED_OR_REMOVED) {
                    throw new IllegalStateException("Promoted chunk section failed to correctly add the new block!");
                }
            } else if (this.fillerSection.shouldDemote()) {
                this.fillerSection = this.fillerSection.demote();
            }
            changed |= result != ISectionPalette.SetResult.UNCHANGED;
            result = this.rotationSection.set(blockIdx, rotation);
            if (result == ISectionPalette.SetResult.REQUIRES_PROMOTE) {
                this.rotationSection = this.rotationSection.promote();
                repeatResult = this.rotationSection.set(blockIdx, rotation);
                if (repeatResult != ISectionPalette.SetResult.ADDED_OR_REMOVED) {
                    throw new IllegalStateException("Promoted chunk section failed to correctly add the new block!");
                }
            } else if (this.rotationSection.shouldDemote()) {
                this.rotationSection = this.rotationSection.demote();
            }
            if ((changed |= result != ISectionPalette.SetResult.UNCHANGED) && this.loaded) {
                this.changedPositions.add(blockIdx);
            }
        }
        finally {
            this.chunkSectionLock.unlockWrite(lock);
        }
        if (changed) {
            this.invalidateLocalLight();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public IntOpenHashSet getAndClearChangedPositions() {
        long stamp = this.chunkSectionLock.writeLock();
        try {
            this.swapChangedPositions.clear();
            IntOpenHashSet tmp = this.changedPositions;
            this.changedPositions = this.swapChangedPositions;
            this.swapChangedPositions = tmp;
            IntOpenHashSet intOpenHashSet = tmp;
            return intOpenHashSet;
        }
        finally {
            this.chunkSectionLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int id) {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        boolean contains = this.chunkSection.contains(id);
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                boolean bl = this.chunkSection.contains(id);
                return bl;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAny(IntList ids) {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        boolean contains = this.chunkSection.containsAny(ids);
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                boolean bl = this.chunkSection.containsAny(ids);
                return bl;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        int count = this.chunkSection.count();
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                int n = this.chunkSection.count();
                return n;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(int id) {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        int count = this.chunkSection.count(id);
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                int n = this.chunkSection.count(id);
                return n;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntSet values() {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        IntSet values = this.chunkSection.values();
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                IntSet intSet = this.chunkSection.values();
                return intSet;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(IntConsumer consumer) {
        long lock = this.chunkSectionLock.readLock();
        try {
            this.chunkSection.forEachValue(consumer);
        }
        finally {
            this.chunkSectionLock.unlockRead(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Int2ShortMap valueCounts() {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        Int2ShortMap valueCounts = this.chunkSection.valueCounts();
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                Int2ShortMap int2ShortMap = this.chunkSection.valueCounts();
                return int2ShortMap;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return valueCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSolidAir() {
        long lock = this.chunkSectionLock.tryOptimisticRead();
        boolean isSolid = this.chunkSection.isSolid(0);
        if (!this.chunkSectionLock.validate(lock)) {
            lock = this.chunkSectionLock.readLock();
            try {
                boolean bl = this.chunkSection.isSolid(0);
                return bl;
            }
            finally {
                this.chunkSectionLock.unlockRead(lock);
            }
        }
        return isSolid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void find(IntList ids, IntSet internalIdHolder, IntConsumer indexConsumer) {
        long lock = this.chunkSectionLock.readLock();
        try {
            this.chunkSection.find(ids, internalIdHolder, indexConsumer);
        }
        finally {
            this.chunkSectionLock.unlockRead(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTicking(int blockIdx, boolean ticking) {
        long readStamp = this.chunkSectionLock.readLock();
        try {
            if (this.tickingBlocks.get(blockIdx) == ticking) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.chunkSectionLock.unlockRead(readStamp);
        }
        long writeStamp = this.chunkSectionLock.writeLock();
        try {
            if (this.tickingBlocks.get(blockIdx) != ticking) {
                this.tickingBlocksCount = ticking ? ++this.tickingBlocksCount : --this.tickingBlocksCount;
                this.tickingBlocks.set(blockIdx, ticking);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.chunkSectionLock.unlockWrite(writeStamp);
        }
    }

    public int getTickingBlocksCount() {
        return this.tickingBlocksCount > 0 ? this.tickingBlocksCount : 0;
    }

    public int getTickingBlocksCountCopy() {
        return this.tickingBlocksCountCopy;
    }

    public boolean hasTicking() {
        return this.tickingBlocksCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTicking(int blockIdx) {
        if (this.tickingBlocksCount > 0) {
            long readStamp = this.chunkSectionLock.readLock();
            try {
                boolean bl = this.tickingBlocks.get(blockIdx);
                return bl;
            }
            finally {
                this.chunkSectionLock.unlockRead(readStamp);
            }
        }
        return false;
    }

    public void scheduleTick(int index, @Nullable Instant gameTime) {
        if (gameTime == null) {
            return;
        }
        this.tickRequests.enqueue(new TickRequest(index, gameTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preTick(Instant gameTime) {
        while (!this.tickRequests.isEmpty()) {
            TickRequest request = this.tickRequests.first();
            if (!request.requestedGameTime.isBefore(gameTime)) break;
            this.tickRequests.dequeue();
            this.setTicking(request.index, true);
        }
        long writeStamp = this.chunkSectionLock.writeLock();
        try {
            if (this.tickingBlocksCount == 0) {
                this.tickingBlocksCountCopy = 0;
                return;
            }
            BitSetUtil.copyValues(this.tickingBlocks, this.tickingBlocksCopy);
            this.tickingBlocksCountCopy = this.tickingBlocksCount;
            this.tickingBlocks.clear();
            this.tickingBlocksCount = 0;
        }
        finally {
            this.chunkSectionLock.unlockWrite(writeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T, V> int forEachTicking(T t, V v, int sectionIndex, @Nonnull ObjectPositionBlockFunction<T, V, BlockTickStrategy> acceptor) {
        if (this.tickingBlocksCountCopy == 0) {
            return 0;
        }
        sectionStartYBlock = sectionIndex << 5;
        ticked = 0;
        index = this.tickingBlocksCopy.nextSetBit(0);
        while (index >= 0) {
            x = ChunkUtil.xFromIndex(index);
            y = ChunkUtil.yFromIndex(index);
            z = ChunkUtil.zFromIndex(index);
            strategy = acceptor.accept(t, v, x, y | sectionStartYBlock, z, this.get(index));
            writeStamp = this.chunkSectionLock.writeLock();
            try {
                switch (1.$SwitchMap$com$hypixel$hytale$server$core$asset$type$blocktick$BlockTickStrategy[strategy.ordinal()]) {
                    case 1: {
                        if (this.tickingWaitAdjacentBlocks.get(index)) ** break;
                        ++this.tickingWaitAdjacentBlockCount;
                        this.tickingWaitAdjacentBlocks.set(index, true);
                        ** break;
lbl19:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        if (this.tickingBlocks.get(index)) ** break;
                        ++this.tickingBlocksCount;
                        this.tickingBlocks.set(index, true);
                        break;
                    }
                    ** default:
lbl26:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.chunkSectionLock.unlockWrite(writeStamp);
            }
            ++ticked;
            index = this.tickingBlocksCopy.nextSetBit(index + 1);
        }
        return ticked;
    }

    public void mergeTickingBlocks() {
        long writeStamp = this.chunkSectionLock.writeLock();
        try {
            this.tickingBlocks.or(this.tickingWaitAdjacentBlocks);
            this.tickingBlocksCount = this.tickingBlocks.cardinality();
            this.tickingWaitAdjacentBlocks.clear();
            this.tickingWaitAdjacentBlockCount = 0;
        }
        finally {
            this.chunkSectionLock.unlockWrite(writeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaximumHitboxExtent() {
        double extent = this.maximumHitboxExtent;
        if (extent != -1.0) {
            return extent;
        }
        double maximumExtent = BlockBoundingBoxes.UNIT_BOX_MAXIMUM_EXTENT;
        long lock = this.chunkSectionLock.readLock();
        try {
            IndexedLookupTableAssetMap<String, BlockBoundingBoxes> hitBoxAssetMap = BlockBoundingBoxes.getAssetMap();
            BlockTypeAssetMap<String, BlockType> blockTypeMap = BlockType.getAssetMap();
            for (int idx = 0; idx < 32768; ++idx) {
                double boxMaximumExtent;
                int blockId = this.chunkSection.get(idx);
                if (blockId == 0) continue;
                int rotation = this.rotationSection.get(idx);
                BlockType blockType = blockTypeMap.getAsset(blockId);
                BlockBoundingBoxes asset = hitBoxAssetMap.getAsset(blockType.getHitboxTypeIndex());
                if (asset == BlockBoundingBoxes.UNIT_BOX || !((boxMaximumExtent = asset.get(rotation).getBoundingBox().getMaximumExtent()) > maximumExtent)) continue;
                maximumExtent = boxMaximumExtent;
            }
        }
        finally {
            this.chunkSectionLock.unlockRead(lock);
        }
        this.maximumHitboxExtent = maximumExtent;
        return this.maximumHitboxExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void invalidateBlock(int x, int y, int z) {
        long stamp = this.chunkSectionLock.writeLock();
        try {
            this.changedPositions.add(ChunkUtil.indexBlock(x, y, z));
        }
        finally {
            this.chunkSectionLock.unlockWrite(stamp);
        }
    }

    @Nullable
    @Deprecated(forRemoval=true)
    public FluidSection takeMigratedFluid() {
        FluidSection temp = this.migratedFluidSection;
        this.migratedFluidSection = null;
        return temp;
    }

    @Nullable
    @Deprecated(forRemoval=true)
    public BlockPhysics takeMigratedDecoBlocks() {
        BlockPhysics temp = this.migratedBlockPhysics;
        this.migratedBlockPhysics = null;
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeForPacket(@Nonnull ByteBuf buf) {
        long lock = this.chunkSectionLock.readLock();
        try {
            PaletteType paletteType = this.chunkSection.getPaletteType();
            byte paletteTypeId = (byte)paletteType.ordinal();
            buf.writeByte(paletteTypeId);
            this.chunkSection.serializeForPacket(buf);
            PaletteType fillerType = this.fillerSection.getPaletteType();
            byte fillerTypeId = (byte)fillerType.ordinal();
            buf.writeByte(fillerTypeId);
            this.fillerSection.serializeForPacket(buf);
            PaletteType rotationType = this.rotationSection.getPaletteType();
            byte rotationTypeId = (byte)rotationType.ordinal();
            buf.writeByte(rotationTypeId);
            this.rotationSection.serializeForPacket(buf);
        }
        finally {
            this.chunkSectionLock.unlockRead(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(ISectionPalette.KeySerializer keySerializer, @Nonnull ByteBuf buf) {
        long lock = this.chunkSectionLock.readLock();
        try {
            buf.writeInt(BlockMigration.getAssetMap().getAssetCount());
            PaletteType paletteType = this.chunkSection.getPaletteType();
            buf.writeByte(paletteType.ordinal());
            this.chunkSection.serialize(keySerializer, buf);
            if (paletteType != PaletteType.Empty) {
                BitSet combinedTickingBlock = (BitSet)this.tickingBlocks.clone();
                combinedTickingBlock.or(this.tickingWaitAdjacentBlocks);
                buf.writeShort(combinedTickingBlock.cardinality());
                long[] data = combinedTickingBlock.toLongArray();
                buf.writeShort(data.length);
                for (long l : data) {
                    buf.writeLong(l);
                }
            }
            buf.writeByte(this.fillerSection.getPaletteType().ordinal());
            this.fillerSection.serialize(ByteBuf::writeShort, buf);
            buf.writeByte(this.rotationSection.getPaletteType().ordinal());
            this.rotationSection.serialize(ByteBuf::writeByte, buf);
            this.localLight.serialize(buf);
            this.globalLight.serialize(buf);
            buf.writeShort(this.localChangeCounter);
            buf.writeShort(this.globalChangeCounter);
        }
        finally {
            this.chunkSectionLock.unlockRead(lock);
        }
    }

    public byte[] serialize(ExtraInfo extraInfo) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        try {
            this.serialize(BlockType.KEY_SERIALIZER, buf);
            return ByteBufUtil.getBytesRelease(buf);
        }
        catch (Throwable t) {
            buf.release();
            throw SneakyThrow.sneakyThrow(t);
        }
    }

    public void deserialize(ToIntFunction<ByteBuf> keyDeserializer, @Nonnull ByteBuf buf, int version) {
        int blockMigrationVersion = 0;
        if (version >= 6) {
            blockMigrationVersion = buf.readInt();
        }
        Function<String, String> blockMigration = null;
        Map<Integer, BlockMigration> blockMigrationMap = BlockMigration.getAssetMap().getAssetMap();
        BlockMigration migration = blockMigrationMap.get(blockMigrationVersion);
        while (migration != null) {
            blockMigration = blockMigration == null ? migration::getMigration : blockMigration.andThen(migration::getMigration);
            migration = blockMigrationMap.get(++blockMigrationVersion);
        }
        PaletteTypeEnum typeEnum = PaletteTypeEnum.get(buf.readByte());
        PaletteType paletteType = typeEnum.getPaletteType();
        this.chunkSection = typeEnum.getConstructor().get();
        if (version <= 4) {
            ISectionPalette tempSection = typeEnum.getConstructor().get();
            boolean[] foundMigratable = new boolean[]{false};
            boolean[] needsPhysics = new boolean[]{false};
            int[] nextTempIndex = new int[]{-1};
            Int2ObjectOpenHashMap types = new Int2ObjectOpenHashMap();
            Object2IntOpenHashMap typesRev = new Object2IntOpenHashMap();
            typesRev.defaultReturnValue(Integer.MIN_VALUE);
            Function<String, String> finalBlockMigration = blockMigration;
            tempSection.deserialize(bytebuf -> {
                int index;
                String key = ByteBufUtil.readUTF(bytebuf);
                if (finalBlockMigration != null) {
                    key = (String)finalBlockMigration.apply(key);
                }
                if ((index = typesRev.getInt(key)) != Integer.MIN_VALUE) {
                    return index;
                }
                boolean migratable = key.startsWith("Fluid_") || key.contains("|Fluid=") || key.contains("|Deco") || key.contains("|Support") || key.contains("|Filler") || key.contains("|Yaw=") || key.contains("|Pitch=") || key.contains("|Roll=");
                foundMigratable[0] = foundMigratable[0] | migratable;
                if (migratable) {
                    int n = nextTempIndex[0];
                    nextTempIndex[0] = n - 1;
                    index = n;
                } else {
                    index = BlockType.getBlockIdOrUnknown(key, "Unknown BlockType %s", key);
                    needsPhysics[0] = needsPhysics[0] | BlockType.getAssetMap().getAsset(index).hasSupport();
                }
                types.put(index, key);
                typesRev.put(key, index);
                return index;
            }, buf, version);
            if (needsPhysics[0]) {
                this.migratedBlockPhysics = new BlockPhysics();
            }
            if (foundMigratable[0]) {
                for (int index = 0; index < 32768; ++index) {
                    int endOfName;
                    int rotation;
                    ISectionPalette.SetResult result;
                    int end;
                    int id = tempSection.get(index);
                    if (id >= 0) {
                        this.chunkSection.set(index, id);
                        continue;
                    }
                    Rotation rotationYaw = Rotation.None;
                    Rotation rotationPitch = Rotation.None;
                    Rotation rotationRoll = Rotation.None;
                    String key = (String)types.get(id);
                    if (key.startsWith("Fluid_") || key.contains("|Fluid=")) {
                        Fluid.ConversionResult result2;
                        if (this.migratedFluidSection == null) {
                            this.migratedFluidSection = new FluidSection();
                        }
                        if ((result2 = Fluid.convertBlockToFluid(key)) == null) {
                            throw new RuntimeException("Invalid Fluid Key " + key);
                        }
                        if (result2.blockTypeStr != null) {
                            key = result2.blockTypeStr;
                            this.migratedFluidSection.setFluid(index, result2.fluidId, result2.fluidLevel);
                        } else {
                            this.migratedFluidSection.setFluid(index, result2.fluidId, result2.fluidLevel);
                            continue;
                        }
                    }
                    if (key.contains("|Deco")) {
                        if (this.migratedBlockPhysics == null) {
                            this.migratedBlockPhysics = new BlockPhysics();
                        }
                        this.migratedBlockPhysics.set(index, 15);
                    }
                    if (key.contains("|Support=")) {
                        int start;
                        if (this.migratedBlockPhysics == null) {
                            this.migratedBlockPhysics = new BlockPhysics();
                        }
                        if ((end = key.indexOf(124, start = key.indexOf("|Support=") + "|Support=".length())) == -1) {
                            end = key.length();
                        }
                        this.migratedBlockPhysics.set(index, Integer.parseInt(key, start, end, 10));
                    }
                    if (key.contains("|Filler=")) {
                        int fillerZ;
                        int fillerY;
                        int fillerX;
                        int filler;
                        ISectionPalette.SetResult result3;
                        int start = key.indexOf("|Filler=") + "|Filler=".length();
                        int firstComma = key.indexOf(44, start);
                        if (firstComma == -1) {
                            throw new IllegalArgumentException("Invalid filler metadata! Missing comma");
                        }
                        int secondComma = key.indexOf(44, firstComma + 1);
                        if (secondComma == -1) {
                            throw new IllegalArgumentException("Invalid filler metadata! Missing second comma");
                        }
                        int end2 = key.indexOf(124, start);
                        if (end2 == -1) {
                            end2 = key.length();
                        }
                        if ((result3 = this.fillerSection.set(index, filler = FillerBlockUtil.pack(fillerX = Integer.parseInt(key, start, firstComma, 10), fillerY = Integer.parseInt(key, firstComma + 1, secondComma, 10), fillerZ = Integer.parseInt(key, secondComma + 1, end2, 10)))) == ISectionPalette.SetResult.REQUIRES_PROMOTE) {
                            this.fillerSection = this.fillerSection.promote();
                            this.fillerSection.set(index, filler);
                        }
                    }
                    if (key.contains("|Yaw=")) {
                        int start = key.indexOf("|Yaw=") + "|Yaw=".length();
                        end = key.indexOf(124, start);
                        if (end == -1) {
                            end = key.length();
                        }
                        rotationYaw = Rotation.ofDegrees(Integer.parseInt(key, start, end, 10));
                    }
                    if (key.contains("|Pitch=")) {
                        int start = key.indexOf("|Pitch=") + "|Pitch=".length();
                        end = key.indexOf(124, start);
                        if (end == -1) {
                            end = key.length();
                        }
                        rotationPitch = Rotation.ofDegrees(Integer.parseInt(key, start, end, 10));
                    }
                    if (key.contains("|Roll=")) {
                        int start = key.indexOf("|Roll=") + "|Roll=".length();
                        end = key.indexOf(124, start);
                        if (end == -1) {
                            end = key.length();
                        }
                        rotationRoll = Rotation.ofDegrees(Integer.parseInt(key, start, end, 10));
                    }
                    if ((rotationYaw != Rotation.None || rotationPitch != Rotation.None || rotationRoll != Rotation.None) && (result = this.rotationSection.set(index, rotation = RotationTuple.index(rotationYaw, rotationPitch, rotationRoll))) == ISectionPalette.SetResult.REQUIRES_PROMOTE) {
                        this.rotationSection = this.rotationSection.promote();
                        this.rotationSection.set(index, rotation);
                    }
                    if ((endOfName = key.indexOf(124)) != -1) {
                        key = key.substring(0, endOfName);
                    }
                    this.chunkSection.set(index, BlockType.getBlockIdOrUnknown(key, "Unknown BlockType: %s", key));
                }
                if (this.chunkSection.shouldDemote()) {
                    this.chunkSection.demote();
                }
            } else {
                this.chunkSection = tempSection;
            }
        } else if (blockMigration != null) {
            Function<String, String> finalBlockMigration1 = blockMigration;
            this.chunkSection.deserialize(bytebuf -> {
                String key = ByteBufUtil.readUTF(bytebuf);
                key = (String)finalBlockMigration1.apply(key);
                return BlockType.getBlockIdOrUnknown(key, "Unknown BlockType %s", key);
            }, buf, version);
        } else {
            this.chunkSection.deserialize(keyDeserializer, buf, version);
        }
        if (paletteType != PaletteType.Empty) {
            this.tickingBlocksCount = buf.readUnsignedShort();
            int len = buf.readUnsignedShort();
            long[] tickingBlocksData = new long[len];
            for (int i = 0; i < tickingBlocksData.length; ++i) {
                tickingBlocksData[i] = buf.readLong();
            }
            this.tickingBlocks = BitSet.valueOf(tickingBlocksData);
            this.tickingBlocksCount = this.tickingBlocks.cardinality();
        }
        if (version >= 4) {
            PaletteTypeEnum fillerTypeEnum = PaletteTypeEnum.get(buf.readByte());
            this.fillerSection = fillerTypeEnum.getConstructor().get();
            this.fillerSection.deserialize(ByteBuf::readUnsignedShort, buf, version);
        }
        if (version >= 5) {
            PaletteTypeEnum rotationTypeEnum = PaletteTypeEnum.get(buf.readByte());
            this.rotationSection = rotationTypeEnum.getConstructor().get();
            this.rotationSection.deserialize(ByteBuf::readUnsignedByte, buf, version);
        }
        this.localLight = ChunkLightData.deserialize(buf, version);
        this.globalLight = ChunkLightData.deserialize(buf, version);
        this.localChangeCounter = buf.readShort();
        this.globalChangeCounter = buf.readShort();
    }

    public void deserialize(@Nonnull byte[] bytes, @Nonnull ExtraInfo extraInfo) {
        ByteBuf buf = Unpooled.wrappedBuffer(bytes);
        this.deserialize(BlockType.KEY_DESERIALIZER, buf, extraInfo.getVersion());
    }

    @Override
    public Component<ChunkStore> clone() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    @Nonnull
    public Component<ChunkStore> cloneSerializable() {
        return this;
    }

    @Nonnull
    public CompletableFuture<CachedPacket<SetChunk>> getCachedChunkPacket(int x, int y, int z) {
        CompletableFuture<CachedPacket<SetChunk>> future;
        SoftReference<CompletableFuture<CachedPacket<SetChunk>>> ref = this.cachedChunkPacket;
        CompletableFuture<CachedPacket<SetChunk>> completableFuture = future = ref != null ? ref.get() : null;
        if (future != null) {
            return future;
        }
        future = CompletableFuture.supplyAsync(() -> {
            byte[] localLightArr = null;
            byte[] globalLightArr = null;
            byte[] data = null;
            if (BlockChunk.SEND_LOCAL_LIGHTING_DATA && this.hasLocalLight()) {
                ChunkLightData localLight = this.getLocalLight();
                ByteBuf buffer = Unpooled.buffer();
                localLight.serializeForPacket(buffer);
                if (this.getLocalChangeCounter() == localLight.getChangeId()) {
                    localLightArr = ByteBufUtil.getBytesRelease(buffer);
                }
            }
            if (BlockChunk.SEND_GLOBAL_LIGHTING_DATA && this.hasGlobalLight()) {
                ByteBuf buffer = Unpooled.buffer();
                ChunkLightData globalLight = this.getGlobalLight();
                globalLight.serializeForPacket(buffer);
                if (this.getGlobalChangeCounter() == globalLight.getChangeId()) {
                    globalLightArr = ByteBufUtil.getBytesRelease(buffer);
                }
            }
            if (!this.isSolidAir()) {
                ByteBuf buf = Unpooled.buffer(65536);
                this.serializeForPacket(buf);
                data = ByteBufUtil.getBytesRelease(buf);
            }
            SetChunk setChunk = new SetChunk(x, y, z, localLightArr, globalLightArr, data);
            return CachedPacket.cache(setChunk);
        });
        this.cachedChunkPacket = new SoftReference<CompletableFuture<CachedPacket<SetChunk>>>(future);
        return future;
    }

    public int get(int x, int y, int z) {
        return this.get(ChunkUtil.indexBlock(x, y, z));
    }

    public boolean set(int x, int y, int z, int blockId, int rotation, int filler) {
        return this.set(ChunkUtil.indexBlock(x, y, z), blockId, rotation, filler);
    }

    public boolean setTicking(int x, int y, int z, boolean ticking) {
        return this.setTicking(ChunkUtil.indexBlock(x, y, z), ticking);
    }

    public boolean isTicking(int x, int y, int z) {
        return this.isTicking(ChunkUtil.indexBlock(x, y, z));
    }

    private record TickRequest(int index, @Nonnull Instant requestedGameTime) {
    }
}

