/*
 * Decompiled with CFR 0.152.
 */
package com.hypixel.hytale.server.npc.role;

import com.hypixel.hytale.common.util.StringUtil;
import java.util.EnumSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum RoleDebugFlags implements Supplier<String>
{
    TraceFail("Trace failed steps"),
    TraceSuccess("Trace matched steps"),
    TraceSensorFailures("Trace failing sensors"),
    Flock("Trace flock events"),
    FlockDamage("Trace flock damage events"),
    MotionControllerSteer("Trace steering activity of motion controllers"),
    Collisions("Trace collision information of motion controllers"),
    BlockCollisions("Trace collisions down to block level"),
    ProbeBlockCollisions("Trace collisions down to block level when probing"),
    MotionControllerMove("Trace movement activity of motion controllers"),
    ValidatePositions("Validate computed movement positions are not intersecting blocks"),
    SteeringRole("Debug blended steering behaviour from role like avoidance/separation"),
    DisplayState("Set display name to contents of state"),
    DisplayFlock("Set display name to flock state"),
    DisplayTime("Set display name to day time"),
    DisplayTarget("Set display name to locked target type"),
    DisplayAnim("Display animation state"),
    DisplayLightLevel("Display light levels"),
    DisplayCustom("Display custom debug information (generated by debug components)"),
    DisplayHP("Display NPC HP as numerical values"),
    DisplayStamina("Display NPC Stamina as numerical values"),
    Overlaps("Log overlapping blocks when validating position"),
    Pathfinder("Display pathfinder status"),
    DisplaySpeed("Display speed of entity"),
    DisplayFreeSlots("Display free inventory slots"),
    DisplayInternalId("Display the internal server ID for this entity"),
    DisplayName("Display the role name for this entity"),
    ValidateMath("Validate (some) math computations in movement"),
    VisAvoidance("Visualize avoidance vectors"),
    VisSeparation("Visualize separation vector"),
    BeaconMessages("Enable debugging of beacon message sending and receiving");

    private static final RoleDebugPreset[] presets;
    private final String description;

    private RoleDebugFlags(String description) {
        this.description = description;
    }

    @Override
    public String get() {
        return this.description;
    }

    @Nonnull
    public static EnumSet<RoleDebugFlags> getFlags(@Nonnull String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Missing debug flags! " + RoleDebugFlags.getValidNameString());
        }
        EnumSet<RoleDebugFlags> flags = EnumSet.noneOf(RoleDebugFlags.class);
        for (String arg : args) {
            RoleDebugFlags debugFlag = (RoleDebugFlags)StringUtil.parseEnum((Enum[])((RoleDebugFlags[])RoleDebugFlags.class.getEnumConstants()), (String)arg, (StringUtil.MatchType)StringUtil.MatchType.CASE_INSENSITIVE);
            if (debugFlag != null) {
                flags.add(debugFlag);
                continue;
            }
            EnumSet<RoleDebugFlags> preset = RoleDebugFlags.findPreset(arg);
            if (preset == null) {
                throw new IllegalArgumentException("Invalid flag/preset '" + arg + "'! " + RoleDebugFlags.getValidNameString());
            }
            flags.addAll(preset);
        }
        return flags;
    }

    @Nonnull
    public static StringBuilder getListOfFlags(@Nonnull EnumSet<RoleDebugFlags> flags, @Nonnull StringBuilder stringBuilder) {
        boolean comma = false;
        for (RoleDebugFlags flag : RoleDebugFlags.values()) {
            if (!flags.contains(flag)) continue;
            if (comma) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(flag);
            comma = true;
        }
        return stringBuilder;
    }

    public static StringBuilder getListOfAllFlags(@Nonnull StringBuilder stringBuilder) {
        return RoleDebugFlags.getListOfFlags(EnumSet.allOf(RoleDebugFlags.class), stringBuilder);
    }

    public static StringBuilder getListOfAllPresets(@Nonnull StringBuilder stringBuilder) {
        boolean comma = false;
        for (RoleDebugPreset preset : presets) {
            if (comma) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(preset.name);
            comma = true;
        }
        return stringBuilder;
    }

    @Nonnull
    public static EnumSet<RoleDebugFlags> getPreset(String arg) {
        EnumSet<RoleDebugFlags> preset = RoleDebugFlags.findPreset(arg);
        if (preset == null) {
            throw new IllegalArgumentException("Invalid flag/preset '" + arg + "'! " + RoleDebugFlags.getValidNameString());
        }
        EnumSet<RoleDebugFlags> flags = EnumSet.noneOf(RoleDebugFlags.class);
        flags.addAll(preset);
        return flags;
    }

    @Nonnull
    private static String getValidNameString() {
        StringBuilder result = new StringBuilder();
        result.append("Valid presets are: ");
        boolean comma = false;
        for (RoleDebugPreset preset : presets) {
            if (comma) {
                result.append(", ");
            }
            result.append(preset.name);
            comma = true;
        }
        result.append(". Valid flags are: ");
        RoleDebugFlags.getListOfFlags(EnumSet.allOf(RoleDebugFlags.class), result);
        return result.toString();
    }

    @Nullable
    private static EnumSet<RoleDebugFlags> findPreset(String name) {
        for (RoleDebugPreset preset : presets) {
            if (!preset.name.equalsIgnoreCase(name)) continue;
            return preset.config;
        }
        return null;
    }

    public static boolean havePreset(String name) {
        for (RoleDebugPreset preset : presets) {
            if (!preset.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    static {
        presets = new RoleDebugPreset[]{new RoleDebugPreset("none", EnumSet.noneOf(RoleDebugFlags.class)), new RoleDebugPreset("all", EnumSet.allOf(RoleDebugFlags.class)), new RoleDebugPreset("move", EnumSet.of(MotionControllerMove, Collisions)), new RoleDebugPreset("steer", EnumSet.of(MotionControllerMove, MotionControllerSteer, Collisions)), new RoleDebugPreset("valid", EnumSet.of(MotionControllerMove, MotionControllerSteer, Collisions, ValidatePositions)), new RoleDebugPreset("block", EnumSet.of(MotionControllerMove, MotionControllerSteer, Collisions, BlockCollisions)), new RoleDebugPreset("visDist", EnumSet.of(VisAvoidance, VisSeparation)), new RoleDebugPreset("display", EnumSet.of(DisplayState, new RoleDebugFlags[]{DisplayFlock, DisplayTime, DisplayTarget, DisplayAnim, DisplayLightLevel, DisplayCustom, DisplayHP, DisplayStamina, DisplaySpeed, DisplayFreeSlots, DisplayInternalId, DisplayName})), new RoleDebugPreset("default", EnumSet.complementOf(EnumSet.of(ValidatePositions)))};
    }

    private static class RoleDebugPreset {
        public String name;
        public EnumSet<RoleDebugFlags> config;

        private RoleDebugPreset(String name, EnumSet<RoleDebugFlags> config) {
            this.name = name;
            this.config = config;
        }
    }
}

